/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.concurrent;

import com.openexchange.concurrent.TimeoutListener;
import com.openexchange.exception.OXException;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.timer.ScheduledTimerTask;
import com.openexchange.timer.TimerService;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class TimeoutConcurrentMap<K, V> {
    private final ConcurrentMap<K, ValueWrapper<V>> map;
    private final ScheduledTimerTask timeoutTask;
    private final boolean forceTimeout;
    private volatile TimeoutListener<V> defaultTimeoutListener;
    private volatile boolean disposed;

    public TimeoutConcurrentMap(int shrinkerIntervalSeconds) throws OXException {
        this(shrinkerIntervalSeconds, false);
    }

    public TimeoutConcurrentMap(int shrinkerIntervalSeconds, boolean forceTimeout) throws OXException {
        this.forceTimeout = forceTimeout;
        this.map = new ConcurrentHashMap<K, ValueWrapper<V>>();
        TimerService timer = ServerServiceRegistry.getInstance().getService(TimerService.class, true);
        int delay = shrinkerIntervalSeconds * 1000;
        this.timeoutTask = timer.scheduleWithFixedDelay(new TimedRunnable<K, V>(this.map), (long)delay, (long)delay);
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public Set<K> keySet() {
        return this.map.keySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        if (this.disposed) {
            return;
        }
        TimeoutConcurrentMap timeoutConcurrentMap = this;
        synchronized (timeoutConcurrentMap) {
            if (this.disposed) {
                return;
            }
            this.timeoutTask.cancel(true);
            TimerService timer = ServerServiceRegistry.getInstance().getService(TimerService.class);
            if (null != timer) {
                timer.purge();
            }
            this.clear();
            this.disposed = true;
        }
    }

    public void clear() {
        this.map.clear();
    }

    public void timeoutAll() {
        if (this.disposed) {
            throw new IllegalStateException("time-out map was disposed.");
        }
        Iterator it = this.map.values().iterator();
        while (it.hasNext()) {
            ValueWrapper vw = (ValueWrapper)it.next();
            it.remove();
            if (vw.timeoutListener == null) continue;
            vw.timeoutListener.onTimeout(vw.value);
        }
    }

    public void timeout(K key) {
        if (this.disposed) {
            throw new IllegalStateException("time-out map was disposed.");
        }
        ValueWrapper vw = (ValueWrapper)this.map.remove(key);
        if (vw != null && vw.timeoutListener != null) {
            vw.timeoutListener.onTimeout(vw.value);
        }
    }

    public V put(K key, V value, int timeToLiveSeconds) {
        return this.put(key, value, timeToLiveSeconds, this.defaultTimeoutListener);
    }

    public V put(K key, V value, int timeToLiveSeconds, TimeoutListener<V> timeoutListener) {
        if (this.disposed) {
            throw new IllegalStateException("time-out map was disposed.");
        }
        ValueWrapper<V> vw = this.map.put(key, new ValueWrapper<V>(value, timeToLiveSeconds * 1000, this.forceTimeout, timeoutListener));
        if (null == vw) {
            return null;
        }
        return vw.value;
    }

    public V putIfAbsent(K key, V value, int timeToLiveSeconds) {
        return this.putIfAbsent(key, value, timeToLiveSeconds, this.defaultTimeoutListener);
    }

    public V putIfAbsent(K key, V value, int timeToLiveSeconds, TimeoutListener<V> timeoutListener) {
        if (this.disposed) {
            throw new IllegalStateException("time-out map was disposed.");
        }
        ValueWrapper<V> vw = this.map.putIfAbsent(key, new ValueWrapper<V>(value, timeToLiveSeconds * 1000, this.forceTimeout, timeoutListener));
        if (null == vw) {
            return null;
        }
        return vw.value;
    }

    public boolean containsKey(K key) {
        return this.map.containsKey(key);
    }

    public V get(K key) {
        ValueWrapper vw = (ValueWrapper)this.map.get(key);
        if (null == vw) {
            return null;
        }
        return vw.touch();
    }

    public V remove(K key) {
        if (this.disposed) {
            throw new IllegalStateException("time-out map was disposed.");
        }
        ValueWrapper vw = (ValueWrapper)this.map.remove(key);
        if (null == vw) {
            return null;
        }
        return vw.value;
    }

    public TimeoutListener<V> getDefaultTimeoutListener() {
        return this.defaultTimeoutListener;
    }

    public void setDefaultTimeoutListener(TimeoutListener<V> defaultTimeoutListener) {
        this.defaultTimeoutListener = defaultTimeoutListener;
    }

    private static final class TimedRunnable<K, V>
    implements Runnable {
        private final ConcurrentMap<K, ValueWrapper<V>> tmap;

        TimedRunnable(ConcurrentMap<K, ValueWrapper<V>> tmap) {
            this.tmap = tmap;
        }

        @Override
        public void run() {
            long now = System.currentTimeMillis();
            Iterator it = this.tmap.values().iterator();
            while (it.hasNext()) {
                ValueWrapper vw = (ValueWrapper)it.next();
                if (now - vw.lastAccessed <= vw.ttl) continue;
                it.remove();
                TimeoutListener timeoutListener = vw.timeoutListener;
                if (timeoutListener == null) continue;
                timeoutListener.onTimeout(vw.value);
            }
        }
    }

    private static final class ValueWrapper<V> {
        public final V value;
        public final long ttl;
        public final TimeoutListener<V> timeoutListener;
        public final boolean forceTimeout;
        public volatile long lastAccessed;

        public ValueWrapper(V value, long ttl, boolean forceTimeout, TimeoutListener<V> timeoutListener) {
            this.value = value;
            this.ttl = ttl;
            this.lastAccessed = System.currentTimeMillis();
            this.timeoutListener = timeoutListener;
            this.forceTimeout = forceTimeout;
        }

        public V touch() {
            if (this.forceTimeout) {
                return this.value;
            }
            this.lastAccessed = System.currentTimeMillis();
            return this.value;
        }
    }
}

