/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.api2;

import com.openexchange.api2.LinkSQLInterface;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.LinkObject;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.contexts.impl.ContextStorage;
import com.openexchange.groupware.links.Links;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import com.openexchange.server.impl.DBPool;
import com.openexchange.session.Session;
import java.sql.Connection;

public class RdbLinkSQLInterface
implements LinkSQLInterface {
    private static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(RdbLinkSQLInterface.class));

    @Override
    public LinkObject[] getLinksOfObject(int objectId, int type, int folder, int user, int[] group, Session sessionobject) throws OXException {
        LinkObject[] lo = null;
        Connection readcon = null;
        Context ctx = null;
        try {
            ctx = ContextStorage.getStorageContext(sessionobject.getContextId());
            readcon = DBPool.pickup(ctx);
            lo = Links.getAllLinksFromObject(objectId, type, folder, user, group, sessionobject, readcon);
        }
        catch (OXException ct) {
            throw ct;
        }
        finally {
            if (readcon != null) {
                DBPool.closeReaderSilent(ctx, readcon);
            }
        }
        return lo;
    }

    @Override
    public LinkObject[] getLinksByObjectID(int objectId, int type, int user, int[] group, Session sessionobject) throws OXException {
        LinkObject[] lo = null;
        Connection readcon = null;
        Context ctx = null;
        try {
            ctx = ContextStorage.getStorageContext(sessionobject.getContextId());
            readcon = DBPool.pickup(ctx);
            lo = Links.getAllLinksByObjectID(objectId, type, user, group, sessionobject, readcon);
        }
        catch (OXException ct) {
            throw ct;
        }
        finally {
            if (readcon != null) {
                DBPool.closeReaderSilent(ctx, readcon);
            }
        }
        return lo;
    }

    @Override
    public void saveLink(LinkObject l, int user, int[] group, Session so) throws OXException {
        Connection writecon = null;
        Context ctx = null;
        try {
            ctx = ContextStorage.getStorageContext(so.getContextId());
            writecon = DBPool.pickupWriteable(ctx);
            Links.performLinkStorage(l, user, group, so, writecon);
        }
        catch (OXException ct) {
            throw ct;
        }
        finally {
            if (writecon != null) {
                DBPool.closeWriterSilent(ctx, writecon);
            }
        }
    }

    @Override
    public int[][] deleteLinks(int id, int type, int folder, int[][] data, int user, int[] group, Session sessionobject) throws OXException {
        Context ctx;
        Connection writecon;
        int[][] resp;
        block7: {
            resp = null;
            writecon = null;
            Connection readcon = null;
            ctx = null;
            try {
                ctx = ContextStorage.getStorageContext(sessionobject.getContextId());
                readcon = DBPool.pickup(ctx);
                writecon = DBPool.pickupWriteable(ctx);
                resp = Links.deleteLinkFromObject(id, type, folder, data, user, group, sessionobject, readcon, writecon);
                if (readcon == null) break block7;
            }
            catch (OXException ct) {
                try {
                    throw ct;
                }
                catch (Throwable throwable) {
                    if (readcon != null) {
                        DBPool.closeReaderSilent(ctx, readcon);
                    }
                    if (writecon != null) {
                        DBPool.closeWriterSilent(ctx, writecon);
                    }
                    throw throwable;
                }
            }
            DBPool.closeReaderSilent(ctx, readcon);
        }
        if (writecon != null) {
            DBPool.closeWriterSilent(ctx, writecon);
        }
        return resp;
    }
}

