/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.writer;

import com.openexchange.ajax.writer.WriterProcedure;
import com.openexchange.groupware.container.DataObject;
import com.openexchange.tools.TimeZoneUtils;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.math.BigDecimal;
import java.util.Date;
import java.util.TimeZone;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONValue;
import org.json.JSONWriter;

public class DataWriter {
    protected TimeZone timeZone;
    static final TimeZone UTC = TimeZoneUtils.getTimeZone("UTC");
    protected JSONWriter jsonwriter;
    private static final FieldWriter<DataObject> OBJECT_ID_WRITER = new FieldWriter<DataObject>(){

        @Override
        public void write(DataObject obj, TimeZone timeZone, JSONArray json) {
            DataWriter.writeValue(obj.getObjectID(), json, obj.containsObjectID());
        }

        @Override
        public void write(DataObject obj, TimeZone timeZone, JSONObject json) throws JSONException {
            DataWriter.writeParameter("id", obj.getObjectID(), json, obj.containsObjectID());
        }
    };
    private static final FieldWriter<DataObject> CREATED_BY_WRITER = new FieldWriter<DataObject>(){

        @Override
        public void write(DataObject obj, TimeZone timeZone, JSONArray json) {
            DataWriter.writeValue(obj.getCreatedBy(), json, obj.containsCreatedBy());
        }

        @Override
        public void write(DataObject obj, TimeZone timeZone, JSONObject json) throws JSONException {
            DataWriter.writeParameter("created_by", obj.getCreatedBy(), json, obj.containsCreatedBy());
        }
    };
    private static final FieldWriter<DataObject> CREATION_DATE_WRITER = new FieldWriter<DataObject>(){

        @Override
        public void write(DataObject obj, TimeZone timeZone, JSONArray json) {
            DataWriter.writeValue(obj.getCreationDate(), timeZone, json, obj.containsCreationDate());
        }

        @Override
        public void write(DataObject obj, TimeZone timeZone, JSONObject json) throws JSONException {
            DataWriter.writeParameter("creation_date", obj.getCreationDate(), timeZone, json);
        }
    };
    private static final FieldWriter<DataObject> MODIFIED_BY_WRITER = new FieldWriter<DataObject>(){

        @Override
        public void write(DataObject obj, TimeZone timeZone, JSONArray json) {
            DataWriter.writeValue(obj.getModifiedBy(), json, obj.containsModifiedBy());
        }

        @Override
        public void write(DataObject obj, TimeZone timeZone, JSONObject json) throws JSONException {
            DataWriter.writeParameter("modified_by", obj.getModifiedBy(), json, obj.containsModifiedBy());
        }
    };
    private static final FieldWriter<DataObject> LAST_MODIFIED_WRITER = new FieldWriter<DataObject>(){

        @Override
        public void write(DataObject obj, TimeZone timeZone, JSONArray json) {
            DataWriter.writeValue(obj.getLastModified(), timeZone, json, obj.containsLastModified());
        }

        @Override
        public void write(DataObject obj, TimeZone timeZone, JSONObject json) throws JSONException {
            DataWriter.writeParameter("last_modified", obj.getLastModified(), timeZone, json, obj.containsLastModified());
        }
    };
    private static final FieldWriter<DataObject> LAST_MODIFIED_UTC_WRITER = new FieldWriter<DataObject>(){

        @Override
        public void write(DataObject obj, TimeZone timeZone, JSONArray json) {
            DataWriter.writeValue(obj.getLastModified(), UTC, json, obj.containsLastModified());
        }

        @Override
        public void write(DataObject obj, TimeZone timeZone, JSONObject json) throws JSONException {
            DataWriter.writeParameter("last_modified_utc", obj.getLastModified(), UTC, json, obj.containsLastModified());
        }
    };
    private static final TIntObjectMap<FieldWriter<DataObject>> WRITER_MAP;

    protected DataWriter(TimeZone timeZone, JSONWriter writer) {
        this.timeZone = timeZone;
        this.jsonwriter = writer;
    }

    public void writeParameter(String name, String value) throws JSONException {
        if (value != null && value.length() > 0) {
            this.jsonwriter.key(name);
            this.jsonwriter.value((Object)value);
        }
    }

    public void writeParameter(String name, Date value) throws JSONException {
        if (value != null) {
            this.jsonwriter.key(name);
            this.jsonwriter.value(value.getTime());
        }
    }

    public static void writeParameter(String name, String value, JSONObject json) throws JSONException {
        if (value != null && value.length() > 0) {
            json.put(name, (Object)value);
        }
    }

    public static void writeParameter(String name, String value, JSONObject json, boolean condition) throws JSONException {
        if (condition) {
            DataWriter.writeParameter(name, value, json);
        }
    }

    public static void writeParameter(String name, JSONValue value, JSONObject json) throws JSONException {
        if (value != null) {
            json.put(name, (Object)value);
        }
    }

    public static void writeParameter(String name, JSONValue value, JSONObject json, boolean condition) throws JSONException {
        if (condition) {
            json.put(name, (Object)value);
        }
    }

    public static void writeParameter(String name, int value, JSONObject json) throws JSONException {
        json.put(name, value);
    }

    public static void writeParameter(String name, int value, JSONObject json, boolean condition) throws JSONException {
        if (condition) {
            DataWriter.writeParameter(name, value, json);
        }
    }

    public static void writeParameter(String name, long value, JSONObject json) throws JSONException {
        DataWriter.writeParameter(name, Long.toString(value), json);
    }

    public static void writeParameter(String name, long value, JSONObject json, boolean condition) throws JSONException {
        DataWriter.writeParameter(name, Long.toString(value), json, condition);
    }

    public static void writeParameter(String name, Long value, JSONObject json, boolean condition) throws JSONException {
        if (null == value) {
            DataWriter.writeNull(name, json, condition);
        } else {
            DataWriter.writeParameter(name, Long.toString(value), json, condition);
        }
    }

    public static void writeParameter(String name, BigDecimal value, JSONObject jsonObj, boolean condition) throws JSONException {
        if (condition) {
            DataWriter.writeParameter(name, value, jsonObj);
        }
    }

    private static void writeParameter(String name, BigDecimal value, JSONObject jsonObj) throws JSONException {
        if (null == value) {
            jsonObj.put(name, JSONObject.NULL);
        } else {
            jsonObj.put(name, (Object)value);
        }
    }

    public static void writeParameter(String name, boolean value, JSONObject jsonObj) throws JSONException {
        jsonObj.put(name, value);
    }

    public static void writeParameter(String name, boolean value, JSONObject jsonObj, boolean condition) throws JSONException {
        if (condition) {
            jsonObj.put(name, value);
        }
    }

    public static void writeParameter(String name, Date value, JSONObject jsonObj) throws JSONException {
        if (value != null) {
            jsonObj.put(name, value.getTime());
        }
    }

    public static void writeParameter(String name, Date value, TimeZone timeZone, JSONObject jsonObj) throws JSONException {
        DataWriter.writeParameter(name, value, value, timeZone, jsonObj);
    }

    static void writeParameter(String name, Date value, TimeZone timeZone, JSONObject json, boolean condition) throws JSONException {
        if (condition) {
            DataWriter.writeParameter(name, value, timeZone, json);
        }
    }

    public static void writeParameter(String name, Date value, Date offsetDate, TimeZone timeZone, JSONObject jsonObj) throws JSONException {
        if (value != null) {
            jsonObj.put(name, value.getTime() + (long)timeZone.getOffset(offsetDate.getTime()));
        }
    }

    public static void writeValue(String value, JSONArray jsonArray) {
        if (value != null && value.length() > 0) {
            jsonArray.put((Object)value);
        } else {
            jsonArray.put(JSONObject.NULL);
        }
    }

    static void writeValue(String value, JSONArray jsonArray, boolean condition) {
        if (condition) {
            DataWriter.writeValue(value, jsonArray);
        } else {
            jsonArray.put(JSONObject.NULL);
        }
    }

    public static void writeValue(int value, JSONArray jsonArray) {
        jsonArray.put(value);
    }

    public static void writeValue(int value, JSONArray jsonArray, boolean condition) {
        if (condition) {
            jsonArray.put(value);
        } else {
            jsonArray.put(JSONObject.NULL);
        }
    }

    public static void writeValue(BigDecimal value, JSONArray jsonArray, boolean condition) {
        if (!condition || null == value) {
            jsonArray.put(JSONObject.NULL);
        } else {
            jsonArray.put((Object)value);
        }
    }

    public static void writeValue(long value, JSONArray jsonArray, boolean condition) {
        DataWriter.writeValue(Long.toString(value), jsonArray, condition);
    }

    public static void writeValue(Long value, JSONArray json, boolean condition) {
        if (condition) {
            DataWriter.writeValue(value.toString(), json);
        } else {
            DataWriter.writeNull(json);
        }
    }

    protected static void writeNull(JSONArray json) {
        json.put(JSONObject.NULL);
    }

    protected static void writeNull(String name, JSONObject json, boolean condition) throws JSONException {
        if (condition) {
            json.put(name, JSONObject.NULL);
        }
    }

    public static void writeValue(boolean value, JSONArray jsonArray) {
        jsonArray.put(value);
    }

    public static void writeValue(boolean value, JSONArray jsonArray, boolean condition) {
        if (condition) {
            jsonArray.put(value);
        } else {
            jsonArray.put(JSONObject.NULL);
        }
    }

    public static void writeValue(Date value, JSONArray jsonArray) {
        if (value == null) {
            jsonArray.put(JSONObject.NULL);
        } else {
            jsonArray.put(value.getTime());
        }
    }

    public static void writeValue(Date value, JSONArray json, boolean condition) {
        if (condition) {
            json.put(value.getTime());
        } else {
            json.put(JSONObject.NULL);
        }
    }

    public static void writeValue(JSONValue value, JSONArray jsonArray) {
        if (value == null) {
            jsonArray.put(JSONObject.NULL);
        } else {
            jsonArray.put((Object)value);
        }
    }

    public static void writeValue(JSONValue value, JSONArray json, boolean condition) {
        if (condition) {
            json.put((Object)value);
        } else {
            json.put(JSONObject.NULL);
        }
    }

    public static void writeValue(Date value, TimeZone timeZone, JSONArray jsonArray) {
        DataWriter.writeValue(value, value, timeZone, jsonArray);
    }

    static void writeValue(Date value, TimeZone timeZone, JSONArray json, boolean condition) {
        if (condition) {
            DataWriter.writeValue(value, timeZone, json);
        } else {
            json.put(JSONObject.NULL);
        }
    }

    public static void writeValue(Date value, Date offsetDate, TimeZone timeZone, JSONArray jsonArray) {
        if (value == null) {
            jsonArray.put(JSONObject.NULL);
        } else {
            int offset = timeZone.getOffset(offsetDate.getTime());
            jsonArray.put(value.getTime() + (long)offset);
        }
    }

    public static void writeValueNull(JSONArray jsonArray) {
        jsonArray.put(JSONObject.NULL);
    }

    protected void writeFields(DataObject obj, TimeZone tz, JSONObject json) throws JSONException {
        JSONException je;
        WriterProcedure<DataObject> procedure = new WriterProcedure<DataObject>(obj, json, tz);
        if (!WRITER_MAP.forEachValue(procedure) && null != (je = procedure.getError())) {
            throw je;
        }
    }

    protected boolean writeField(DataObject obj, int column, TimeZone tz, JSONArray json) throws JSONException {
        FieldWriter writer = (FieldWriter)WRITER_MAP.get(column);
        if (null == writer) {
            return false;
        }
        writer.write(obj, tz, json);
        return true;
    }

    static {
        TIntObjectHashMap m = new TIntObjectHashMap(6, 1.0f);
        m.put(1, OBJECT_ID_WRITER);
        m.put(2, CREATED_BY_WRITER);
        m.put(4, CREATION_DATE_WRITER);
        m.put(3, MODIFIED_BY_WRITER);
        m.put(5, LAST_MODIFIED_WRITER);
        m.put(6, LAST_MODIFIED_UTC_WRITER);
        WRITER_MAP = m;
    }

    protected static interface FieldWriter<T> {
        public void write(T var1, TimeZone var2, JSONArray var3) throws JSONException;

        public void write(T var1, TimeZone var2, JSONObject var3) throws JSONException;
    }
}

