/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.requesthandler.converters.preview.cache;

import com.openexchange.config.ConfigurationService;
import com.openexchange.database.DatabaseService;
import com.openexchange.database.Databases;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.contexts.impl.ContextStorage;
import com.openexchange.groupware.filestore.FilestoreStorage;
import com.openexchange.java.Streams;
import com.openexchange.preview.PreviewExceptionCodes;
import com.openexchange.preview.cache.CachedPreview;
import com.openexchange.preview.cache.PreviewCache;
import com.openexchange.server.ServiceExceptionCode;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.tools.file.FileStorage;
import com.openexchange.tools.file.QuotaFileStorage;
import com.openexchange.tools.file.external.FileStorageCodes;
import gnu.trove.ConcurrentTIntObjectHashMap;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.sql.Connection;
import java.sql.DataTruncation;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public final class FileStorePreviewCacheImpl
implements PreviewCache,
EventHandler {
    private static final Log LOG = com.openexchange.log.Log.loggerFor(FileStorePreviewCacheImpl.class);
    private static final ConcurrentTIntObjectHashMap<FileStorage> FILE_STORE_CACHE = new ConcurrentTIntObjectHashMap();
    private final boolean quotaAware;

    private static FileStorage getFileStorage(Context ctx, boolean quotaAware) throws OXException {
        int key = ctx.getContextId();
        FileStorage fs = (FileStorage)FILE_STORE_CACHE.get(key);
        if (null == fs) {
            URI uri = FilestoreStorage.createURI(ctx);
            FileStorage newFileStorage = quotaAware ? QuotaFileStorage.getInstance(uri, ctx) : FileStorage.getInstance(uri);
            fs = (FileStorage)FILE_STORE_CACHE.putIfAbsent(key, (Object)newFileStorage);
            if (null == fs) {
                fs = newFileStorage;
            }
        }
        return fs;
    }

    private static FileStorage getFileStorage(int contextId, boolean quotaAware) throws OXException {
        return FileStorePreviewCacheImpl.getFileStorage(ContextStorage.getStorageContext(contextId), quotaAware);
    }

    public FileStorePreviewCacheImpl(boolean quotaAware) {
        this.quotaAware = quotaAware;
    }

    private void batchDeleteFiles(Collection<String> ids, FileStorage fileStorage) {
        try {
            fileStorage.deleteFiles(ids.toArray(new String[0]));
        }
        catch (Exception e) {
            for (String id : ids) {
                if (null == id) continue;
                try {
                    fileStorage.deleteFile(id);
                }
                catch (Exception x) {}
            }
        }
    }

    public void handleEvent(Event event) {
        String topic = event.getTopic();
        if ("com/openexchange/groupware/infostore/update".equals(topic)) {
            try {
                Session session = (Session)event.getProperty("session");
                int userId = session.getUserId();
                int contextId = session.getContextId();
                this.removeAlikes(event.getProperty("eTag").toString(), userId, contextId);
            }
            catch (OXException e) {
                LOG.warn((Object)"Couldn't remove cache entry.", (Throwable)e);
            }
        } else if ("com/openexchange/groupware/infostore/delete".equals(topic)) {
            try {
                Session session = (Session)event.getProperty("session");
                int userId = session.getUserId();
                int contextId = session.getContextId();
                this.removeAlikes(event.getProperty("eTag").toString(), userId, contextId);
            }
            catch (OXException e) {
                LOG.warn((Object)"Couldn't remove cache entry.", (Throwable)e);
            }
        }
    }

    public boolean save(String id, CachedPreview preview, int userId, int contextId) throws OXException {
        InputStream in = preview.getInputStream();
        if (null == in) {
            return this.save(id, preview.getBytes(), preview.getFileName(), preview.getFileType(), userId, contextId);
        }
        return this.save(id, in, preview.getFileName(), preview.getFileType(), userId, contextId);
    }

    public boolean save(String id, InputStream in, String optName, String optType, int userId, int contextId) throws OXException {
        try {
            return this.save(id, Streams.stream2bytes((InputStream)in), optName, optType, userId, contextId);
        }
        catch (IOException e) {
            throw PreviewExceptionCodes.IO_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean save(String id, byte[] bytes, String optName, String optType, int userId, int contextId) throws OXException {
        boolean bl;
        PreparedStatement stmt;
        Connection con;
        DatabaseService databaseService;
        block20: {
            String refId = this.optRefId(id, userId, contextId);
            boolean exists = null != refId;
            long[] qts = this.getContextQuota(contextId);
            long total = qts[0];
            long totalPerDocument = qts[0];
            if (total > 0L || totalPerDocument > 0L) {
                String ignoree;
                String string = ignoree = exists ? id : null;
                if (!this.ensureUnexceededContextQuota(bytes.length, total, totalPerDocument, contextId, ignoree)) {
                    return false;
                }
            }
            if ((databaseService = ServerServiceRegistry.getInstance().getService(DatabaseService.class)) == null) {
                throw ServiceExceptionCode.SERVICE_UNAVAILABLE.create(new Object[]{DatabaseService.class.getName()});
            }
            FileStorage fileStorage = FileStorePreviewCacheImpl.getFileStorage(contextId, this.quotaAware);
            if (null != refId) {
                fileStorage.deleteFile(refId);
            }
            refId = fileStorage.saveNewFile(Streams.newByteArrayInputStream((byte[])bytes));
            con = databaseService.getWritable(contextId);
            boolean committed = true;
            stmt = null;
            try {
                con.setAutoCommit(false);
                committed = false;
                long now = System.currentTimeMillis();
                int pos = 1;
                if (exists) {
                    stmt = con.prepareStatement("UPDATE preview SET refId = ?, size = ?, createdAt = ?, fileName = ?, fileType = ? WHERE cid = ? AND user = ? AND id = ?");
                    stmt.setString(pos++, refId);
                    stmt.setLong(pos++, bytes.length);
                    stmt.setLong(pos++, now);
                    if (null == optName) {
                        stmt.setNull(pos++, 12);
                    } else {
                        stmt.setString(pos++, optName);
                    }
                    if (null == optType) {
                        stmt.setNull(pos++, 12);
                    } else {
                        stmt.setString(pos++, optType);
                    }
                    stmt.setLong(pos++, contextId);
                    stmt.setLong(pos++, userId);
                    stmt.setString(pos++, id);
                } else {
                    stmt = con.prepareStatement("INSERT INTO preview (cid, user, id, size, createdAt, refId, fileName, fileType) VALUES (?, ?, ?, ?, ?, ?, ?, ?)");
                    stmt.setLong(pos++, contextId);
                    stmt.setLong(pos++, userId);
                    stmt.setString(pos++, id);
                    stmt.setLong(pos++, bytes.length);
                    stmt.setLong(pos++, now);
                    stmt.setString(pos++, refId);
                    if (null == optName) {
                        stmt.setNull(pos++, 12);
                    } else {
                        stmt.setString(pos++, optName);
                    }
                    if (null == optType) {
                        stmt.setNull(pos++, 12);
                    } else {
                        stmt.setString(pos++, optType);
                    }
                }
                stmt.executeUpdate();
                con.commit();
                committed = true;
                bl = true;
                if (committed) break block20;
            }
            catch (DataTruncation e) {
                try {
                    throw PreviewExceptionCodes.ERROR.create((Throwable)e, new Object[]{e.getMessage()});
                    catch (SQLException e2) {
                        throw PreviewExceptionCodes.ERROR.create((Throwable)e2, new Object[]{e2.getMessage()});
                    }
                }
                catch (Throwable throwable) {
                    if (!committed) {
                        Databases.rollback((Connection)con);
                    }
                    Databases.closeSQLStuff(stmt);
                    Databases.autocommit((Connection)con);
                    databaseService.backWritable(contextId, con);
                    throw throwable;
                }
            }
            Databases.rollback((Connection)con);
        }
        Databases.closeSQLStuff((Statement)stmt);
        Databases.autocommit((Connection)con);
        databaseService.backWritable(contextId, con);
        return bl;
    }

    public long[] getContextQuota(int contextId) {
        long quota = -1L;
        long quotaPerDocument = -1L;
        ConfigurationService confService = ServerServiceRegistry.getInstance().getService(ConfigurationService.class);
        if (null != confService) {
            String property = confService.getProperty("com.openexchange.preview.cache.quota", "10485760").trim();
            try {
                quota = Long.parseLong(property);
            }
            catch (NumberFormatException e) {
                quota = -1L;
            }
            property = confService.getProperty("com.openexchange.preview.cache.quotaPerDocument", "524288").trim();
            try {
                quotaPerDocument = Long.parseLong(property);
            }
            catch (NumberFormatException e) {
                quotaPerDocument = -1L;
            }
        }
        return new long[]{quota, quotaPerDocument};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean ensureUnexceededContextQuota(long desiredSize, long total, long totalPerDocument, int contextId, String ignoree) throws OXException {
        if (total <= 0L) {
            return totalPerDocument <= 0L || desiredSize <= totalPerDocument;
        }
        if (desiredSize > total || desiredSize > totalPerDocument) {
            return false;
        }
        DatabaseService dbService = ServerServiceRegistry.getInstance().getService(DatabaseService.class);
        if (dbService == null) {
            throw ServiceExceptionCode.SERVICE_UNAVAILABLE.create(new Object[]{DatabaseService.class.getName()});
        }
        Connection con = dbService.getReadOnly(contextId);
        boolean readOnly = true;
        try {
            long usedContextQuota = this.getUsedContextQuota(contextId, ignoree, con);
            if (usedContextQuota <= 0L && desiredSize > total) {
                boolean bl = false;
                return bl;
            }
            while (usedContextQuota + desiredSize > total) {
                if (readOnly) {
                    dbService.backReadOnly(contextId, con);
                    con = dbService.getWritable(contextId);
                    readOnly = false;
                }
                this.dropOldestEntry(contextId, con);
                usedContextQuota = this.getUsedContextQuota(contextId, ignoree, con);
                if (usedContextQuota > 0L || desiredSize <= total) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            if (readOnly) {
                dbService.backReadOnly(contextId, con);
            } else {
                dbService.backWritable(contextId, con);
            }
        }
    }

    private void dropOldestEntry(int contextId, Connection con) throws OXException {
        long oldestStamp;
        ResultSet rs;
        PreparedStatement stmt;
        block9: {
            block8: {
                stmt = null;
                rs = null;
                stmt = con.prepareStatement("SELECT MIN(createdAt) FROM preview WHERE cid = ?");
                stmt.setLong(1, contextId);
                rs = stmt.executeQuery();
                if (rs.next()) break block8;
                Databases.closeSQLStuff((ResultSet)rs, (Statement)stmt);
                return;
            }
            oldestStamp = rs.getLong(1);
            if (!rs.wasNull()) break block9;
            Databases.closeSQLStuff((ResultSet)rs, (Statement)stmt);
            return;
        }
        try {
            Databases.closeSQLStuff((ResultSet)rs, (Statement)stmt);
            rs = null;
            stmt = null;
            stmt = con.prepareStatement("SELECT id, refId FROM preview WHERE cid = ? AND createdAt <= ?");
            stmt.setLong(1, contextId);
            stmt.setLong(2, oldestStamp);
            rs = stmt.executeQuery();
            HashMap<String, String> map = new HashMap<String, String>(16);
            while (rs.next()) {
                map.put(rs.getString(1), rs.getString(2));
            }
            Databases.closeSQLStuff((ResultSet)rs, (Statement)stmt);
            rs = null;
            stmt = null;
            if (!map.isEmpty()) {
                stmt = con.prepareStatement("DELETE FROM preview WHERE cid = ? AND createdAt <= ?");
                stmt.setLong(1, contextId);
                stmt.setLong(2, oldestStamp);
                stmt.executeUpdate();
                FileStorage fileStorage = FileStorePreviewCacheImpl.getFileStorage(contextId, this.quotaAware);
                this.batchDeleteFiles(map.values(), fileStorage);
            }
        }
        catch (SQLException e) {
            try {
                throw PreviewExceptionCodes.ERROR.create((Throwable)e, new Object[]{e.getMessage()});
            }
            catch (Throwable throwable) {
                Databases.closeSQLStuff(rs, (Statement)stmt);
                throw throwable;
            }
        }
        Databases.closeSQLStuff((ResultSet)rs, (Statement)stmt);
    }

    private long getUsedContextQuota(int contextId, String ignoree, Connection con) throws OXException {
        long l;
        ResultSet rs;
        PreparedStatement stmt;
        block9: {
            block8: {
                stmt = null;
                rs = null;
                if (null == ignoree) {
                    stmt = con.prepareStatement("SELECT SUM(size) FROM preview WHERE cid = ?");
                    stmt.setLong(1, contextId);
                } else {
                    stmt = con.prepareStatement("SELECT SUM(size) FROM preview WHERE cid = ? AND id <> ?");
                    stmt.setLong(1, contextId);
                    stmt.setString(2, ignoree);
                }
                rs = stmt.executeQuery();
                if (rs.next()) break block8;
                long l2 = 0L;
                Databases.closeSQLStuff((ResultSet)rs, (Statement)stmt);
                return l2;
            }
            if (!rs.wasNull()) break block9;
            long l3 = 0L;
            Databases.closeSQLStuff((ResultSet)rs, (Statement)stmt);
            return l3;
        }
        try {
            l = rs.getLong(1);
        }
        catch (SQLException e) {
            try {
                throw PreviewExceptionCodes.ERROR.create((Throwable)e, new Object[]{e.getMessage()});
            }
            catch (Throwable throwable) {
                Databases.closeSQLStuff(rs, stmt);
                throw throwable;
            }
        }
        Databases.closeSQLStuff((ResultSet)rs, (Statement)stmt);
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearFor(int contextId) throws OXException {
        DatabaseService dbService = ServerServiceRegistry.getInstance().getService(DatabaseService.class);
        if (dbService == null) {
            throw ServiceExceptionCode.SERVICE_UNAVAILABLE.create(new Object[]{DatabaseService.class.getName()});
        }
        Connection con = dbService.getWritable(contextId);
        boolean changed = false;
        try {
            changed = this.clearFor(contextId, con);
        }
        finally {
            if (changed) {
                dbService.backWritable(contextId, con);
            } else {
                dbService.backWritableAfterReading(contextId, con);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean clearFor(int contextId, Connection con) throws OXException {
        ResultSet rs;
        PreparedStatement stmt;
        boolean changed;
        block7: {
            changed = false;
            stmt = null;
            rs = null;
            boolean rollback = false;
            try {
                Databases.startTransaction((Connection)con);
                rollback = true;
                stmt = con.prepareStatement("SELECT id, refId FROM preview WHERE cid=?");
                stmt.setInt(1, contextId);
                rs = stmt.executeQuery();
                HashMap<String, String> map = new HashMap<String, String>(16);
                while (rs.next()) {
                    map.put(rs.getString(1), rs.getString(2));
                }
                Databases.closeSQLStuff((ResultSet)rs, (Statement)stmt);
                rs = null;
                stmt = null;
                if (!map.isEmpty()) {
                    stmt = con.prepareStatement("DELETE FROM preview WHERE cid=?");
                    stmt.setInt(1, contextId);
                    stmt.executeUpdate();
                    changed = true;
                    FileStorage fileStorage = FileStorePreviewCacheImpl.getFileStorage(contextId, this.quotaAware);
                    this.batchDeleteFiles(map.values(), fileStorage);
                }
                con.commit();
                rollback = false;
                if (!rollback) break block7;
            }
            catch (SQLException e) {
                try {
                    throw PreviewExceptionCodes.ERROR.create((Throwable)e, new Object[]{e.getMessage()});
                }
                catch (Throwable throwable) {
                    if (rollback) {
                        Databases.rollback((Connection)con);
                    }
                    Databases.autocommit((Connection)con);
                    Databases.closeSQLStuff(rs, (Statement)stmt);
                    throw throwable;
                }
            }
            Databases.rollback((Connection)con);
        }
        Databases.autocommit((Connection)con);
        Databases.closeSQLStuff((ResultSet)rs, (Statement)stmt);
        return changed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CachedPreview get(String id, int userId, int contextId) throws OXException {
        if (null == id || contextId <= 0) {
            return null;
        }
        DatabaseService dbService = ServerServiceRegistry.getInstance().getService(DatabaseService.class);
        if (dbService == null) {
            throw ServiceExceptionCode.SERVICE_UNAVAILABLE.create(new Object[]{DatabaseService.class.getName()});
        }
        Connection con = dbService.getReadOnly(contextId);
        try {
            CachedPreview cachedPreview = this.load(id, userId, contextId, con);
            return cachedPreview;
        }
        finally {
            dbService.backReadOnly(contextId, con);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CachedPreview load(String id, int userId, int contextId, Connection con) throws OXException {
        CachedPreview cachedPreview;
        ResultSet rs;
        PreparedStatement stmt;
        block8: {
            stmt = null;
            rs = null;
            if (userId > 0) {
                stmt = con.prepareStatement("SELECT refId, fileName, fileType, size FROM preview WHERE cid = ? AND user = ? AND id = ?");
                stmt.setLong(1, contextId);
                stmt.setLong(2, userId);
                stmt.setString(3, id);
            } else {
                stmt = con.prepareStatement("SELECT refId, fileName, fileType, size FROM preview WHERE cid = ? AND id = ?");
                stmt.setLong(1, contextId);
                stmt.setString(2, id);
            }
            rs = stmt.executeQuery();
            if (rs.next()) break block8;
            CachedPreview cachedPreview2 = null;
            Databases.closeSQLStuff((ResultSet)rs, (Statement)stmt);
            return cachedPreview2;
        }
        try {
            String refIf = rs.getString(1);
            FileStorage fileStorage = FileStorePreviewCacheImpl.getFileStorage(contextId, this.quotaAware);
            cachedPreview = new CachedPreview(fileStorage.getFile(refIf), rs.getString(2), rs.getString(3), rs.getLong(4));
        }
        catch (SQLException e) {
            try {
                throw PreviewExceptionCodes.ERROR.create((Throwable)e, new Object[]{e.getMessage()});
                catch (RuntimeException e2) {
                    throw PreviewExceptionCodes.ERROR.create((Throwable)e2, new Object[]{e2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                Databases.closeSQLStuff(rs, stmt);
                throw throwable;
            }
        }
        Databases.closeSQLStuff((ResultSet)rs, (Statement)stmt);
        return cachedPreview;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void remove(int userId, int contextId) throws OXException {
        ResultSet rs;
        PreparedStatement stmt;
        boolean transactionInitiated;
        boolean deletePerformed;
        Connection con;
        DatabaseService databaseService;
        block17: {
            databaseService = ServerServiceRegistry.getInstance().getService(DatabaseService.class);
            if (databaseService == null) {
                throw ServiceExceptionCode.SERVICE_UNAVAILABLE.create(new Object[]{DatabaseService.class.getName()});
            }
            con = databaseService.getWritable(contextId);
            boolean rollback = false;
            deletePerformed = false;
            transactionInitiated = false;
            stmt = null;
            rs = null;
            try {
                if (userId > 0) {
                    stmt = con.prepareStatement("SELECT id, refId FROM preview WHERE cid=? AND user=?");
                    int pos = 1;
                    stmt.setInt(pos++, contextId);
                    stmt.setInt(pos, userId);
                } else {
                    stmt = con.prepareStatement("SELECT id, refId FROM preview WHERE cid=?");
                    stmt.setInt(1, contextId);
                }
                rs = stmt.executeQuery();
                HashMap<String, String> map = new HashMap<String, String>(16);
                while (rs.next()) {
                    map.put(rs.getString(1), rs.getString(2));
                }
                Databases.closeSQLStuff((ResultSet)rs, (Statement)stmt);
                rs = null;
                stmt = null;
                if (!map.isEmpty()) {
                    Databases.startTransaction((Connection)con);
                    rollback = true;
                    transactionInitiated = true;
                    if (userId > 0) {
                        stmt = con.prepareStatement("DELETE FROM preview WHERE cid=? AND user=?");
                        int pos = 1;
                        stmt.setInt(pos++, contextId);
                        stmt.setInt(pos, userId);
                    } else {
                        stmt = con.prepareStatement("DELETE FROM preview WHERE cid=?");
                        stmt.setInt(1, contextId);
                    }
                    stmt.executeUpdate();
                    deletePerformed = true;
                    con.commit();
                    rollback = false;
                    FileStorage fileStorage = FileStorePreviewCacheImpl.getFileStorage(contextId, this.quotaAware);
                    this.batchDeleteFiles(map.values(), fileStorage);
                }
                if (!rollback) break block17;
            }
            catch (DataTruncation e) {
                try {
                    throw PreviewExceptionCodes.ERROR.create((Throwable)e, new Object[]{e.getMessage()});
                    catch (SQLException e2) {
                        throw PreviewExceptionCodes.ERROR.create((Throwable)e2, new Object[]{e2.getMessage()});
                    }
                }
                catch (Throwable throwable) {
                    if (rollback) {
                        Databases.rollback((Connection)con);
                    }
                    Databases.closeSQLStuff(rs, (Statement)stmt);
                    if (transactionInitiated) {
                        Databases.autocommit((Connection)con);
                    }
                    if (deletePerformed) {
                        databaseService.backWritable(contextId, con);
                        throw throwable;
                    }
                    databaseService.backWritableAfterReading(contextId, con);
                    throw throwable;
                }
            }
            Databases.rollback((Connection)con);
        }
        Databases.closeSQLStuff((ResultSet)rs, (Statement)stmt);
        if (transactionInitiated) {
            Databases.autocommit((Connection)con);
        }
        if (deletePerformed) {
            databaseService.backWritable(contextId, con);
            return;
        }
        databaseService.backWritableAfterReading(contextId, con);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void removeAlikes(String id, int userId, int contextId) throws OXException {
        ResultSet rs;
        PreparedStatement stmt;
        boolean transactionInitiated;
        boolean deletePerformed;
        Connection con;
        DatabaseService databaseService;
        block15: {
            databaseService = ServerServiceRegistry.getInstance().getService(DatabaseService.class);
            if (databaseService == null) {
                throw ServiceExceptionCode.SERVICE_UNAVAILABLE.create(new Object[]{DatabaseService.class.getName()});
            }
            if (null == id) {
                throw PreviewExceptionCodes.ERROR.create(new Object[]{"Missing identifier."});
            }
            con = databaseService.getWritable(contextId);
            boolean rollback = false;
            deletePerformed = false;
            transactionInitiated = false;
            stmt = null;
            rs = null;
            try {
                stmt = con.prepareStatement("SELECT id, refId FROM preview WHERE cid=? AND user=? AND id LIKE ?");
                int pos = 1;
                stmt.setInt(pos++, contextId);
                stmt.setInt(pos++, userId);
                stmt.setString(pos, id + "%");
                rs = stmt.executeQuery();
                HashMap<String, String> map = new HashMap<String, String>(16);
                while (rs.next()) {
                    map.put(rs.getString(1), rs.getString(2));
                }
                Databases.closeSQLStuff((ResultSet)rs, (Statement)stmt);
                rs = null;
                stmt = null;
                if (!map.isEmpty()) {
                    Databases.startTransaction((Connection)con);
                    rollback = true;
                    transactionInitiated = true;
                    stmt = con.prepareStatement("DELETE FROM preview WHERE cid=? AND user=? AND id=?");
                    pos = 1;
                    stmt.setInt(pos++, contextId);
                    stmt.setInt(pos++, userId);
                    for (String currentId : map.keySet()) {
                        stmt.setString(pos, currentId);
                        stmt.addBatch();
                    }
                    stmt.executeBatch();
                    deletePerformed = true;
                    con.commit();
                    rollback = false;
                    FileStorage fileStorage = FileStorePreviewCacheImpl.getFileStorage(contextId, this.quotaAware);
                    this.batchDeleteFiles(map.values(), fileStorage);
                }
                if (!rollback) break block15;
            }
            catch (DataTruncation e) {
                try {
                    throw PreviewExceptionCodes.ERROR.create((Throwable)e, new Object[]{e.getMessage()});
                    catch (SQLException e2) {
                        throw PreviewExceptionCodes.ERROR.create((Throwable)e2, new Object[]{e2.getMessage()});
                    }
                }
                catch (Throwable throwable) {
                    if (rollback) {
                        Databases.rollback((Connection)con);
                    }
                    Databases.closeSQLStuff(rs, (Statement)stmt);
                    if (transactionInitiated) {
                        Databases.autocommit((Connection)con);
                    }
                    if (deletePerformed) {
                        databaseService.backWritable(contextId, con);
                        throw throwable;
                    }
                    databaseService.backWritableAfterReading(contextId, con);
                    throw throwable;
                }
            }
            Databases.rollback((Connection)con);
        }
        Databases.closeSQLStuff((ResultSet)rs, (Statement)stmt);
        if (transactionInitiated) {
            Databases.autocommit((Connection)con);
        }
        if (deletePerformed) {
            databaseService.backWritable(contextId, con);
            return;
        }
        databaseService.backWritableAfterReading(contextId, con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exists(String id, int userId, int contextId) throws OXException {
        if (null == id || contextId <= 0) {
            return false;
        }
        DatabaseService dbService = ServerServiceRegistry.getInstance().getService(DatabaseService.class);
        if (dbService == null) {
            throw ServiceExceptionCode.SERVICE_UNAVAILABLE.create(new Object[]{DatabaseService.class.getName()});
        }
        Connection con = dbService.getReadOnly(contextId);
        try {
            boolean bl = null != this.optRefId(id, userId, contextId, con);
            return bl;
        }
        finally {
            dbService.backReadOnly(contextId, con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String optRefId(String id, int userId, int contextId) throws OXException {
        if (null == id || contextId <= 0) {
            return null;
        }
        DatabaseService dbService = ServerServiceRegistry.getInstance().getService(DatabaseService.class);
        if (dbService == null) {
            throw ServiceExceptionCode.SERVICE_UNAVAILABLE.create(new Object[]{DatabaseService.class.getName()});
        }
        Connection con = dbService.getReadOnly(contextId);
        try {
            String string = this.optRefId(id, userId, contextId, con);
            return string;
        }
        finally {
            dbService.backReadOnly(contextId, con);
        }
    }

    private String optRefId(String id, int userId, int contextId, Connection con) throws OXException {
        String string;
        String refId;
        ResultSet rs;
        PreparedStatement stmt;
        block13: {
            block12: {
                stmt = null;
                rs = null;
                if (userId > 0) {
                    stmt = con.prepareStatement("SELECT refId FROM preview WHERE cid = ? AND user = ? AND id = ?");
                    stmt.setLong(1, contextId);
                    stmt.setLong(2, userId);
                    stmt.setString(3, id);
                } else {
                    stmt = con.prepareStatement("SELECT refId FROM preview WHERE cid = ? AND id = ?");
                    stmt.setLong(1, contextId);
                    stmt.setString(2, id);
                }
                rs = stmt.executeQuery();
                if (rs.next()) break block12;
                String string2 = null;
                Databases.closeSQLStuff((ResultSet)rs, (Statement)stmt);
                return string2;
            }
            refId = rs.getString(1);
            if (null != refId) break block13;
            this.dropFromTable(id, userId, contextId);
            String string3 = null;
            Databases.closeSQLStuff((ResultSet)rs, (Statement)stmt);
            return string3;
        }
        FileStorage fileStorage = FileStorePreviewCacheImpl.getFileStorage(contextId, this.quotaAware);
        try {
            Streams.close((Closeable)fileStorage.getFile(refId));
        }
        catch (OXException e) {
            if (!FileStorageCodes.FILE_NOT_FOUND.equals(e)) {
                throw e;
            }
            this.dropFromTable(id, userId, contextId);
            String string4 = null;
            Databases.closeSQLStuff((ResultSet)rs, (Statement)stmt);
            return string4;
        }
        try {
            string = refId;
        }
        catch (SQLException e) {
            try {
                throw PreviewExceptionCodes.ERROR.create((Throwable)e, new Object[]{e.getMessage()});
            }
            catch (Throwable throwable) {
                Databases.closeSQLStuff(rs, stmt);
                throw throwable;
            }
        }
        Databases.closeSQLStuff((ResultSet)rs, (Statement)stmt);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void dropFromTable(String id, int userId, int contextId) {
        DatabaseService dbService = ServerServiceRegistry.getInstance().getService(DatabaseService.class);
        if (dbService != null) {
            Connection con = null;
            PreparedStatement stmt = null;
            try {
                con = dbService.getWritable(contextId);
                if (userId > 0) {
                    stmt = con.prepareStatement("DELETE FROM preview WHERE cid = ? AND user = ? AND id = ?");
                    stmt.setLong(1, contextId);
                    stmt.setLong(2, userId);
                    stmt.setString(3, id);
                } else {
                    stmt = con.prepareStatement("DELETE FROM preview WHERE cid = ? AND id = ?");
                    stmt.setLong(1, contextId);
                    stmt.setString(2, id);
                }
                stmt.executeUpdate();
            }
            catch (Exception e) {
                Databases.closeSQLStuff(stmt);
                if (null != con) {
                    dbService.backWritable(contextId, con);
                }
                catch (Throwable throwable) {
                    Databases.closeSQLStuff(stmt);
                    if (null != con) {
                        dbService.backWritable(contextId, con);
                    }
                    throw throwable;
                }
            }
            Databases.closeSQLStuff((Statement)stmt);
            if (null != con) {
                dbService.backWritable(contextId, con);
            }
        }
    }
}

