/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.request;

import com.openexchange.ajax.Mail;
import com.openexchange.ajax.tools.JSONUtil;
import com.openexchange.exception.OXException;
import com.openexchange.java.StringAllocator;
import com.openexchange.json.OXJSONWriter;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.mail.MailJSONField;
import com.openexchange.mail.MailServletInterface;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import com.openexchange.tools.session.ServerSession;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONWriter;

public final class MailRequest {
    private static final Log LOG = com.openexchange.log.Log.loggerFor(MailRequest.class);
    static final String PARAMETER_ID = "id";
    static final String FOLDER_ID = "folder_id";
    static final String KEY = MailJSONField.FLAGS.getKey();
    static final String COLORLABEL = "color_label";
    static final String DATA = "data";
    static final String PARAMETER_FOLDERID = "folder";
    static final Mail MAIL_SERVLET = new Mail();
    private static final Map<String, Handler> HANDERS_MAP;
    private final ServerSession session;
    private final OXJSONWriter writer;
    private CollectObject collectObj;
    private boolean contCollecting;

    public MailRequest(ServerSession session, OXJSONWriter writer) {
        this.session = session;
        this.writer = writer;
    }

    public void action(String action, JSONObject jsonObject, MailServletInterface mailInterface) throws OXException, JSONException {
        if (!this.session.getUserPermissionBits().hasWebMail()) {
            throw AjaxExceptionCodes.NO_PERMISSION_FOR_MODULE.create("mail");
        }
        if (null == action) {
            throw AjaxExceptionCodes.MISSING_PARAMETER.create("action");
        }
        String act = MailRequest.toLowerCase(action);
        Handler handler = HANDERS_MAP.get(act);
        if (null != handler) {
            handler.requestPerformed(this.session, this.writer, jsonObject, mailInterface);
            return;
        }
        if ("update".equals(act)) {
            if (MailRequest.isMove(jsonObject)) {
                this.handleMultiple(jsonObject, mailInterface, CollectableOperation.MOVE);
            } else if (MailRequest.isStoreFlags(jsonObject)) {
                this.handleMultiple(jsonObject, mailInterface, CollectableOperation.STORE_FLAG);
            } else if (MailRequest.isColorLabel(jsonObject)) {
                this.handleMultiple(jsonObject, mailInterface, CollectableOperation.COLOR_LABEL);
            } else {
                MAIL_SERVLET.actionPutUpdateMail(this.session, this.writer, jsonObject, mailInterface);
            }
        } else if ("copy".equals(act)) {
            this.handleMultiple(jsonObject, mailInterface, CollectableOperation.COPY);
        } else {
            throw MailExceptionCode.UNKNOWN_ACTION.create(action);
        }
    }

    private void handleMultiple(JSONObject jsonObject, MailServletInterface mailInterface, CollectableOperation op) throws OXException {
        if (this.collectObj == null) {
            this.collectObj = CollectObject.newInstance(jsonObject, op, MAIL_SERVLET);
            this.collectObj.addCollectable(jsonObject);
            this.contCollecting = true;
        } else if (this.collectObj.collectable(jsonObject, op)) {
            this.collectObj.addCollectable(jsonObject);
            this.contCollecting = true;
        } else {
            try {
                this.performMultipleInternal(mailInterface);
                this.collectObj = CollectObject.newInstance(jsonObject, op, MAIL_SERVLET);
                this.collectObj.addCollectable(jsonObject);
                this.contCollecting = false;
            }
            catch (JSONException e) {
                throw AjaxExceptionCodes.JSON_ERROR.create(e, e.getMessage());
            }
        }
    }

    public boolean isContiguousCollect() {
        return this.contCollecting;
    }

    public void performMultiple(MailServletInterface mailInterface) throws OXException {
        if (this.collectObj != null) {
            try {
                this.performMultipleInternal(mailInterface);
                this.collectObj = null;
            }
            catch (JSONException e) {
                throw AjaxExceptionCodes.JSON_ERROR.create(e, e.getMessage());
            }
        }
    }

    private void performMultipleInternal(MailServletInterface mailInterface) throws JSONException {
        if (LOG.isDebugEnabled()) {
            long start = System.currentTimeMillis();
            this.collectObj.performOperations(this.session, this.writer, mailInterface);
            long dur = System.currentTimeMillis() - start;
            LOG.debug((Object)new StringAllocator(128).append("Multiple '").append(MailRequest.getOpName(this.collectObj.getOperation())).append("' mail request successfully performed: ").append(dur).append("msec").toString());
        } else {
            this.collectObj.performOperations(this.session, this.writer, mailInterface);
        }
    }

    public static boolean isMove(JSONObject jsonObject) throws JSONException {
        return jsonObject.has(DATA) && jsonObject.getJSONObject(DATA).has(FOLDER_ID);
    }

    public static boolean isStoreFlags(JSONObject jsonObject) throws JSONException {
        return jsonObject.has(PARAMETER_ID) && jsonObject.has(DATA) && jsonObject.getJSONObject(DATA).has(KEY);
    }

    public static boolean isColorLabel(JSONObject jsonObject) throws JSONException {
        return jsonObject.has(PARAMETER_ID) && jsonObject.has(DATA) && jsonObject.getJSONObject(DATA).has(COLORLABEL);
    }

    private static String getOpName(CollectableOperation op) {
        switch (op) {
            case MOVE: {
                return "Move";
            }
            case COPY: {
                return "Copy";
            }
            case STORE_FLAG: {
                return "Store Flag";
            }
            case COLOR_LABEL: {
                return "Color Label";
            }
        }
        throw new InternalError("Unknown collectable operation: " + (Object)((Object)op));
    }

    private static String toLowerCase(CharSequence chars) {
        if (null == chars) {
            return null;
        }
        int length = chars.length();
        StringAllocator builder = new StringAllocator(length);
        for (int i = 0; i < length; ++i) {
            char c = chars.charAt(i);
            builder.append(c >= 'A' && c <= 'Z' ? (char)(c ^ 0x20) : c);
        }
        return builder.toString();
    }

    static {
        HashMap<String, Handler> m = new HashMap<String, Handler>(24);
        m.put("all", new Handler(){

            @Override
            public void requestPerformed(ServerSession session, JSONWriter writer, JSONObject jsonObject, MailServletInterface mailInterface) throws OXException, JSONException {
                MAIL_SERVLET.actionGetAllMails(session, writer, jsonObject, mailInterface);
            }
        });
        m.put("count", new Handler(){

            @Override
            public void requestPerformed(ServerSession session, JSONWriter writer, JSONObject jsonObject, MailServletInterface mailInterface) throws OXException, JSONException {
                MAIL_SERVLET.actionGetMailCount(session, writer, jsonObject, mailInterface);
            }
        });
        m.put("updates", new Handler(){

            @Override
            public void requestPerformed(ServerSession session, JSONWriter writer, JSONObject jsonObject, MailServletInterface mailInterface) throws OXException, JSONException {
                MAIL_SERVLET.actionGetUpdates(session, writer, jsonObject, mailInterface);
            }
        });
        m.put("reply", new Handler(){

            @Override
            public void requestPerformed(ServerSession session, JSONWriter writer, JSONObject jsonObject, MailServletInterface mailInterface) throws OXException, JSONException {
                if (jsonObject.has(MailRequest.DATA) && !jsonObject.isNull(MailRequest.DATA)) {
                    MAIL_SERVLET.actionPutReply(session, false, writer, jsonObject, mailInterface);
                } else {
                    MAIL_SERVLET.actionGetReply(session, writer, jsonObject, false, mailInterface);
                }
            }
        });
        m.put("replyall", new Handler(){

            @Override
            public void requestPerformed(ServerSession session, JSONWriter writer, JSONObject jsonObject, MailServletInterface mailInterface) throws OXException, JSONException {
                if (jsonObject.has(MailRequest.DATA) && !jsonObject.isNull(MailRequest.DATA)) {
                    MAIL_SERVLET.actionPutReply(session, true, writer, jsonObject, mailInterface);
                } else {
                    MAIL_SERVLET.actionGetReply(session, writer, jsonObject, true, mailInterface);
                }
            }
        });
        m.put("forward", new Handler(){

            @Override
            public void requestPerformed(ServerSession session, JSONWriter writer, JSONObject jsonObject, MailServletInterface mailInterface) throws OXException, JSONException {
                if (jsonObject.has(MailRequest.DATA) && !jsonObject.isNull(MailRequest.DATA)) {
                    MAIL_SERVLET.actionPutForwardMultiple(session, writer, jsonObject, mailInterface);
                } else {
                    MAIL_SERVLET.actionGetForward(session, writer, jsonObject, mailInterface);
                }
            }
        });
        m.put("get", new Handler(){

            @Override
            public void requestPerformed(ServerSession session, JSONWriter writer, JSONObject jsonObject, MailServletInterface mailInterface) throws OXException, JSONException {
                if (jsonObject.has(MailRequest.DATA) && !jsonObject.isNull(MailRequest.DATA)) {
                    MAIL_SERVLET.actionPutGet(session, writer, jsonObject, mailInterface);
                } else {
                    MAIL_SERVLET.actionGetMessage(session, writer, jsonObject, mailInterface);
                }
            }
        });
        m.put("get_structure", new Handler(){

            @Override
            public void requestPerformed(ServerSession session, JSONWriter writer, JSONObject jsonObject, MailServletInterface mailInterface) throws OXException, JSONException {
                MAIL_SERVLET.actionGetStructure(session, writer, jsonObject, mailInterface);
            }
        });
        m.put("attachment", new Handler(){

            @Override
            public void requestPerformed(ServerSession session, JSONWriter writer, JSONObject jsonObject, MailServletInterface mailInterface) throws OXException, JSONException {
                MAIL_SERVLET.actionGetAttachment();
            }
        });
        m.put("attachmenttoken", new Handler(){

            @Override
            public void requestPerformed(ServerSession session, JSONWriter writer, JSONObject jsonObject, MailServletInterface mailInterface) throws OXException, JSONException {
                MAIL_SERVLET.actionGetAttachmentToken(session, writer, jsonObject, mailInterface);
            }
        });
        m.put("newmsgs", new Handler(){

            @Override
            public void requestPerformed(ServerSession session, JSONWriter writer, JSONObject jsonObject, MailServletInterface mailInterface) throws OXException, JSONException {
                MAIL_SERVLET.actionGetNew(session, writer, jsonObject, mailInterface);
            }
        });
        m.put("list", new Handler(){

            @Override
            public void requestPerformed(ServerSession session, JSONWriter writer, JSONObject jsonObject, MailServletInterface mailInterface) throws OXException, JSONException {
                MAIL_SERVLET.actionPutMailList(session, writer, jsonObject, mailInterface);
            }
        });
        m.put("delete", new Handler(){

            @Override
            public void requestPerformed(ServerSession session, JSONWriter writer, JSONObject jsonObject, MailServletInterface mailInterface) throws OXException, JSONException {
                MAIL_SERVLET.actionPutDeleteMails(session, writer, jsonObject, mailInterface);
            }
        });
        m.put("transport", new Handler(){

            @Override
            public void requestPerformed(ServerSession session, JSONWriter writer, JSONObject jsonObject, MailServletInterface mailInterface) throws OXException, JSONException {
                MAIL_SERVLET.actionPutTransportMail(session, writer, jsonObject, mailInterface);
            }
        });
        m.put("receipt_ack", new Handler(){

            @Override
            public void requestPerformed(ServerSession session, JSONWriter writer, JSONObject jsonObject, MailServletInterface mailInterface) throws OXException, JSONException {
                MAIL_SERVLET.actionPutReceiptAck(session, writer, jsonObject, mailInterface);
            }
        });
        m.put("search", new Handler(){

            @Override
            public void requestPerformed(ServerSession session, JSONWriter writer, JSONObject jsonObject, MailServletInterface mailInterface) throws OXException, JSONException {
                MAIL_SERVLET.actionPutMailSearch(session, writer, jsonObject, mailInterface);
            }
        });
        m.put("clear", new Handler(){

            @Override
            public void requestPerformed(ServerSession session, JSONWriter writer, JSONObject jsonObject, MailServletInterface mailInterface) throws OXException, JSONException {
                MAIL_SERVLET.actionPutClear(session, writer, jsonObject, mailInterface);
            }
        });
        HANDERS_MAP = m;
    }

    private static final class ColorCollectObject
    extends CollectObject {
        private final String srcFld;
        private final int flagInt;

        public ColorCollectObject(JSONObject dataObject, Mail mailServlet) throws OXException {
            super(mailServlet);
            this.srcFld = JSONUtil.requireString(MailRequest.PARAMETER_FOLDERID, dataObject);
            this.flagInt = JSONUtil.requireInt(MailJSONField.COLOR_LABEL.getKey(), JSONUtil.requireDataObject(dataObject));
        }

        @Override
        public boolean collectable(JSONObject dataObject, CollectableOperation op) throws OXException {
            return CollectableOperation.COLOR_LABEL.equals((Object)op) && this.srcFld.equals(JSONUtil.requireString(MailRequest.PARAMETER_FOLDERID, dataObject)) && this.flagInt == JSONUtil.requireInt(MailJSONField.COLOR_LABEL.getKey(), JSONUtil.requireDataObject(dataObject));
        }

        @Override
        public CollectableOperation getOperation() {
            return CollectableOperation.COLOR_LABEL;
        }

        @Override
        public void performOperations(ServerSession session, OXJSONWriter writer, MailServletInterface mailInterface) throws JSONException {
            this.mailServlet.actionPutColorLabelMultiple(session, writer, this.getMailIDs(), this.srcFld, this.flagInt, mailInterface);
        }
    }

    private static final class FlagsCollectObject
    extends CollectObject {
        private final String srcFld;
        private final int flagInt;
        private final boolean flagValue;

        public FlagsCollectObject(JSONObject dataObject, Mail mailServlet) throws OXException {
            super(mailServlet);
            this.srcFld = JSONUtil.requireString(MailRequest.PARAMETER_FOLDERID, dataObject);
            JSONObject bodyObj = JSONUtil.requireDataObject(dataObject);
            this.flagInt = JSONUtil.requireInt(MailJSONField.FLAGS.getKey(), bodyObj);
            this.flagValue = JSONUtil.requireBoolean(MailJSONField.VALUE.getKey(), bodyObj);
        }

        @Override
        public boolean collectable(JSONObject dataObject, CollectableOperation op) throws OXException {
            JSONObject bodyObj = JSONUtil.requireDataObject(dataObject);
            return CollectableOperation.STORE_FLAG.equals((Object)op) && this.srcFld.equals(JSONUtil.requireString(MailRequest.PARAMETER_FOLDERID, dataObject)) && this.flagInt == JSONUtil.requireInt(MailJSONField.FLAGS.getKey(), bodyObj) && this.flagValue == JSONUtil.requireBoolean(MailJSONField.VALUE.getKey(), bodyObj);
        }

        @Override
        public CollectableOperation getOperation() {
            return CollectableOperation.STORE_FLAG;
        }

        @Override
        public void performOperations(ServerSession session, OXJSONWriter writer, MailServletInterface mailInterface) throws JSONException {
            this.mailServlet.actionPutStoreFlagsMultiple(session, writer, this.getMailIDs(), this.srcFld, this.flagInt, this.flagValue, mailInterface);
        }
    }

    private static final class CopyCollectObject
    extends CollectObject {
        private final String srcFld;
        private final String destFld;

        public CopyCollectObject(JSONObject dataObject, Mail mailServlet) throws OXException {
            super(mailServlet);
            this.srcFld = JSONUtil.requireString(MailRequest.PARAMETER_FOLDERID, dataObject);
            this.destFld = JSONUtil.requireString(MailRequest.FOLDER_ID, JSONUtil.requireDataObject(dataObject));
        }

        @Override
        public boolean collectable(JSONObject dataObject, CollectableOperation op) throws OXException {
            return CollectableOperation.COPY.equals((Object)op) && this.srcFld.equals(JSONUtil.requireString(MailRequest.PARAMETER_FOLDERID, dataObject)) && this.destFld.equals(JSONUtil.requireString(MailRequest.FOLDER_ID, JSONUtil.requireDataObject(dataObject)));
        }

        @Override
        public CollectableOperation getOperation() {
            return CollectableOperation.COPY;
        }

        @Override
        public void performOperations(ServerSession session, OXJSONWriter writer, MailServletInterface mailInterface) throws JSONException {
            this.mailServlet.actionPutMailMultiple(session, writer, this.getMailIDs(), this.srcFld, this.destFld, false, mailInterface);
        }
    }

    private static final class MoveCollectObject
    extends CollectObject {
        private final String srcFld;
        private final String destFld;

        public MoveCollectObject(JSONObject dataObject, Mail mailServlet) throws OXException {
            super(mailServlet);
            this.srcFld = JSONUtil.requireString(MailRequest.PARAMETER_FOLDERID, dataObject);
            this.destFld = JSONUtil.requireString(MailRequest.FOLDER_ID, JSONUtil.requireDataObject(dataObject));
        }

        @Override
        public boolean collectable(JSONObject dataObject, CollectableOperation op) throws OXException {
            return CollectableOperation.MOVE.equals((Object)op) && this.srcFld.equals(JSONUtil.requireString(MailRequest.PARAMETER_FOLDERID, dataObject)) && this.destFld.equals(JSONUtil.requireString(MailRequest.FOLDER_ID, JSONUtil.requireDataObject(dataObject)));
        }

        @Override
        public CollectableOperation getOperation() {
            return CollectableOperation.MOVE;
        }

        @Override
        public void performOperations(ServerSession session, OXJSONWriter writer, MailServletInterface mailInterface) throws JSONException {
            this.mailServlet.actionPutMailMultiple(session, writer, this.getMailIDs(), this.srcFld, this.destFld, true, mailInterface);
        }
    }

    private static abstract class CollectObject {
        protected final Mail mailServlet;
        protected final List<String> mailIDs = new ArrayList<String>();

        public static CollectObject newInstance(JSONObject jsonObject, CollectableOperation op, Mail mailServlet) throws OXException {
            switch (op) {
                case COPY: {
                    return new CopyCollectObject(jsonObject, mailServlet);
                }
                case MOVE: {
                    return new MoveCollectObject(jsonObject, mailServlet);
                }
                case STORE_FLAG: {
                    return new FlagsCollectObject(jsonObject, mailServlet);
                }
                case COLOR_LABEL: {
                    return new ColorCollectObject(jsonObject, mailServlet);
                }
            }
            throw new InternalError("Unknown collectable operation: " + (Object)((Object)op));
        }

        protected CollectObject(Mail mailServlet) {
            this.mailServlet = mailServlet;
        }

        public abstract boolean collectable(JSONObject var1, CollectableOperation var2) throws OXException;

        public abstract void performOperations(ServerSession var1, OXJSONWriter var2, MailServletInterface var3) throws JSONException;

        public abstract CollectableOperation getOperation();

        public final void addCollectable(JSONObject jsonObject) throws OXException {
            this.mailIDs.add(JSONUtil.requireString(MailRequest.PARAMETER_ID, jsonObject));
        }

        protected final String[] getMailIDs() {
            return this.mailIDs.toArray(new String[this.mailIDs.size()]);
        }
    }

    private static interface Handler {
        public void requestPerformed(ServerSession var1, JSONWriter var2, JSONObject var3, MailServletInterface var4) throws OXException, JSONException;
    }

    private static enum CollectableOperation {
        MOVE,
        COPY,
        STORE_FLAG,
        COLOR_LABEL;

    }
}

