/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.request;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.CalendarObject;
import com.openexchange.groupware.container.Participant;
import com.openexchange.groupware.container.UserParticipant;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.User;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.tools.session.ServerSession;
import com.openexchange.user.UserService;
import java.util.Date;
import java.util.TimeZone;
import org.apache.commons.logging.Log;

public class CalendarRequest {
    protected ServerSession session;
    protected Date timestamp;
    protected TimeZone timeZone;

    protected void convertExternalToInternalUsersIfPossible(CalendarObject appointmentObj, Context ctx, Log log) {
        Participant[] participants = appointmentObj.getParticipants();
        if (participants == null) {
            return;
        }
        UserService us = ServerServiceRegistry.getInstance().getService(UserService.class);
        for (int pos = 0; pos < participants.length; ++pos) {
            Participant part = participants[pos];
            if (part.getType() != 5) continue;
            try {
                User foundUser = us.searchUser(part.getEmailAddress(), ctx);
                if (foundUser == null) continue;
                participants[pos] = new UserParticipant(foundUser.getId());
                continue;
            }
            catch (OXException e) {
                log.debug((Object)("Couldn't resolve external participant \"" + part.getEmailAddress() + "\" to an internal user"), (Throwable)e);
            }
        }
        appointmentObj.setParticipants(participants);
    }
}

