/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax;

import com.openexchange.ajax.AJAXServlet;
import com.openexchange.ajax.ConfigMenu;
import com.openexchange.ajax.Multiple;
import com.openexchange.ajax.SessionServlet;
import com.openexchange.ajax.container.Response;
import com.openexchange.ajax.helper.Send;
import com.openexchange.ajax.login.FormLogin;
import com.openexchange.ajax.login.HashCalculator;
import com.openexchange.ajax.login.LoginConfiguration;
import com.openexchange.ajax.login.LoginRequestHandler;
import com.openexchange.ajax.login.LoginRequestImpl;
import com.openexchange.ajax.login.LoginTools;
import com.openexchange.ajax.login.RedeemToken;
import com.openexchange.ajax.login.TokenLogin;
import com.openexchange.ajax.login.Tokens;
import com.openexchange.ajax.requesthandler.responseRenderers.APIResponseRenderer;
import com.openexchange.ajax.writer.LoginWriter;
import com.openexchange.ajax.writer.ResponseWriter;
import com.openexchange.authentication.Cookie;
import com.openexchange.authentication.Header;
import com.openexchange.authentication.LoginExceptionCodes;
import com.openexchange.authentication.ResultCode;
import com.openexchange.config.ConfigTools;
import com.openexchange.configuration.ClientWhitelist;
import com.openexchange.configuration.CookieHashSource;
import com.openexchange.configuration.ServerConfig;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.contexts.impl.ContextStorage;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.groupware.settings.Setting;
import com.openexchange.groupware.settings.impl.ConfigTree;
import com.openexchange.groupware.settings.impl.SettingStorage;
import com.openexchange.i18n.LocaleTools;
import com.openexchange.java.StringAllocator;
import com.openexchange.java.Strings;
import com.openexchange.java.util.UUIDs;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import com.openexchange.log.LogProperties;
import com.openexchange.login.ConfigurationProperty;
import com.openexchange.login.Interface;
import com.openexchange.login.LoginRequest;
import com.openexchange.login.LoginResult;
import com.openexchange.login.internal.LoginPerformer;
import com.openexchange.oauth.provider.OAuthProviderService;
import com.openexchange.server.ServiceExceptionCode;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.sessiond.SessionExceptionCodes;
import com.openexchange.sessiond.SessiondService;
import com.openexchange.sessiond.impl.IPRange;
import com.openexchange.threadpool.AbstractTask;
import com.openexchange.threadpool.Task;
import com.openexchange.threadpool.ThreadPools;
import com.openexchange.tools.io.IOTools;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import com.openexchange.tools.servlet.OXJSONExceptionCodes;
import com.openexchange.tools.servlet.http.Authorization;
import com.openexchange.tools.servlet.http.Cookies;
import com.openexchange.tools.servlet.http.Tools;
import com.openexchange.tools.session.ServerSession;
import com.openexchange.tools.session.ServerSessionAdapter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.oauth.OAuthAccessor;
import net.oauth.OAuthException;
import net.oauth.OAuthMessage;
import net.oauth.OAuthProblemException;
import net.oauth.server.OAuthServlet;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Login
extends AJAXServlet {
    private static final long serialVersionUID = 7680745138705836499L;
    protected static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(Login.class));
    protected static final Set<LogProperties.Name> LOG_PROPERTIES;
    public static final String SESSION_PREFIX;
    public static final String SECRET_PREFIX;
    public static final String PUBLIC_SESSION_NAME;
    public static final String ACTION_FORMLOGIN = "formlogin";
    public static final String ACTION_TOKENLOGIN = "tokenLogin";
    public static final String ACTION_TOKENS = "tokens";
    public static final String ACTION_REDEEM_TOKEN = "redeemToken";
    public static final String ACTION_CHANGEIP;
    final AtomicReference<LoginConfiguration> confReference = new AtomicReference();
    private final Map<String, LoginRequestHandler> handlerMap = new ConcurrentHashMap<String, LoginRequestHandler>(16);
    private static final String ERROR_PAGE_TEMPLATE = "<html>\n<script type=\"text/javascript\">\n// Display normal HTML for 5 seconds, then redirect via referrer.\nsetTimeout(redirect,5000);\nfunction redirect(){\n var referrer=document.referrer;\n var redirect_url;\n // If referrer already contains failed parameter, we don't add a 2nd one.\n if(referrer.indexOf(\"login=failed\")>=0){\n  redirect_url=referrer;\n }else{\n  // Check if referrer contains multiple parameter\n  if(referrer.indexOf(\"?\")<0){\n   redirect_url=referrer+\"?login=failed\";\n  }else{\n   redirect_url=referrer+\"&login=failed\";\n  }\n }\n // Redirect to referrer\n window.location.href=redirect_url;\n}\n</script>\n<body>\n<h1>ERROR_MESSAGE</h1>\n</body>\n</html>\n";

    public Login() {
        this.handlerMap.put("login", new LoginRequestHandler(){

            @Override
            public void handleRequest(HttpServletRequest req, HttpServletResponse resp) throws IOException {
                try {
                    Login.this.doLogin(req, resp);
                }
                catch (OXException e) {
                    Login.logAndSendException(resp, e);
                }
            }
        });
        this.handlerMap.put("oauth", new LoginRequestHandler(){

            @Override
            public void handleRequest(HttpServletRequest req, HttpServletResponse resp) throws IOException {
                try {
                    Login.this.doOAuthLogin(req, resp);
                }
                catch (OXException e) {
                    Login.logAndSendException(resp, e);
                }
            }
        });
        this.handlerMap.put("store", new LoginRequestHandler(){

            @Override
            public void handleRequest(HttpServletRequest req, HttpServletResponse resp) throws IOException {
                try {
                    Login.this.doStore(req, resp);
                }
                catch (OXException e) {
                    Login.logAndSendException(resp, e);
                }
                catch (JSONException e) {
                    Login.this.log("Error while writing response object.", e);
                    AJAXServlet.sendError(resp);
                }
            }
        });
        this.handlerMap.put("refreshSecret", new LoginRequestHandler(){

            @Override
            public void handleRequest(HttpServletRequest req, HttpServletResponse resp) throws IOException {
                try {
                    Login.this.doRefreshSecret(req, resp);
                }
                catch (OXException e) {
                    Login.logAndSendException(resp, e);
                }
                catch (JSONException e) {
                    Login.this.log("Error while writing response object.", e);
                    AJAXServlet.sendError(resp);
                }
            }
        });
        this.handlerMap.put("logout", new LoginRequestHandler(){

            @Override
            public void handleRequest(HttpServletRequest req, HttpServletResponse resp) throws IOException {
                Tools.disableCaching(resp);
                resp.setContentType("text/javascript; charset=UTF-8");
                String sessionId = req.getParameter("session");
                if (sessionId == null) {
                    resp.sendError(400);
                    return;
                }
                try {
                    Session session = LoginPerformer.getInstance().lookupSession(sessionId);
                    if (session != null) {
                        LoginConfiguration conf = Login.this.confReference.get();
                        SessionServlet.checkIP(conf.isIpCheck(), conf.getRanges(), session, req.getRemoteAddr(), conf.getIpCheckWhitelist());
                        String secret = SessionServlet.extractSecret(conf.getHashSource(), req, session.getHash(), session.getClient());
                        if (secret == null || !session.getSecret().equals(secret)) {
                            LOG.info((Object)"Status code 403 (FORBIDDEN): Missing or non-matching secret.");
                            resp.sendError(403);
                            return;
                        }
                        LoginPerformer.getInstance().doLogout(sessionId);
                        SessionServlet.removeOXCookies(session.getHash(), req, resp);
                        SessionServlet.removeJSESSIONID(req, resp);
                    }
                }
                catch (OXException e) {
                    LOG.error((Object)"Logout failed", (Throwable)e);
                }
            }
        });
        this.handlerMap.put("redirect", new LoginRequestHandler(){

            @Override
            public void handleRequest(HttpServletRequest req, HttpServletResponse resp) throws IOException {
                String hash;
                Session session;
                Tools.disableCaching(resp);
                resp.setContentType("text/javascript; charset=UTF-8");
                String randomToken = req.getParameter("random");
                if (randomToken == null) {
                    resp.sendError(400);
                    return;
                }
                SessiondService sessiondService = ServerServiceRegistry.getInstance().getService(SessiondService.class);
                if (sessiondService == null) {
                    OXException se = ServiceExceptionCode.SERVICE_UNAVAILABLE.create(new Object[]{SessiondService.class.getName()});
                    LOG.error((Object)se.getMessage(), (Throwable)se);
                    resp.sendError(403);
                    return;
                }
                LoginConfiguration conf = Login.this.confReference.get();
                if (conf.isInsecure()) {
                    if (conf.isRedirectIPChangeAllowed()) {
                        session = sessiondService.getSessionByRandomToken(randomToken, req.getRemoteAddr());
                    } else {
                        String newIP;
                        String oldIP;
                        session = sessiondService.getSessionByRandomToken(randomToken);
                        if (null != session && (null == (oldIP = session.getLocalIp()) || SessionServlet.isWhitelistedFromIPCheck(oldIP, conf.getRanges())) && !(newIP = req.getRemoteAddr()).equals(oldIP)) {
                            LOG.info((Object)("Changing IP of session " + session.getSessionID() + " with authID: " + session.getAuthId() + " from " + oldIP + " to " + newIP + '.'));
                            session.setLocalIp(newIP);
                        }
                    }
                } else {
                    session = sessiondService.getSessionByRandomToken(randomToken);
                }
                if (session == null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("No session could be found for random token: " + randomToken), new Throwable());
                    } else if (LOG.isInfoEnabled()) {
                        LOG.info((Object)("No session could be found for random token: " + randomToken));
                    }
                    resp.sendError(403);
                    return;
                }
                if (conf.isInsecure()) {
                    SessionServlet.removeOXCookies(session.getHash(), req, resp);
                }
                try {
                    Context context = ContextStorage.getInstance().getContext(session.getContextId());
                    User user = UserStorage.getInstance().getUser(session.getUserId(), context);
                    if (!context.isEnabled() || !user.isMailEnabled()) {
                        LOG.info((Object)("Status code 403 (FORBIDDEN): Either context " + context.getContextId() + " or user " + user.getId() + " not enabled"));
                        resp.sendError(403);
                        return;
                    }
                }
                catch (UndeclaredThrowableException e) {
                    LOG.info((Object)("Status code 403 (FORBIDDEN): Unexpected error occurred during login: " + e.getMessage()));
                    resp.sendError(403);
                    return;
                }
                catch (OXException e) {
                    LOG.info((Object)("Status code 403 (FORBIDDEN): Couldn't resolve context/user by identifier: " + session.getContextId() + '/' + session.getUserId()));
                    resp.sendError(403);
                    return;
                }
                String client = req.getParameter("client");
                if (!conf.isInsecure()) {
                    hash = session.getHash();
                } else {
                    if (null == client) {
                        client = session.getClient();
                    } else {
                        session.setClient(client);
                    }
                    hash = HashCalculator.getInstance().getHash(req, client);
                    session.setHash(hash);
                }
                Login.writeSecretCookie(resp, session, hash, req.isSecure(), req.getServerName(), conf);
                resp.sendRedirect(LoginTools.generateRedirectURL(req.getParameter("uiWebPath"), req.getParameter("store"), session.getSessionID(), conf.getUiWebPath()));
            }
        });
        this.handlerMap.put(ACTION_CHANGEIP, new LoginRequestHandler(){

            @Override
            public void handleRequest(HttpServletRequest req, HttpServletResponse resp) throws IOException {
                Response response = new Response();
                Session session = null;
                try {
                    String sessionId = req.getParameter("session");
                    if (null == sessionId) {
                        if (LOG.isInfoEnabled()) {
                            StringBuilder sb = new StringBuilder(32);
                            sb.append("Parameter \"").append("session").append("\" not found for action ").append(ACTION_CHANGEIP);
                            LOG.info((Object)sb.toString());
                        }
                        throw AjaxExceptionCodes.MISSING_PARAMETER.create("session");
                    }
                    String newIP = req.getParameter("clientIP");
                    if (null == newIP) {
                        if (LOG.isInfoEnabled()) {
                            StringBuilder sb = new StringBuilder(32);
                            sb.append("Parameter \"").append("clientIP").append("\" not found for action ").append(ACTION_CHANGEIP);
                            LOG.info((Object)sb.toString());
                        }
                        throw AjaxExceptionCodes.MISSING_PARAMETER.create("clientIP");
                    }
                    SessiondService sessiondService = ServerServiceRegistry.getInstance().getService(SessiondService.class, true);
                    session = sessiondService.getSession(sessionId);
                    LoginConfiguration conf = Login.this.confReference.get();
                    if (session != null) {
                        SessionServlet.checkIP(conf.isIpCheck(), conf.getRanges(), session, req.getRemoteAddr(), conf.getIpCheckWhitelist());
                        String secret = SessionServlet.extractSecret(conf.getHashSource(), req, session.getHash(), session.getClient());
                        if (secret == null || !session.getSecret().equals(secret)) {
                            if (LOG.isInfoEnabled() && null != secret) {
                                LOG.info((Object)("Session secret is different. Given secret \"" + secret + "\" differs from secret in session \"" + session.getSecret() + "\"."));
                            }
                            throw SessionExceptionCodes.WRONG_SESSION_SECRET.create();
                        }
                        String oldIP = session.getLocalIp();
                        if (!newIP.equals(oldIP)) {
                            if (LOG.isDebugEnabled()) {
                                LOG.info((Object)("Changing IP of session " + session.getSessionID() + " with authID: " + session.getAuthId() + " from " + oldIP + " to " + newIP + '.'));
                            }
                            session.setLocalIp(newIP);
                        }
                    } else {
                        if (LOG.isInfoEnabled()) {
                            LOG.info((Object)("There is no session associated with session identifier: " + sessionId));
                        }
                        throw SessionExceptionCodes.SESSION_EXPIRED.create(new Object[]{sessionId});
                    }
                    response.setData("1");
                }
                catch (OXException e) {
                    LOG.debug((Object)e.getMessage(), (Throwable)e);
                    response.setException(e);
                }
                Tools.disableCaching(resp);
                resp.setContentType("text/javascript; charset=UTF-8");
                resp.setStatus(200);
                try {
                    ResponseWriter.write(response, resp.getWriter(), AJAXServlet.localeFrom(session));
                }
                catch (JSONException e) {
                    Login.this.log("Error while writing response object.", e);
                    AJAXServlet.sendError(resp);
                }
            }
        });
        this.handlerMap.put("redeem", new LoginRequestHandler(){

            @Override
            public void handleRequest(HttpServletRequest req, HttpServletResponse resp) throws IOException {
                String hash;
                Session session;
                Tools.disableCaching(resp);
                resp.setContentType("text/javascript; charset=UTF-8");
                String randomToken = req.getParameter("random");
                if (randomToken == null) {
                    resp.sendError(400);
                    return;
                }
                SessiondService sessiondService = ServerServiceRegistry.getInstance().getService(SessiondService.class);
                if (sessiondService == null) {
                    OXException se = ServiceExceptionCode.SERVICE_UNAVAILABLE.create(new Object[]{SessiondService.class.getName()});
                    LOG.error((Object)se.getMessage(), (Throwable)se);
                    resp.sendError(403);
                    return;
                }
                LoginConfiguration conf = Login.this.confReference.get();
                if (conf.isInsecure()) {
                    if (conf.isRedirectIPChangeAllowed()) {
                        session = sessiondService.getSessionByRandomToken(randomToken, req.getRemoteAddr());
                    } else {
                        String newIP;
                        String oldIP;
                        session = sessiondService.getSessionByRandomToken(randomToken);
                        if (null != session && (null == (oldIP = session.getLocalIp()) || SessionServlet.isWhitelistedFromIPCheck(oldIP, conf.getRanges())) && !(newIP = req.getRemoteAddr()).equals(oldIP)) {
                            LOG.info((Object)("Changing IP of session " + session.getSessionID() + " with authID: " + session.getAuthId() + " from " + oldIP + " to " + newIP + '.'));
                            session.setLocalIp(newIP);
                        }
                    }
                } else {
                    session = sessiondService.getSessionByRandomToken(randomToken);
                }
                if (session == null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("No session could be found for random token: " + randomToken), new Throwable());
                    } else if (LOG.isInfoEnabled()) {
                        LOG.info((Object)("No session could be found for random token: " + randomToken));
                    }
                    resp.sendError(403);
                    return;
                }
                if (conf.isInsecure()) {
                    SessionServlet.removeOXCookies(session.getHash(), req, resp);
                }
                try {
                    Context context = ContextStorage.getInstance().getContext(session.getContextId());
                    User user = UserStorage.getInstance().getUser(session.getUserId(), context);
                    if (!context.isEnabled() || !user.isMailEnabled()) {
                        LOG.info((Object)("Status code 403 (FORBIDDEN): Either context " + context.getContextId() + " or user " + user.getId() + " not enabled"));
                        resp.sendError(403);
                        return;
                    }
                }
                catch (UndeclaredThrowableException e) {
                    LOG.info((Object)("Status code 403 (FORBIDDEN): Unexpected error occurred during login: " + e.getMessage()));
                    resp.sendError(403);
                    return;
                }
                catch (OXException e) {
                    LOG.info((Object)("Status code 403 (FORBIDDEN): Couldn't resolve context/user by identifier: " + session.getContextId() + '/' + session.getUserId()));
                    resp.sendError(403);
                    return;
                }
                String client = req.getParameter("client");
                if (!conf.isInsecure()) {
                    hash = session.getHash();
                } else {
                    if (null == client) {
                        client = session.getClient();
                    } else {
                        session.setClient(client);
                    }
                    hash = HashCalculator.getInstance().getHash(req, client);
                    session.setHash(hash);
                }
                Login.writeSecretCookie(resp, session, hash, req.isSecure(), req.getServerName(), conf);
                try {
                    JSONObject json = new JSONObject();
                    LoginWriter.write(session, json);
                    Login.appendModules(session, json, req);
                    json.write((Writer)resp.getWriter());
                }
                catch (JSONException e) {
                    Login.this.log("Error while writing response object.", e);
                    AJAXServlet.sendError(resp);
                }
            }
        });
        this.handlerMap.put("autologin", new LoginRequestHandler(){

            @Override
            public void handleRequest(HttpServletRequest req, HttpServletResponse resp) throws IOException {
                Tools.disableCaching(resp);
                resp.setContentType("text/javascript; charset=UTF-8");
                Response response = new Response();
                Session session = null;
                try {
                    SessiondService sessiondService;
                    LoginConfiguration conf = Login.this.confReference.get();
                    if (!conf.isSessiondAutoLogin()) {
                        if (Login.this.doAutoLogin(req, resp)) {
                            throw AjaxExceptionCodes.DISABLED_ACTION.create("autologin");
                        }
                        return;
                    }
                    javax.servlet.http.Cookie[] cookies = req.getCookies();
                    if (cookies == null) {
                        cookies = new javax.servlet.http.Cookie[]{};
                    }
                    if (null == (sessiondService = ServerServiceRegistry.getInstance().getService(SessiondService.class))) {
                        OXException se = ServiceExceptionCode.SERVICE_UNAVAILABLE.create(new Object[]{SessiondService.class.getName()});
                        LOG.error((Object)se.getMessage(), (Throwable)se);
                        resp.sendError(403);
                        return;
                    }
                    String secret = null;
                    String hash = HashCalculator.getInstance().getHash(req);
                    String sessionCookieName = SESSION_PREFIX + hash;
                    String secretCookieName = SECRET_PREFIX + hash;
                    for (javax.servlet.http.Cookie cookie : cookies) {
                        String cookieName = cookie.getName();
                        if (cookieName.startsWith(sessionCookieName)) {
                            String sessionId = cookie.getValue();
                            session = sessiondService.getSession(sessionId);
                            if (null == session) continue;
                            if (!conf.isIpCheck()) {
                                LoginTools.updateIPAddress(conf, req.getRemoteAddr(), session);
                            } else {
                                String newIP = req.getRemoteAddr();
                                SessionServlet.checkIP(true, conf.getRanges(), session, newIP, conf.getIpCheckWhitelist());
                                LoginTools.updateIPAddress(conf, newIP, session);
                            }
                            try {
                                Context ctx = ContextStorage.getInstance().getContext(session.getContextId());
                                if (!ctx.isEnabled()) {
                                    throw LoginExceptionCodes.INVALID_CREDENTIALS.create();
                                }
                                User user = UserStorage.getInstance().getUser(session.getUserId(), ctx);
                                if (!user.isMailEnabled()) {
                                    throw LoginExceptionCodes.INVALID_CREDENTIALS.create();
                                }
                            }
                            catch (UndeclaredThrowableException e) {
                                throw LoginExceptionCodes.UNKNOWN.create((Throwable)e, new Object[]{e.getMessage()});
                            }
                            Future<Object> optModules = Login.getModulesAsync(session, req);
                            JSONObject json = new JSONObject(8);
                            LoginWriter.write(session, json);
                            if (null != optModules) {
                                try {
                                    Object oModules = optModules.get();
                                    if (null != oModules) {
                                        json.put("modules", oModules);
                                    }
                                }
                                catch (InterruptedException e) {
                                    Thread.currentThread().interrupt();
                                    throw LoginExceptionCodes.UNKNOWN.create((Throwable)e, new Object[]{"Thread interrupted."});
                                }
                                catch (ExecutionException e) {
                                    Throwable cause = e.getCause();
                                    LOG.warn((Object)("Modules could not be added to login JSON response: " + cause.getMessage()), cause);
                                }
                            }
                            response.setData(json);
                            if (null == secret) continue;
                            break;
                        }
                        if (!cookieName.startsWith(secretCookieName)) continue;
                        secret = cookie.getValue();
                        if (null != session) break;
                    }
                    if (null == response.getData() || session == null || secret == null || !session.getSecret().equals(secret)) {
                        SessionServlet.removeOXCookies(hash, req, resp);
                        SessionServlet.removeJSESSIONID(req, resp);
                        if (Login.this.doAutoLogin(req, resp)) {
                            throw OXJSONExceptionCodes.INVALID_COOKIE.create();
                        }
                        return;
                    }
                    Login.writePublicSessionCookie(resp, session, req.isSecure(), req.getServerName(), conf);
                }
                catch (OXException e) {
                    if (AjaxExceptionCodes.DISABLED_ACTION.equals(e)) {
                        LOG.debug((Object)e.getMessage(), (Throwable)e);
                    } else {
                        e.log(LOG);
                    }
                    if (SessionServlet.isIpCheckError(e) && null != session) {
                        try {
                            SessiondService sessiondService = ServerServiceRegistry.getInstance().getService(SessiondService.class);
                            SessionServlet.removeOXCookies(session.getHash(), req, resp);
                            SessionServlet.removeJSESSIONID(req, resp);
                            sessiondService.removeSession(session.getSessionID());
                        }
                        catch (Exception e2) {
                            LOG.error((Object)"Cookies could not be removed.", (Throwable)e2);
                        }
                    }
                    response.setException(e);
                }
                catch (JSONException e) {
                    OXException oje = OXJSONExceptionCodes.JSON_WRITE_ERROR.create(e, new Object[0]);
                    LOG.error((Object)oje.getMessage(), (Throwable)oje);
                    response.setException(oje);
                }
                Tools.disableCaching(resp);
                resp.setStatus(200);
                resp.setContentType("text/javascript; charset=UTF-8");
                try {
                    if (response.hasError()) {
                        ResponseWriter.write(response, resp.getWriter(), AJAXServlet.localeFrom(session));
                    } else {
                        ((JSONObject)response.getData()).write((Writer)resp.getWriter());
                    }
                }
                catch (JSONException e) {
                    Login.this.log("Error while writing response object.", e);
                    AJAXServlet.sendError(resp);
                }
            }
        });
    }

    public void init(ServletConfig config) throws ServletException {
        String errorPageTemplate;
        super.init(config);
        String uiWebPath = config.getInitParameter(ServerConfig.Property.UI_WEB_PATH.getPropertyName());
        boolean sessiondAutoLogin = Boolean.parseBoolean(config.getInitParameter(ConfigurationProperty.SESSIOND_AUTOLOGIN.getPropertyName()));
        CookieHashSource hashSource = CookieHashSource.parse(config.getInitParameter(ServerConfig.Property.COOKIE_HASH.getPropertyName()));
        String httpAuthAutoLogin = config.getInitParameter(ConfigurationProperty.HTTP_AUTH_AUTOLOGIN.getPropertyName());
        String defaultClient = config.getInitParameter(ConfigurationProperty.HTTP_AUTH_CLIENT.getPropertyName());
        String clientVersion = config.getInitParameter(ConfigurationProperty.HTTP_AUTH_VERSION.getPropertyName());
        String templateFileLocation = config.getInitParameter(ConfigurationProperty.ERROR_PAGE_TEMPLATE.getPropertyName());
        if (null == templateFileLocation) {
            errorPageTemplate = ERROR_PAGE_TEMPLATE;
        } else {
            File templateFile = new File(templateFileLocation);
            try {
                errorPageTemplate = IOTools.getFileContents(templateFile);
                LOG.info((Object)("Found an error page template at " + templateFileLocation));
            }
            catch (FileNotFoundException e) {
                LOG.error((Object)("Could not find an error page template at " + templateFileLocation + ", using default."));
                errorPageTemplate = ERROR_PAGE_TEMPLATE;
            }
        }
        int cookieExpiry = ConfigTools.parseTimespanSecs((String)config.getInitParameter(ServerConfig.Property.COOKIE_TTL.getPropertyName()));
        boolean cookieForceHTTPS = Boolean.parseBoolean(config.getInitParameter(ServerConfig.Property.COOKIE_FORCE_HTTPS.getPropertyName())) || Boolean.parseBoolean(config.getInitParameter(ServerConfig.Property.FORCE_HTTPS.getPropertyName()));
        boolean insecure = Boolean.parseBoolean(config.getInitParameter(ConfigurationProperty.INSECURE.getPropertyName()));
        boolean ipCheck = Boolean.parseBoolean(config.getInitParameter(ServerConfig.Property.IP_CHECK.getPropertyName()));
        ClientWhitelist ipCheckWhitelist = new ClientWhitelist().add(config.getInitParameter(ServerConfig.Property.IP_CHECK_WHITELIST.getPropertyName()));
        boolean redirectIPChangeAllowed = Boolean.parseBoolean(config.getInitParameter(ConfigurationProperty.REDIRECT_IP_CHANGE_ALLOWED.getPropertyName()));
        LinkedList<IPRange> ranges = new LinkedList<IPRange>();
        String tmp = config.getInitParameter(ConfigurationProperty.NO_IP_CHECK_RANGE.getPropertyName());
        if (tmp != null) {
            String[] lines;
            for (String line : lines = Strings.splitByCRLF((String)tmp)) {
                if ((line = line.replaceAll("\\s", "")).equals("") || line.length() != 0 && line.charAt(0) == '#') continue;
                ranges.add(IPRange.parseRange(line));
            }
        }
        boolean disableTrimLogin = Boolean.parseBoolean(config.getInitParameter(ConfigurationProperty.DISABLE_TRIM_LOGIN.getPropertyName()));
        boolean formLoginWithoutAuthId = Boolean.parseBoolean(config.getInitParameter(ConfigurationProperty.FORM_LOGIN_WITHOUT_AUTHID.getPropertyName()));
        LoginConfiguration conf = new LoginConfiguration(uiWebPath, sessiondAutoLogin, hashSource, httpAuthAutoLogin, defaultClient, clientVersion, errorPageTemplate, cookieExpiry, cookieForceHTTPS, insecure, ipCheck, ipCheckWhitelist, redirectIPChangeAllowed, ranges, disableTrimLogin, formLoginWithoutAuthId);
        this.confReference.set(conf);
        this.handlerMap.put(ACTION_FORMLOGIN, new FormLogin(conf));
        this.handlerMap.put(ACTION_TOKENLOGIN, new TokenLogin(conf));
        this.handlerMap.put(ACTION_TOKENS, new Tokens(conf));
        this.handlerMap.put(ACTION_REDEEM_TOKEN, new RedeemToken(conf));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        block5: {
            try {
                String action = req.getParameter("action");
                String subPath = Login.getServletSpecificURI(req);
                if (null != subPath && subPath.startsWith("/httpAuth")) {
                    this.doHttpAuth(req, resp);
                    break block5;
                }
                if (null != action) {
                    this.doJSONAuth(req, resp, action);
                    break block5;
                }
                Login.logAndSendException(resp, AjaxExceptionCodes.MISSING_PARAMETER.create("action"));
                return;
            }
            finally {
                LogProperties.removeLogProperties(LOG_PROPERTIES);
            }
        }
    }

    private void doJSONAuth(HttpServletRequest req, HttpServletResponse resp, String action) throws IOException {
        LoginRequestHandler handler = this.handlerMap.get(action);
        if (null == handler) {
            Login.logAndSendException(resp, AjaxExceptionCodes.UNKNOWN_ACTION.create(action));
            return;
        }
        handler.handleRequest(req, resp);
    }

    private void doHttpAuth(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        if (req.getHeader("authorization") != null) {
            try {
                this.doAuthHeaderLogin(req, resp);
            }
            catch (OXException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
                resp.addHeader("WWW-Authenticate", "NEGOTIATE");
                resp.addHeader("WWW-Authenticate", "Basic realm=\"Open-Xchange\"");
                resp.sendError(401, e.getMessage());
            }
        } else {
            resp.addHeader("WWW-Authenticate", "NEGOTIATE");
            resp.addHeader("WWW-Authenticate", "Basic realm=\"Open-Xchange\"");
            resp.sendError(401, "Authorization Required!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCookieReWrite(HttpServletRequest req, HttpServletResponse resp, CookieType type) throws OXException, JSONException, IOException {
        LoginConfiguration conf = this.confReference.get();
        if (!conf.isSessiondAutoLogin() && CookieType.SESSION == type) {
            throw AjaxExceptionCodes.DISABLED_ACTION.create("store");
        }
        SessiondService sessiond = ServerServiceRegistry.getInstance().getService(SessiondService.class);
        if (null == sessiond) {
            throw ServiceExceptionCode.SERVICE_UNAVAILABLE.create(new Object[]{SessiondService.class.getName()});
        }
        String sessionId = req.getParameter("session");
        if (null == sessionId) {
            throw AjaxExceptionCodes.MISSING_PARAMETER.create("session");
        }
        ServerSession session = SessionServlet.getSession(conf.getHashSource(), req, sessionId, sessiond);
        try {
            SessionServlet.checkIP(conf.isIpCheck(), conf.getRanges(), session, req.getRemoteAddr(), conf.getIpCheckWhitelist());
            if (type == CookieType.SESSION) {
                this.writeSessionCookie(resp, session, session.getHash(), req.isSecure(), req.getServerName());
            } else {
                Login.writeSecretCookie(resp, session, session.getHash(), req.isSecure(), req.getServerName(), conf);
            }
            req.getSession();
            Response response = new Response();
            response.setData("1");
            ResponseWriter.write(response, resp.getWriter(), Login.localeFrom((Session)session));
        }
        finally {
            LogProperties.removeSessionProperties();
        }
    }

    protected void doStore(HttpServletRequest req, HttpServletResponse resp) throws OXException, JSONException, IOException {
        Tools.disableCaching(resp);
        resp.setContentType("text/javascript; charset=UTF-8");
        this.doCookieReWrite(req, resp, CookieType.SESSION);
    }

    protected void doRefreshSecret(HttpServletRequest req, HttpServletResponse resp) throws OXException, JSONException, IOException {
        Tools.disableCaching(resp);
        resp.setContentType("text/javascript; charset=UTF-8");
        this.doCookieReWrite(req, resp, CookieType.SECRET);
    }

    public static void logAndSendException(HttpServletResponse resp, OXException e) throws IOException {
        LOG.debug((Object)e.getMessage(), (Throwable)e);
        Tools.disableCaching(resp);
        resp.setContentType("text/javascript; charset=UTF-8");
        Response response = new Response();
        response.setException(e);
        Send.sendResponse(response, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        this.doGet(req, resp);
    }

    @Deprecated
    protected void writeSecretCookie(HttpServletResponse resp, Session session, String hash, boolean secure) {
        Login.writeSecretCookie(resp, session, hash, secure, null, this.confReference.get());
    }

    public static void writeSecretCookie(HttpServletResponse resp, Session session, String hash, boolean secure, String serverName, LoginConfiguration conf) {
        javax.servlet.http.Cookie cookie = new javax.servlet.http.Cookie(SECRET_PREFIX + hash, session.getSecret());
        Login.configureCookie(cookie, secure, serverName, conf);
        resp.addCookie(cookie);
        String altId = (String)session.getParameter(Session.PARAM_ALTERNATIVE_ID);
        if (null != altId) {
            cookie = new javax.servlet.http.Cookie(PUBLIC_SESSION_NAME, altId);
            Login.configureCookie(cookie, secure, serverName, conf);
            resp.addCookie(cookie);
        }
    }

    public static void writePublicSessionCookie(HttpServletResponse resp, Session session, boolean secure, String serverName, LoginConfiguration conf) {
        String altId = (String)session.getParameter(Session.PARAM_ALTERNATIVE_ID);
        if (null != altId) {
            javax.servlet.http.Cookie cookie = new javax.servlet.http.Cookie(PUBLIC_SESSION_NAME, altId);
            Login.configureCookie(cookie, secure, serverName, conf);
            resp.addCookie(cookie);
        }
    }

    @Deprecated
    protected void writeSessionCookie(HttpServletResponse resp, Session session, String hash, boolean secure) {
        this.writeSessionCookie(resp, session, hash, secure, null);
    }

    protected void writeSessionCookie(HttpServletResponse resp, Session session, String hash, boolean secure, String serverName) {
        javax.servlet.http.Cookie cookie = new javax.servlet.http.Cookie(SESSION_PREFIX + hash, session.getSessionID());
        Login.configureCookie(cookie, secure, serverName, this.confReference.get());
        resp.addCookie(cookie);
    }

    private static void configureCookie(javax.servlet.http.Cookie cookie, boolean secure, String serverName, LoginConfiguration conf) {
        String domain;
        cookie.setPath("/");
        if (secure || conf.isCookieForceHTTPS() && !Cookies.isLocalLan(serverName)) {
            cookie.setSecure(true);
        }
        if (conf.isSessiondAutoLogin() || conf.getCookieExpiry() < 0) {
            cookie.setMaxAge(conf.getCookieExpiry());
        }
        if (null != (domain = Cookies.getDomainValue(null == serverName ? (String)LogProperties.getLogProperty((LogProperties.Name)LogProperties.Name.AJP_SERVER_NAME) : serverName))) {
            cookie.setDomain(domain);
        }
    }

    protected boolean doAutoLogin(HttpServletRequest req, HttpServletResponse resp) throws IOException, OXException {
        return this.loginOperation(req, resp, new LoginClosure(){

            @Override
            public LoginResult doLogin(HttpServletRequest req2) throws OXException {
                LoginRequest request = Login.this.parseAutoLoginRequest(req2);
                return LoginPerformer.getInstance().doAutoLogin(request);
            }
        });
    }

    protected void doLogin(HttpServletRequest req, HttpServletResponse resp) throws IOException, OXException {
        this.loginOperation(req, resp, new LoginClosure(){

            @Override
            public LoginResult doLogin(HttpServletRequest req2) throws OXException {
                LoginConfiguration conf = Login.this.confReference.get();
                LoginRequestImpl request = LoginTools.parseLogin(req2, "name", false, conf.getDefaultClient(), conf.isCookieForceHTTPS(), conf.isDisableTrimLogin(), false);
                return LoginPerformer.getInstance().doLogin(request);
            }
        });
    }

    protected void doOAuthLogin(HttpServletRequest req, final HttpServletResponse resp) throws IOException, OXException {
        this.loginOperation(req, resp, new LoginClosure(){

            @Override
            public LoginResult doLogin(HttpServletRequest req2) throws OXException {
                try {
                    OAuthProviderService providerService = ServerServiceRegistry.getInstance().getService(OAuthProviderService.class);
                    OAuthMessage requestMessage = OAuthServlet.getMessage((HttpServletRequest)req2, null);
                    OAuthAccessor accessor = providerService.getAccessor(requestMessage);
                    providerService.getValidator().validateMessage(requestMessage, accessor);
                    String login = (String)accessor.getProperty("login");
                    String password = (String)accessor.getProperty("password");
                    LoginConfiguration conf = Login.this.confReference.get();
                    LoginRequestImpl request = LoginTools.parseLogin(req2, login, password, false, conf.getDefaultClient(), conf.isCookieForceHTTPS(), false);
                    return LoginPerformer.getInstance().doLogin(request);
                }
                catch (OAuthProblemException e) {
                    try {
                        this.handleException((Exception)((Object)e), req2, resp, false);
                        return null;
                    }
                    catch (IOException ioe) {
                        throw LoginExceptionCodes.UNKNOWN.create((Throwable)ioe, new Object[]{ioe.getMessage()});
                    }
                    catch (ServletException se) {
                        throw LoginExceptionCodes.UNKNOWN.create((Throwable)se, new Object[]{se.getMessage()});
                    }
                }
                catch (IOException e) {
                    throw LoginExceptionCodes.UNKNOWN.create((Throwable)e, new Object[]{e.getMessage()});
                }
                catch (OAuthException e) {
                    throw LoginExceptionCodes.UNKNOWN.create((Throwable)e, new Object[]{e.getMessage()});
                }
                catch (URISyntaxException e) {
                    throw LoginExceptionCodes.UNKNOWN.create((Throwable)e, new Object[]{e.getMessage()});
                }
            }

            private void handleException(Exception e, HttpServletRequest request, HttpServletResponse response, boolean sendBody) throws IOException, ServletException {
                StringAllocator realm = new StringAllocator(32).append(request.isSecure() ? "https://" : "http://");
                realm.append(request.getLocalName());
                OAuthServlet.handleException((HttpServletResponse)response, (Exception)e, (String)realm.toString(), (boolean)sendBody);
            }
        });
    }

    private boolean loginOperation(HttpServletRequest req, HttpServletResponse resp, LoginClosure login) throws IOException, OXException {
        Session session;
        Tools.disableCaching(resp);
        resp.setContentType("text/javascript; charset=UTF-8");
        Response response = new Response();
        LoginResult result = null;
        try {
            result = login.doLogin(req);
            if (null == result) {
                return true;
            }
            session = result.getSession();
            LogProperties.putSessionProperties((Session)session);
            Future<Object> optModules = Login.getModulesAsync(session, req);
            Login.addHeadersAndCookies(result, resp);
            ResultCode code = result.getCode();
            if (null != code) {
                switch (code) {
                    case FAILED: {
                        return true;
                    }
                    case REDIRECT: {
                        throw LoginExceptionCodes.REDIRECT.create(new Object[]{result.getRedirect()});
                    }
                }
            }
            session.setParameter("user-agent", (Object)req.getHeader("user-agent"));
            JSONObject json = new JSONObject(8);
            LoginWriter.write(result, json);
            String multipleRequest = req.getParameter("multiple");
            if (multipleRequest != null) {
                JSONArray dataArray = new JSONArray(multipleRequest);
                if (dataArray.length() > 0) {
                    JSONArray responses = Multiple.perform(dataArray, req, ServerSessionAdapter.valueOf(session));
                    json.put("multiple", (Object)responses);
                } else {
                    json.put("multiple", (Object)new JSONArray(0));
                }
            }
            if (null != optModules) {
                try {
                    Object oModules = optModules.get();
                    if (null != oModules) {
                        json.put("modules", oModules);
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw LoginExceptionCodes.UNKNOWN.create((Throwable)e, new Object[]{"Thread interrupted."});
                }
                catch (ExecutionException e) {
                    Throwable cause = e.getCause();
                    LOG.warn((Object)("Modules could not be added to login JSON response: " + cause.getMessage()), cause);
                }
            }
            response.setData(json);
        }
        catch (OXException e) {
            if ("SVL".equals(e.getPrefix())) {
                throw e;
            }
            if (LoginExceptionCodes.NOT_SUPPORTED.equals(e)) {
                LOG.debug((Object)e.getMessage(), (Throwable)e);
                throw AjaxExceptionCodes.DISABLED_ACTION.create("autologin");
            }
            if (LoginExceptionCodes.REDIRECT.equals(e)) {
                LOG.debug((Object)e.getMessage(), (Throwable)e);
            } else {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
            response.setException(e);
        }
        catch (JSONException e) {
            OXException oje = OXJSONExceptionCodes.JSON_WRITE_ERROR.create(e, new Object[0]);
            LOG.error((Object)oje.getMessage(), (Throwable)oje);
            response.setException(oje);
        }
        try {
            if (response.hasError() || null == result) {
                Locale loc;
                String sLocale = req.getParameter("language");
                Locale locale = null == sLocale ? Login.bestGuessLocale(result, req) : (null == (loc = LocaleTools.getLocale((String)sLocale)) ? Login.bestGuessLocale(result, req) : loc);
                ResponseWriter.write(response, resp.getWriter(), locale);
                return false;
            }
            session = result.getSession();
            SessionServlet.rememberSession(req, new ServerSessionAdapter(session, result.getContext(), result.getUser()));
            Login.writeSecretCookie(resp, session, session.getHash(), req.isSecure(), req.getServerName(), this.confReference.get());
            if (req.getParameter("callback") != null && "login".equals(req.getParameter("action"))) {
                APIResponseRenderer.writeResponse(response, "login", req, resp);
            } else {
                ((JSONObject)response.getData()).write((Writer)resp.getWriter());
            }
        }
        catch (JSONException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            LOG.error((Object)"Error while writing response object.", (Throwable)e);
            Login.sendError(resp);
            return false;
        }
        return false;
    }

    private static Locale bestGuessLocale(LoginResult result, HttpServletRequest req) {
        User user;
        Locale locale = null == result ? Tools.getLocaleByAcceptLanguage(req, null) : (null == (user = result.getUser()) ? Tools.getLocaleByAcceptLanguage(req, null) : user.getLocale());
        return locale;
    }

    private static void addHeadersAndCookies(LoginResult result, HttpServletResponse resp) {
        Header[] headers;
        Cookie[] cookies = result.getCookies();
        if (null != cookies) {
            for (Cookie cookie : cookies) {
                resp.addCookie(Login.wrapCookie(cookie));
            }
        }
        if (null != (headers = result.getHeaders())) {
            for (Header header : headers) {
                resp.addHeader(header.getName(), header.getValue());
            }
        }
    }

    private static javax.servlet.http.Cookie wrapCookie(Cookie cookie) {
        return new javax.servlet.http.Cookie(cookie.getName(), cookie.getValue());
    }

    protected LoginRequest parseAutoLoginRequest(HttpServletRequest req) throws OXException {
        LoginConfiguration conf = this.confReference.get();
        String authId = LoginTools.parseAuthId(req, false);
        String client = LoginTools.parseClient(req, false, conf.getDefaultClient());
        String clientIP = LoginTools.parseClientIP(req);
        String userAgent = LoginTools.parseUserAgent(req);
        Map<String, List<String>> headers = Tools.copyHeaders(req);
        Cookie[] cookies = Tools.getCookieFromHeader(req);
        String httpSessionId = req.getSession(true).getId();
        return new LoginRequestImpl(null, null, clientIP, userAgent, authId, client, null, HashCalculator.getInstance().getHash(req, client), Interface.HTTP_JSON, headers, cookies, Tools.considerSecure(req, conf.isCookieForceHTTPS()), req.getServerName(), req.getServerPort(), httpSessionId);
    }

    private String parseClient(HttpServletRequest req) {
        try {
            return LoginTools.parseClient(req, false, this.confReference.get().getDefaultClient());
        }
        catch (OXException e) {
            return this.confReference.get().getDefaultClient();
        }
    }

    protected static void appendModules(Session session, JSONObject json, HttpServletRequest req) {
        String modules = "modules";
        if (Login.parseBoolean(req.getParameter("modules"))) {
            try {
                Setting setting = ConfigTree.getInstance().getSettingByPath("modules");
                SettingStorage.getInstance(session).readValues(setting);
                json.put("modules", ConfigMenu.convert2JS(setting));
            }
            catch (OXException e) {
                LOG.warn((Object)("Modules could not be added to login JSON response: " + e.getMessage()), (Throwable)e);
            }
            catch (JSONException e) {
                LOG.warn((Object)("Modules could not be added to login JSON response: " + e.getMessage()), (Throwable)e);
            }
            catch (Exception e) {
                LOG.warn((Object)("Modules could not be added to login JSON response: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    protected static Future<Object> getModulesAsync(final Session session, HttpServletRequest req) {
        String modules = "modules";
        if (!Login.parseBoolean(req.getParameter("modules"))) {
            return null;
        }
        return ThreadPools.getThreadPool().submit((Task)new AbstractTask<Object>(){

            public Object call() throws Exception {
                try {
                    Setting setting = ConfigTree.getInstance().getSettingByPath("modules");
                    SettingStorage.getInstance(session).readValues(setting);
                    return ConfigMenu.convert2JS(setting);
                }
                catch (OXException e) {
                    LOG.warn((Object)("Modules could not be added to login JSON response: " + e.getMessage()), (Throwable)e);
                }
                catch (JSONException e) {
                    LOG.warn((Object)("Modules could not be added to login JSON response: " + e.getMessage()), (Throwable)e);
                }
                catch (Exception e) {
                    LOG.warn((Object)("Modules could not be added to login JSON response: " + e.getMessage()), (Throwable)e);
                }
                return null;
            }
        });
    }

    private static boolean parseBoolean(String parameter) {
        return "true".equalsIgnoreCase(parameter) || "1".equals(parameter) || "yes".equalsIgnoreCase(parameter) || "y".equalsIgnoreCase(parameter) || "on".equalsIgnoreCase(parameter);
    }

    private void doAuthHeaderLogin(HttpServletRequest req, HttpServletResponse resp) throws OXException, IOException {
        String version2;
        Authorization.Credentials creds;
        String auth = req.getHeader("authorization");
        if (!Authorization.checkForAuthorizationHeader(auth)) {
            throw LoginExceptionCodes.UNKNOWN_HTTP_AUTHORIZATION.create();
        }
        LoginConfiguration conf = this.confReference.get();
        if (Authorization.checkForBasicAuthorization(auth)) {
            creds = Authorization.decode(auth);
            version2 = conf.getClientVersion();
        } else if (Authorization.checkForKerberosAuthorization(auth)) {
            creds = new Authorization.Credentials("kerberos", "");
            version2 = "Kerberos";
        } else {
            throw LoginExceptionCodes.UNKNOWN_HTTP_AUTHORIZATION.create(new Object[]{""});
        }
        String client = this.parseClient(req);
        String clientIP = LoginTools.parseClientIP(req);
        String userAgent = LoginTools.parseUserAgent(req);
        Map<String, List<String>> headers = Tools.copyHeaders(req);
        Cookie[] cookies = Tools.getCookieFromHeader(req);
        String httpSessionId = req.getSession(true).getId();
        LoginRequestImpl request = new LoginRequestImpl(creds.getLogin(), creds.getPassword(), clientIP, userAgent, UUIDs.getUnformattedString((UUID)UUID.randomUUID()), client, version2, HashCalculator.getInstance().getHash(req, userAgent, client), Interface.HTTP_JSON, headers, cookies, Tools.considerSecure(req, conf.isCookieForceHTTPS()), req.getServerName(), req.getServerPort(), httpSessionId);
        HashMap<String, Object> properties = new HashMap<String, Object>(1);
        String capabilities = req.getParameter("capabilities");
        if (null != capabilities) {
            properties.put("client.capabilities", capabilities);
        }
        LoginResult result = LoginPerformer.getInstance().doLogin(request, properties);
        Session session = result.getSession();
        Tools.disableCaching(resp);
        Login.writeSecretCookie(resp, session, session.getHash(), req.isSecure(), req.getServerName(), conf);
        Login.addHeadersAndCookies(result, resp);
        resp.sendRedirect(LoginTools.generateRedirectURL(null, conf.getHttpAuthAutoLogin(), session.getSessionID(), conf.getUiWebPath()));
    }

    static {
        EnumSet<LogProperties.Name> set = EnumSet.noneOf(LogProperties.Name.class);
        set.add(LogProperties.Name.LOGIN_AUTH_ID);
        set.add(LogProperties.Name.LOGIN_CLIENT);
        set.add(LogProperties.Name.LOGIN_CLIENT_IP);
        set.add(LogProperties.Name.LOGIN_LOGIN);
        set.add(LogProperties.Name.LOGIN_USER_AGENT);
        set.add(LogProperties.Name.LOGIN_VERSION);
        set.add(LogProperties.Name.SESSION_SESSION_ID);
        set.add(LogProperties.Name.SESSION_USER_ID);
        set.add(LogProperties.Name.SESSION_CONTEXT_ID);
        set.add(LogProperties.Name.SESSION_CLIENT_ID);
        set.add(LogProperties.Name.SESSION_SESSION);
        LOG_PROPERTIES = Collections.unmodifiableSet(set);
        SESSION_PREFIX = "open-xchange-session-".intern();
        SECRET_PREFIX = "open-xchange-secret-".intern();
        PUBLIC_SESSION_NAME = "open-xchange-public-session".intern();
        ACTION_CHANGEIP = "changeip".intern();
    }

    private static enum CookieType {
        SESSION,
        SECRET;

    }

    private static interface LoginClosure {
        public LoginResult doLogin(HttpServletRequest var1) throws OXException;
    }
}

