/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.exception;

import com.openexchange.exception.Category;
import com.openexchange.exception.OXExceptionConstants;

public final class Categories
implements OXExceptionConstants {
    private Categories() {
    }

    public static Category getKnownCategoryByName(String name) {
        return Categories.getKnownCategoryByName(name, CATEGORY_ERROR);
    }

    public static Category getKnownCategoryByName(String name, Category fallback) {
        if (CATEGORY_ERROR.toString().equalsIgnoreCase(name)) {
            return CATEGORY_ERROR;
        }
        if (CATEGORY_CAPACITY.toString().equalsIgnoreCase(name)) {
            return CATEGORY_CAPACITY;
        }
        if (CATEGORY_CONFIGURATION.toString().equalsIgnoreCase(name)) {
            return CATEGORY_CONFIGURATION;
        }
        if (CATEGORY_CONFLICT.toString().equalsIgnoreCase(name)) {
            return CATEGORY_CONFLICT;
        }
        if (CATEGORY_CONNECTIVITY.toString().equalsIgnoreCase(name)) {
            return CATEGORY_CONNECTIVITY;
        }
        if (CATEGORY_PERMISSION_DENIED.toString().equalsIgnoreCase(name)) {
            return CATEGORY_PERMISSION_DENIED;
        }
        if (CATEGORY_SERVICE_DOWN.toString().equalsIgnoreCase(name)) {
            return CATEGORY_SERVICE_DOWN;
        }
        if (CATEGORY_TRUNCATED.toString().equalsIgnoreCase(name)) {
            return CATEGORY_TRUNCATED;
        }
        if (CATEGORY_TRY_AGAIN.toString().equalsIgnoreCase(name)) {
            return CATEGORY_TRY_AGAIN;
        }
        if (CATEGORY_USER_INPUT.toString().equalsIgnoreCase(name)) {
            return CATEGORY_USER_INPUT;
        }
        if (CATEGORY_WARNING.toString().equalsIgnoreCase(name)) {
            return CATEGORY_WARNING;
        }
        return fallback;
    }

    public static int getFormerCategoryNumber(Category category) {
        if (null == category) {
            return -1;
        }
        String name = category.toString();
        if (CATEGORY_ERROR.toString().equalsIgnoreCase(name)) {
            return 8;
        }
        if (CATEGORY_CAPACITY.toString().equalsIgnoreCase(name)) {
            return 11;
        }
        if (CATEGORY_CONFIGURATION.toString().equalsIgnoreCase(name)) {
            return 2;
        }
        if (CATEGORY_CONFLICT.toString().equalsIgnoreCase(name)) {
            return 9;
        }
        if (CATEGORY_CONNECTIVITY.toString().equalsIgnoreCase(name)) {
            return 6;
        }
        if (CATEGORY_PERMISSION_DENIED.toString().equalsIgnoreCase(name)) {
            return 3;
        }
        if (CATEGORY_SERVICE_DOWN.toString().equalsIgnoreCase(name)) {
            return 5;
        }
        if (CATEGORY_TRUNCATED.toString().equalsIgnoreCase(name)) {
            return 12;
        }
        if (CATEGORY_TRY_AGAIN.toString().equalsIgnoreCase(name)) {
            return 4;
        }
        if (CATEGORY_USER_INPUT.toString().equalsIgnoreCase(name)) {
            return 1;
        }
        if (CATEGORY_WARNING.toString().equalsIgnoreCase(name)) {
            return 13;
        }
        return -1;
    }
}

