/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.classloader.impl;

import com.openexchange.classloader.impl.DynamicClassLoaderManagerImpl;
import com.openexchange.log.Log;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;

public class ClassLoaderFacade
extends ClassLoader {
    private static final org.apache.commons.logging.Log LOG = Log.loggerFor(ClassLoaderFacade.class);
    private final DynamicClassLoaderManagerImpl manager;
    private static final List<URL> EMPTY_LIST = Collections.emptyList();

    public ClassLoaderFacade(DynamicClassLoaderManagerImpl manager) {
        this.manager = manager;
    }

    @Override
    public URL getResource(String name) {
        ClassLoader[] loaders;
        if (!this.manager.isActive()) {
            LOG.error((Object)"Dynamic class loader has already been deactivated.");
            return null;
        }
        for (ClassLoader cl : loaders = this.manager.getDynamicClassLoaders()) {
            if (cl == null) continue;
            try {
                URL u = cl.getResource(name);
                if (u == null) continue;
                return u;
            }
            catch (Throwable t) {
                LOG.error((Object)("Exception while querying class loader " + cl + " for resource " + name), t);
            }
        }
        return null;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        if (!this.manager.isActive()) {
            LOG.error((Object)"Dynamic class loader has already been deactivated.");
            return Collections.enumeration(EMPTY_LIST);
        }
        ClassLoader[] loaders = this.manager.getDynamicClassLoaders();
        ArrayList<URL> resources = new ArrayList<URL>();
        for (ClassLoader cl : loaders) {
            if (cl == null) continue;
            try {
                Enumeration<URL> e = cl.getResources(name);
                if (e == null || !e.hasMoreElements()) continue;
                resources.addAll(Collections.list(e));
            }
            catch (Throwable t) {
                LOG.error((Object)("Exception while querying class loader " + cl + " for resources " + name), t);
            }
        }
        return Collections.enumeration(resources);
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        ClassLoader[] loaders;
        if (!this.manager.isActive()) {
            LOG.error((Object)"Dynamic class loader has already been deactivated.");
            throw new ClassNotFoundException(name);
        }
        for (ClassLoader cl : loaders = this.manager.getDynamicClassLoaders()) {
            if (cl == null) continue;
            try {
                Class<?> c = cl.loadClass(name);
                return c;
            }
            catch (ClassNotFoundException cnfe) {
            }
            catch (Throwable t) {
                LOG.error((Object)("Exception while trying to load class " + name + " from class loader " + cl), t);
            }
        }
        throw new ClassNotFoundException(name);
    }
}

