/*
 * Decompiled with CFR 0.152.
 */
package org.json.helpers;

import java.lang.reflect.Method;
import java.util.Arrays;
import org.json.helpers.misc.FloatingDecimal;

abstract class AbstractStringAllocator
implements Appendable,
CharSequence {
    private static final Method getChars;
    char[] value;
    int count;
    static final char[] digits;
    static final char[] DigitTens;
    static final char[] DigitOnes;
    static final int[] sizeTable;

    protected AbstractStringAllocator() {
    }

    protected AbstractStringAllocator(int capacity) {
        this.value = new char[capacity];
    }

    @Override
    public int length() {
        return this.count;
    }

    public int capacity() {
        return this.value.length;
    }

    public void ensureCapacity(int minimumCapacity) {
        if (minimumCapacity > this.value.length) {
            this.expandCapacity(minimumCapacity);
        }
    }

    void expandCapacity(int minimumCapacity) {
        int newCapacity = (this.value.length + 1) * 2;
        if (newCapacity < 0) {
            newCapacity = Integer.MAX_VALUE;
        } else if (minimumCapacity > newCapacity) {
            newCapacity = minimumCapacity;
        }
        this.value = Arrays.copyOf(this.value, newCapacity);
    }

    public void trimToSize() {
        if (this.count < this.value.length) {
            this.value = Arrays.copyOf(this.value, this.count);
        }
    }

    @Override
    public char charAt(int index) {
        if (index < 0 || index >= this.count) {
            throw new StringIndexOutOfBoundsException(index);
        }
        return this.value[index];
    }

    public int codePointAt(int index) {
        if (index < 0 || index >= this.count) {
            throw new StringIndexOutOfBoundsException(index);
        }
        return Character.codePointAt(this.value, index);
    }

    public int codePointBefore(int index) {
        int i = index - 1;
        if (i < 0 || i >= this.count) {
            throw new StringIndexOutOfBoundsException(index);
        }
        return Character.codePointBefore(this.value, index);
    }

    public int codePointCount(int beginIndex, int endIndex) {
        if (beginIndex < 0 || endIndex > this.count || beginIndex > endIndex) {
            throw new IndexOutOfBoundsException();
        }
        return AbstractStringAllocator.codePointCountImpl(this.value, beginIndex, endIndex - beginIndex);
    }

    static int codePointCountImpl(char[] a, int offset, int count) {
        int endIndex = offset + count;
        int n = 0;
        int i = offset;
        while (i < endIndex) {
            ++n;
            if (!Character.isHighSurrogate(a[i++]) || i >= endIndex || !Character.isLowSurrogate(a[i])) continue;
            ++i;
        }
        return n;
    }

    public int offsetByCodePoints(int index, int codePointOffset) {
        if (index < 0 || index > this.count) {
            throw new IndexOutOfBoundsException();
        }
        return AbstractStringAllocator.offsetByCodePointsImpl(this.value, 0, this.count, index, codePointOffset);
    }

    static int offsetByCodePointsImpl(char[] a, int start, int count, int index, int codePointOffset) {
        int x = index;
        if (codePointOffset >= 0) {
            int i;
            int limit = start + count;
            for (i = 0; x < limit && i < codePointOffset; ++i) {
                if (!Character.isHighSurrogate(a[x++]) || x >= limit || !Character.isLowSurrogate(a[x])) continue;
                ++x;
            }
            if (i < codePointOffset) {
                throw new IndexOutOfBoundsException();
            }
        } else {
            int i;
            for (i = codePointOffset; x > start && i < 0; ++i) {
                if (!Character.isLowSurrogate(a[--x]) || x <= start || !Character.isHighSurrogate(a[x - 1])) continue;
                --x;
            }
            if (i < 0) {
                throw new IndexOutOfBoundsException();
            }
        }
        return x;
    }

    public void getChars(int srcBegin, int srcEnd, char[] dst, int dstBegin) {
        if (srcBegin < 0) {
            throw new StringIndexOutOfBoundsException(srcBegin);
        }
        if (srcEnd < 0 || srcEnd > this.count) {
            throw new StringIndexOutOfBoundsException(srcEnd);
        }
        if (srcBegin > srcEnd) {
            throw new StringIndexOutOfBoundsException("srcBegin > srcEnd");
        }
        System.arraycopy(this.value, srcBegin, dst, dstBegin, srcEnd - srcBegin);
    }

    public void setCharAt(int index, char ch) {
        if (index < 0 || index >= this.count) {
            throw new StringIndexOutOfBoundsException(index);
        }
        this.value[index] = ch;
    }

    public AbstractStringAllocator append(Object obj) {
        return this.append(String.valueOf(obj));
    }

    public AbstractStringAllocator append(String str) {
        int len;
        if (str == null) {
            str = "null";
        }
        if ((len = str.length()) == 0) {
            return this;
        }
        int newCount = this.count + len;
        if (newCount > this.value.length) {
            this.expandCapacity(newCount);
        }
        str.getChars(0, len, this.value, this.count);
        this.count = newCount;
        return this;
    }

    public AbstractStringAllocator append(StringBuffer sb) {
        if (sb == null) {
            return this.append("null");
        }
        int len = sb.length();
        int newCount = this.count + len;
        if (newCount > this.value.length) {
            this.expandCapacity(newCount);
        }
        sb.getChars(0, len, this.value, this.count);
        this.count = newCount;
        return this;
    }

    @Override
    public AbstractStringAllocator append(CharSequence s) {
        if (s == null) {
            s = "null";
        }
        if (s instanceof String) {
            return this.append((String)s);
        }
        if (s instanceof StringBuffer) {
            return this.append((StringBuffer)s);
        }
        return this.append(s, 0, s.length());
    }

    @Override
    public AbstractStringAllocator append(CharSequence s, int start, int end) {
        if (s == null) {
            s = "null";
        }
        if (start < 0 || end < 0 || start > end || end > s.length()) {
            throw new IndexOutOfBoundsException("start " + start + ", end " + end + ", s.length() " + s.length());
        }
        int len = end - start;
        if (len == 0) {
            return this;
        }
        int newCount = this.count + len;
        if (newCount > this.value.length) {
            this.expandCapacity(newCount);
        }
        for (int i = start; i < end; ++i) {
            this.value[this.count++] = s.charAt(i);
        }
        this.count = newCount;
        return this;
    }

    public AbstractStringAllocator append(char[] str) {
        int newCount = this.count + str.length;
        if (newCount > this.value.length) {
            this.expandCapacity(newCount);
        }
        System.arraycopy(str, 0, this.value, this.count, str.length);
        this.count = newCount;
        return this;
    }

    public AbstractStringAllocator append(char[] str, int offset, int len) {
        int newCount = this.count + len;
        if (newCount > this.value.length) {
            this.expandCapacity(newCount);
        }
        System.arraycopy(str, offset, this.value, this.count, len);
        this.count = newCount;
        return this;
    }

    public AbstractStringAllocator append(boolean b) {
        if (b) {
            int newCount = this.count + 4;
            if (newCount > this.value.length) {
                this.expandCapacity(newCount);
            }
            this.value[this.count++] = 116;
            this.value[this.count++] = 114;
            this.value[this.count++] = 117;
            this.value[this.count++] = 101;
        } else {
            int newCount = this.count + 5;
            if (newCount > this.value.length) {
                this.expandCapacity(newCount);
            }
            this.value[this.count++] = 102;
            this.value[this.count++] = 97;
            this.value[this.count++] = 108;
            this.value[this.count++] = 115;
            this.value[this.count++] = 101;
        }
        return this;
    }

    @Override
    public AbstractStringAllocator append(char c) {
        int newCount = this.count + 1;
        if (newCount > this.value.length) {
            this.expandCapacity(newCount);
        }
        this.value[this.count++] = c;
        return this;
    }

    public AbstractStringAllocator append(int i) {
        if (i == Integer.MIN_VALUE) {
            this.append("-2147483648");
            return this;
        }
        int appendedLength = i < 0 ? AbstractStringAllocator.stringSizeOfInt(-i) + 1 : AbstractStringAllocator.stringSizeOfInt(i);
        int spaceNeeded = this.count + appendedLength;
        if (spaceNeeded > this.value.length) {
            this.expandCapacity(spaceNeeded);
        }
        AbstractStringAllocator.getChars(i, spaceNeeded, this.value);
        this.count = spaceNeeded;
        return this;
    }

    static void getChars(int i, int index, char[] buf) {
        int r;
        int q;
        int charPos = index;
        int sign = 0;
        if (i < 0) {
            sign = 45;
            i = -i;
        }
        while (i >= 65536) {
            q = i / 100;
            r = i - ((q << 6) + (q << 5) + (q << 2));
            i = q;
            buf[--charPos] = DigitOnes[r];
            buf[--charPos] = DigitTens[r];
        }
        do {
            q = i * 52429 >>> 19;
            r = i - ((q << 3) + (q << 1));
            buf[--charPos] = digits[r];
        } while ((i = q) != 0);
        if (sign != 0) {
            buf[--charPos] = sign;
        }
    }

    static int stringSizeOfInt(int x) {
        int i = 0;
        while (x > sizeTable[i]) {
            ++i;
        }
        return i + 1;
    }

    public AbstractStringAllocator append(long l) {
        if (l == Long.MIN_VALUE) {
            this.append("-9223372036854775808");
            return this;
        }
        int appendedLength = l < 0L ? AbstractStringAllocator.stringSizeOfLong(-l) + 1 : AbstractStringAllocator.stringSizeOfLong(l);
        int spaceNeeded = this.count + appendedLength;
        if (spaceNeeded > this.value.length) {
            this.expandCapacity(spaceNeeded);
        }
        AbstractStringAllocator.getChars(l, spaceNeeded, this.value);
        this.count = spaceNeeded;
        return this;
    }

    static void getChars(long i, int index, char[] buf) {
        int q2;
        int r;
        int charPos = index;
        int sign = 0;
        if (i < 0L) {
            sign = 45;
            i = -i;
        }
        while (i > Integer.MAX_VALUE) {
            long q = i / 100L;
            r = (int)(i - ((q << 6) + (q << 5) + (q << 2)));
            i = q;
            buf[--charPos] = DigitOnes[r];
            buf[--charPos] = DigitTens[r];
        }
        int i2 = (int)i;
        while (i2 >= 65536) {
            q2 = i2 / 100;
            r = i2 - ((q2 << 6) + (q2 << 5) + (q2 << 2));
            i2 = q2;
            buf[--charPos] = DigitOnes[r];
            buf[--charPos] = DigitTens[r];
        }
        do {
            q2 = i2 * 52429 >>> 19;
            r = i2 - ((q2 << 3) + (q2 << 1));
            buf[--charPos] = digits[r];
        } while ((i2 = q2) != 0);
        if (sign != 0) {
            buf[--charPos] = sign;
        }
    }

    static int stringSizeOfLong(long x) {
        long p = 10L;
        for (int i = 1; i < 19; ++i) {
            if (x < p) {
                return i;
            }
            p = 10L * p;
        }
        return 19;
    }

    public AbstractStringAllocator append(float f) {
        new FloatingDecimal(f).appendTo(this);
        return this;
    }

    public AbstractStringAllocator append(double d) {
        new FloatingDecimal(d).appendTo(this);
        return this;
    }

    public AbstractStringAllocator delete(int start, int end) {
        if (start < 0) {
            throw new StringIndexOutOfBoundsException(start);
        }
        if (end > this.count) {
            end = this.count;
        }
        if (start > end) {
            throw new StringIndexOutOfBoundsException();
        }
        int len = end - start;
        if (len > 0) {
            System.arraycopy(this.value, start + len, this.value, start, this.count - end);
            this.count -= len;
        }
        return this;
    }

    public AbstractStringAllocator appendCodePoint(int codePoint) {
        int newCount;
        if (!Character.isValidCodePoint(codePoint)) {
            throw new IllegalArgumentException();
        }
        int n = 1;
        if (codePoint >= 65536) {
            ++n;
        }
        if ((newCount = this.count + n) > this.value.length) {
            this.expandCapacity(newCount);
        }
        if (n == 1) {
            this.value[this.count++] = (char)codePoint;
        } else {
            AbstractStringAllocator.toSurrogates(codePoint, this.value, this.count);
            this.count += n;
        }
        return this;
    }

    static void toSurrogates(int codePoint, char[] dst, int index) {
        int offset = codePoint - 65536;
        dst[index + 1] = (char)((offset & 0x3FF) + 56320);
        dst[index] = (char)((offset >>> 10) + 55296);
    }

    public AbstractStringAllocator deleteCharAt(int index) {
        if (index < 0 || index >= this.count) {
            throw new StringIndexOutOfBoundsException(index);
        }
        System.arraycopy(this.value, index + 1, this.value, index, this.count - index - 1);
        --this.count;
        return this;
    }

    public AbstractStringAllocator replace(int start, int end, String str) {
        int len;
        int newCount;
        if (start < 0) {
            throw new StringIndexOutOfBoundsException(start);
        }
        if (start > this.count) {
            throw new StringIndexOutOfBoundsException("start > length()");
        }
        if (start > end) {
            throw new StringIndexOutOfBoundsException("start > end");
        }
        if (end > this.count) {
            end = this.count;
        }
        if ((newCount = this.count + (len = str.length()) - (end - start)) > this.value.length) {
            this.expandCapacity(newCount);
        }
        System.arraycopy(this.value, end, this.value, start + len, this.count - end);
        this.getChars(str, start);
        this.count = newCount;
        return this;
    }

    private void getChars(String str, int start) {
        try {
            getChars.invoke((Object)str, this.value, start);
        }
        catch (Exception e) {
            char[] charArray = str.toCharArray();
            System.arraycopy(charArray, 0, this.value, start, charArray.length);
        }
    }

    public String substring(int start) {
        return this.substring(start, this.count);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.substring(start, end);
    }

    public String substring(int start, int end) {
        if (start < 0) {
            throw new StringIndexOutOfBoundsException(start);
        }
        if (end > this.count) {
            throw new StringIndexOutOfBoundsException(end);
        }
        if (start > end) {
            throw new StringIndexOutOfBoundsException(end - start);
        }
        return new String(this.value, start, end - start);
    }

    public AbstractStringAllocator insert(int index, char[] str, int offset, int len) {
        if (index < 0 || index > this.length()) {
            throw new StringIndexOutOfBoundsException(index);
        }
        if (offset < 0 || len < 0 || offset > str.length - len) {
            throw new StringIndexOutOfBoundsException("offset " + offset + ", len " + len + ", str.length " + str.length);
        }
        int newCount = this.count + len;
        if (newCount > this.value.length) {
            this.expandCapacity(newCount);
        }
        System.arraycopy(this.value, index, this.value, index + len, this.count - index);
        System.arraycopy(str, offset, this.value, index, len);
        this.count = newCount;
        return this;
    }

    public AbstractStringAllocator insert(int offset, Object obj) {
        return this.insert(offset, String.valueOf(obj));
    }

    public AbstractStringAllocator insert(int offset, String str) {
        int len;
        int newCount;
        if (offset < 0 || offset > this.length()) {
            throw new StringIndexOutOfBoundsException(offset);
        }
        if (str == null) {
            str = "null";
        }
        if ((newCount = this.count + (len = str.length())) > this.value.length) {
            this.expandCapacity(newCount);
        }
        System.arraycopy(this.value, offset, this.value, offset + len, this.count - offset);
        this.getChars(str, offset);
        this.count = newCount;
        return this;
    }

    public AbstractStringAllocator insert(int offset, char[] str) {
        if (offset < 0 || offset > this.length()) {
            throw new StringIndexOutOfBoundsException(offset);
        }
        int len = str.length;
        int newCount = this.count + len;
        if (newCount > this.value.length) {
            this.expandCapacity(newCount);
        }
        System.arraycopy(this.value, offset, this.value, offset + len, this.count - offset);
        System.arraycopy(str, 0, this.value, offset, len);
        this.count = newCount;
        return this;
    }

    public AbstractStringAllocator insert(int dstOffset, CharSequence s) {
        if (s == null) {
            s = "null";
        }
        if (s instanceof String) {
            return this.insert(dstOffset, (String)s);
        }
        return this.insert(dstOffset, s, 0, s.length());
    }

    public AbstractStringAllocator insert(int dstOffset, CharSequence s, int start, int end) {
        if (s == null) {
            s = "null";
        }
        if (dstOffset < 0 || dstOffset > this.length()) {
            throw new IndexOutOfBoundsException("dstOffset " + dstOffset);
        }
        if (start < 0 || end < 0 || start > end || end > s.length()) {
            throw new IndexOutOfBoundsException("start " + start + ", end " + end + ", s.length() " + s.length());
        }
        int len = end - start;
        if (len == 0) {
            return this;
        }
        int newCount = this.count + len;
        if (newCount > this.value.length) {
            this.expandCapacity(newCount);
        }
        System.arraycopy(this.value, dstOffset, this.value, dstOffset + len, this.count - dstOffset);
        for (int i = start; i < end; ++i) {
            this.value[dstOffset++] = s.charAt(i);
        }
        this.count = newCount;
        return this;
    }

    public AbstractStringAllocator insert(int offset, boolean b) {
        return this.insert(offset, String.valueOf(b));
    }

    public AbstractStringAllocator insert(int offset, char c) {
        int newCount = this.count + 1;
        if (newCount > this.value.length) {
            this.expandCapacity(newCount);
        }
        System.arraycopy(this.value, offset, this.value, offset + 1, this.count - offset);
        this.value[offset] = c;
        this.count = newCount;
        return this;
    }

    public AbstractStringAllocator insert(int offset, int i) {
        return this.insert(offset, String.valueOf(i));
    }

    public AbstractStringAllocator insert(int offset, long l) {
        return this.insert(offset, String.valueOf(l));
    }

    public AbstractStringAllocator insert(int offset, float f) {
        return this.insert(offset, String.valueOf(f));
    }

    public AbstractStringAllocator insert(int offset, double d) {
        return this.insert(offset, String.valueOf(d));
    }

    public int indexOf(String str) {
        return this.indexOf(str, 0);
    }

    public int indexOf(String str, int fromIndex) {
        return AbstractStringAllocator.indexOf(this.value, 0, this.count, str.toCharArray(), 0, str.length(), fromIndex);
    }

    static int indexOf(char[] source, int sourceOffset, int sourceCount, char[] target, int targetOffset, int targetCount, int fromIndex) {
        if (fromIndex >= sourceCount) {
            return targetCount == 0 ? sourceCount : -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (targetCount == 0) {
            return fromIndex;
        }
        char first = target[targetOffset];
        int max = sourceOffset + (sourceCount - targetCount);
        for (int i = sourceOffset + fromIndex; i <= max; ++i) {
            if (source[i] != first) {
                while (++i <= max && source[i] != first) {
                }
            }
            if (i > max) continue;
            int j = i + 1;
            int end = j + targetCount - 1;
            int k = targetOffset + 1;
            while (j < end && source[j] == target[k]) {
                ++j;
                ++k;
            }
            if (j != end) continue;
            return i - sourceOffset;
        }
        return -1;
    }

    public int lastIndexOf(String str) {
        return this.lastIndexOf(str, this.count);
    }

    public int lastIndexOf(String str, int fromIndex) {
        return AbstractStringAllocator.lastIndexOf(this.value, 0, this.count, str.toCharArray(), 0, str.length(), fromIndex);
    }

    static int lastIndexOf(char[] source, int sourceOffset, int sourceCount, char[] target, int targetOffset, int targetCount, int fromIndex) {
        int start;
        int rightIndex = sourceCount - targetCount;
        if (fromIndex < 0) {
            return -1;
        }
        if (fromIndex > rightIndex) {
            fromIndex = rightIndex;
        }
        if (targetCount == 0) {
            return fromIndex;
        }
        int strLastIndex = targetOffset + targetCount - 1;
        char strLastChar = target[strLastIndex];
        int min = sourceOffset + targetCount - 1;
        int i = min + fromIndex;
        block0: while (true) {
            if (i >= min && source[i] != strLastChar) {
                --i;
                continue;
            }
            if (i < min) {
                return -1;
            }
            int j = i - 1;
            start = j - (targetCount - 1);
            int k = strLastIndex - 1;
            while (j > start) {
                if (source[j--] == target[k--]) continue;
                --i;
                continue block0;
            }
            break;
        }
        return start - sourceOffset + 1;
    }

    public AbstractStringAllocator reverse() {
        boolean hasSurrogate = false;
        int n = this.count - 1;
        for (int j = n - 1 >> 1; j >= 0; --j) {
            char temp = this.value[j];
            char temp2 = this.value[n - j];
            if (!hasSurrogate) {
                hasSurrogate = temp >= '\ud800' && temp <= '\udfff' || temp2 >= '\ud800' && temp2 <= '\udfff';
            }
            this.value[j] = temp2;
            this.value[n - j] = temp;
        }
        if (hasSurrogate) {
            for (int i = 0; i < this.count - 1; ++i) {
                char c1;
                char c2 = this.value[i];
                if (!Character.isLowSurrogate(c2) || !Character.isHighSurrogate(c1 = this.value[i + 1])) continue;
                this.value[i++] = c1;
                this.value[i] = c2;
            }
        }
        return this;
    }

    @Override
    public abstract String toString();

    final char[] getValue() {
        return this.value;
    }

    static {
        Method method;
        try {
            method = String.class.getDeclaredMethod("getChars", char[].class, Integer.TYPE);
            method.setAccessible(true);
        }
        catch (SecurityException e) {
            method = null;
        }
        catch (NoSuchMethodException e) {
            method = null;
        }
        getChars = method;
        digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
        DigitTens = new char[]{'0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9'};
        DigitOnes = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
        sizeTable = new int[]{9, 99, 999, 9999, 99999, 999999, 9999999, 99999999, 999999999, Integer.MAX_VALUE};
    }
}

