/*
 * Decompiled with CFR 0.152.
 */
package org.json;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.json.AbstractJSONValue;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONString;
import org.json.JSONTokener;
import org.json.JSONValue;
import org.json.helpers.StringAllocator;
import org.json.helpers.UnsynchronizedStringReader;
import org.json.helpers.UnsynchronizedStringWriter;

public class JSONObject
extends AbstractJSONValue {
    private static final long serialVersionUID = 3666538885751033341L;
    protected static final AtomicReference<Logger> LOGGER = new AtomicReference();
    private static final AtomicInteger MAX_SIZE = new AtomicInteger(0);
    private static final String STR_TRUE = "true".intern();
    private static final String STR_FALSE = "false".intern();
    private static final String STR_NULL = "null".intern();
    private final Map<String, Object> myHashMap;
    public static final Object NULL = new Null();
    private static final String EMPTY = "{}".intern();
    private static final Pattern PATTERN_CRLF = Pattern.compile("\r?\n");

    public static void setLogger(Logger logger) {
        LOGGER.set(logger);
    }

    public static void setMaxSize(int maxSize) {
        MAX_SIZE.set(maxSize <= 0 ? 0 : maxSize);
    }

    public JSONObject() {
        this.myHashMap = new HashMap<String, Object>();
    }

    public JSONObject(int initialCapacity) {
        this.myHashMap = new HashMap<String, Object>(initialCapacity);
    }

    public JSONObject(JSONObject jo, String[] sa) throws JSONException {
        this();
        for (int i = 0; i < sa.length; ++i) {
            this.putOpt(sa[i], jo.opt(sa[i]));
        }
    }

    public JSONObject(JSONTokener x) throws JSONException {
        this();
        this.parseJSONTokener(x);
    }

    private final void parseJSONTokener(JSONTokener tokener) throws JSONException {
        if (tokener.nextClean() != '{') {
            throw tokener.syntaxError("A JSONObject text must begin with '{'");
        }
        block8: while (true) {
            char c = tokener.nextClean();
            switch (c) {
                case '\u0000': {
                    throw tokener.syntaxError("A JSONObject text must end with '}'");
                }
                case '}': {
                    return;
                }
            }
            tokener.back();
            String key = tokener.nextValue().toString();
            c = tokener.nextClean();
            if (c == '=') {
                if (tokener.next() != '>') {
                    tokener.back();
                }
            } else if (c != ':') {
                throw tokener.syntaxError("Expected a ':' after a key");
            }
            this.put(key, tokener.nextValue());
            switch (tokener.nextClean()) {
                case ',': 
                case ';': {
                    if (tokener.nextClean() == '}') {
                        return;
                    }
                    tokener.back();
                    continue block8;
                }
                case '}': {
                    return;
                }
            }
            break;
        }
        throw tokener.syntaxError("Expected a ',' or '}'");
    }

    public JSONObject(JSONObject other) {
        this(null == other ? null : other.myHashMap);
    }

    public JSONObject(Map<String, ? extends Object> map) {
        if (null == map || map.isEmpty()) {
            this.myHashMap = new HashMap<String, Object>();
        } else {
            int max = MAX_SIZE.get();
            int size = map.size();
            if (max > 0 && size > max) {
                throw new IllegalStateException("Max. size (" + max + ") for JSON object exceeded");
            }
            this.myHashMap = new HashMap<String, Object>(map.size());
            for (Map.Entry<String, ? extends Object> entry : map.entrySet()) {
                Object value = entry.getValue();
                if (value instanceof JSONValue) {
                    JSONValue jsonValue = (JSONValue)value;
                    if (jsonValue.isArray()) {
                        this.myHashMap.put(entry.getKey(), new JSONArray(jsonValue.toArray()));
                        continue;
                    }
                    this.myHashMap.put(entry.getKey(), new JSONObject(jsonValue.toObject()));
                    continue;
                }
                this.myHashMap.put(entry.getKey(), value);
            }
        }
    }

    public JSONObject(Object object, String[] names) {
        this();
        Class<?> c = object.getClass();
        for (int i = 0; i < names.length; ++i) {
            try {
                String name = names[i];
                Field field = c.getField(name);
                Object value = field.get(object);
                this.put(name, value);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public JSONObject(Reader reader) throws JSONException {
        this();
        JSONObject.parse(reader, this);
    }

    public JSONObject(String string) throws JSONException {
        this();
        JSONObject.parse(new UnsynchronizedStringReader(string), this);
    }

    public JSONObject parseJSONString(String string) throws JSONException {
        JSONObject.parse(new UnsynchronizedStringReader(string), this);
        return this;
    }

    public JSONObject accumulate(String key, Object value) throws JSONException {
        Object o = this.opt(key);
        if (o == null) {
            this.put(key, value instanceof JSONArray ? new JSONArray().put(value) : value);
        } else if (o instanceof JSONArray) {
            ((JSONArray)o).put(value);
        } else {
            this.put(key, new JSONArray().put(o).put(value));
        }
        return this;
    }

    public JSONObject append(String key, Object value) throws JSONException {
        Object o = this.opt(key);
        if (o == null) {
            this.put(key, new JSONArray().put(value));
        } else if (o instanceof JSONArray) {
            this.put(key, ((JSONArray)o).put(value));
        } else {
            throw new JSONException("JSONObject[" + key + "] is not a JSONArray.");
        }
        return this;
    }

    @Override
    public void reset() {
        this.myHashMap.clear();
    }

    public static final String doubleToString(double d) {
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            return STR_NULL;
        }
        String s = Double.toString(d);
        if (s.indexOf(46) > 0 && s.indexOf(101) < 0 && s.indexOf(69) < 0) {
            while (s.endsWith("0")) {
                s = s.substring(0, s.length() - 1);
            }
            if (s.endsWith(".")) {
                s = s.substring(0, s.length() - 1);
            }
        }
        return s;
    }

    public Object get(String key) throws JSONException {
        Object o = this.opt(key);
        if (o == null) {
            throw new JSONException("JSONObject[" + JSONObject.quote(key) + "] not found.");
        }
        return o;
    }

    public boolean getBoolean(String key) throws JSONException {
        Object o = this.get(key);
        if (o.equals(Boolean.FALSE) || o instanceof String && ((String)o).equalsIgnoreCase(STR_FALSE)) {
            return false;
        }
        if (o.equals(Boolean.TRUE) || o instanceof String && ((String)o).equalsIgnoreCase(STR_TRUE)) {
            return true;
        }
        throw new JSONException("JSONObject[" + JSONObject.quote(key) + "] is not a Boolean.");
    }

    public double getDouble(String key) throws JSONException {
        Object o = this.get(key);
        try {
            return o instanceof Number ? ((Number)o).doubleValue() : Double.parseDouble((String)o);
        }
        catch (Exception e) {
            throw new JSONException("JSONObject[" + JSONObject.quote(key) + "] is not a number.", e);
        }
    }

    public int getInt(String key) throws JSONException {
        Object o = this.get(key);
        return o instanceof Number ? ((Number)o).intValue() : (int)this.getDouble(key);
    }

    public JSONArray getJSONArray(String key) throws JSONException {
        Object o = this.get(key);
        if (o instanceof JSONArray) {
            return (JSONArray)o;
        }
        throw new JSONException("JSONObject[" + JSONObject.quote(key) + "] is not a JSONArray, but " + o.getClass().getName());
    }

    public JSONObject getJSONObject(String key) throws JSONException {
        Object o = this.get(key);
        if (o instanceof JSONObject) {
            return (JSONObject)o;
        }
        throw new JSONException("JSONObject[" + JSONObject.quote(key) + "] is not a JSONObject, but " + o.getClass().getName());
    }

    public long getLong(String key) throws JSONException {
        Object o = this.get(key);
        return o instanceof Number ? ((Number)o).longValue() : (long)this.getDouble(key);
    }

    public String getString(String key) throws JSONException {
        return this.get(key).toString();
    }

    public boolean has(String key) {
        return this.myHashMap.containsKey(key);
    }

    public boolean hasAndNotNull(String key) {
        return this.has(key) && !this.isNull(key);
    }

    public boolean isNull(String key) {
        return NULL.equals(this.opt(key));
    }

    public Iterator<String> keys() {
        return this.myHashMap.keySet().iterator();
    }

    public Set<String> keySet() {
        return this.myHashMap.keySet();
    }

    public Set<Map.Entry<String, Object>> entrySet() {
        return this.myHashMap.entrySet();
    }

    @Override
    public boolean isEmpty() {
        return this.myHashMap.isEmpty();
    }

    @Override
    public int length() {
        return this.myHashMap.size();
    }

    public JSONArray names() {
        JSONArray ja = new JSONArray();
        Set<String> keys = this.keySet();
        for (String name : keys) {
            ja.put(name);
        }
        return ja.length() == 0 ? null : ja;
    }

    public static final String numberToString(Number n) throws JSONException {
        if (n == null) {
            throw new JSONException("Null pointer");
        }
        String s = n.toString();
        if (s.indexOf(46) > 0 && s.indexOf(101) < 0 && s.indexOf(69) < 0) {
            while (s.endsWith("0")) {
                s = s.substring(0, s.length() - 1);
            }
            if (s.endsWith(".")) {
                s = s.substring(0, s.length() - 1);
            }
        }
        return s;
    }

    public Object opt(String key) {
        return key == null ? null : this.myHashMap.get(key);
    }

    public boolean optBoolean(String key) {
        return this.optBoolean(key, false);
    }

    public boolean optBoolean(String key, boolean defaultValue) {
        try {
            return this.getBoolean(key);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public JSONObject put(String key, Collection<? extends Object> value) throws JSONException {
        this.put(key, new JSONArray(value));
        return this;
    }

    public double optDouble(String key) {
        return this.optDouble(key, Double.NaN);
    }

    public double optDouble(String key, double defaultValue) {
        try {
            Object o = this.opt(key);
            return o instanceof Number ? ((Number)o).doubleValue() : new Double((String)o).doubleValue();
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public int optInt(String key) {
        return this.optInt(key, 0);
    }

    public int optInt(String key, int defaultValue) {
        try {
            return this.getInt(key);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public JSONArray optJSONArray(String key) {
        Object o = this.opt(key);
        return o instanceof JSONArray ? (JSONArray)o : null;
    }

    public JSONObject optJSONObject(String key) {
        Object o = this.opt(key);
        return o instanceof JSONObject ? (JSONObject)o : null;
    }

    public long optLong(String key) {
        return this.optLong(key, 0L);
    }

    public long optLong(String key, long defaultValue) {
        try {
            return this.getLong(key);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public String optString(String key) {
        return this.optString(key, "");
    }

    public String optString(String key, String defaultValue) {
        Object o = this.opt(key);
        return o != null ? o.toString() : defaultValue;
    }

    public JSONObject put(String key, boolean value) throws JSONException {
        this.put(key, value ? Boolean.TRUE : Boolean.FALSE);
        return this;
    }

    public JSONObject put(String key, double value) throws JSONException {
        this.put(key, (Object)value);
        return this;
    }

    public JSONObject put(String key, int value) throws JSONException {
        this.put(key, (Object)value);
        return this;
    }

    public JSONObject put(String key, long value) throws JSONException {
        this.put(key, (Object)value);
        return this;
    }

    public JSONObject put(String key, Map<String, ? extends Object> value) throws JSONException {
        this.put(key, new JSONObject(value));
        return this;
    }

    public JSONObject put(String key, Object value) throws JSONException {
        if (key == null) {
            throw new JSONException("Null key.");
        }
        if (value != null) {
            int max = MAX_SIZE.get();
            if (max > 0 && this.myHashMap.size() >= max) {
                throw new IllegalStateException("Max. size (" + max + ") for JSON object exceeded");
            }
            this.myHashMap.put(key, value);
        } else {
            this.remove(key);
        }
        return this;
    }

    public JSONObject putOpt(String key, Object value) throws JSONException {
        if (key != null && value != null) {
            this.put(key, value);
        }
        return this;
    }

    public static final String quote(String string) {
        if (string == null || string.length() == 0) {
            return "\"\"";
        }
        char c = '\u0000';
        int len = string.length();
        StringAllocator sb = new StringAllocator(len + 4);
        sb.append('\"');
        block9: for (int i = 0; i < len; ++i) {
            char b = c;
            c = string.charAt(i);
            switch (c) {
                case '\"': 
                case '\\': {
                    sb.append('\\');
                    sb.append(c);
                    continue block9;
                }
                case '/': {
                    if (b == '<') {
                        sb.append('\\');
                    }
                    sb.append(c);
                    continue block9;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block9;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block9;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block9;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block9;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block9;
                }
                default: {
                    if (c < ' ' || c >= '\u0080' && c < '\u00a0' || c >= '\u2000' && c < '\u2100') {
                        String t = "000" + Integer.toHexString(c);
                        sb.append("\\u").append(t.substring(t.length() - 4));
                        continue block9;
                    }
                    sb.append(c);
                }
            }
        }
        sb.append('\"');
        return sb.toString();
    }

    public Object remove(String key) {
        return this.myHashMap.remove(key);
    }

    public JSONArray toJSONArray(JSONArray names) throws JSONException {
        if (names == null || names.length() == 0) {
            return null;
        }
        JSONArray ja = new JSONArray();
        for (int i = 0; i < names.length(); ++i) {
            ja.put(this.opt(names.getString(i)));
        }
        return ja;
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean asciiOnly) {
        try {
            int n = this.length();
            if (n <= 0) {
                return EMPTY;
            }
            UnsynchronizedStringWriter writer = new UnsynchronizedStringWriter(n << 4);
            this.write(writer, asciiOnly);
            return writer.toString();
        }
        catch (Exception e) {
            Logger logger = LOGGER.get();
            if (null != logger) {
                logger.logp(Level.SEVERE, JSONObject.class.getName(), "toString()", e.getMessage(), e);
            }
            return null;
        }
    }

    public String toString(int indentFactor) throws JSONException {
        return this.toString(indentFactor, 0);
    }

    @Override
    public String toString(int indentFactor, int indent) throws JSONException {
        String string;
        int n = this.length();
        if (n == 0) {
            return EMPTY;
        }
        JsonGenerator jGenerator = null;
        try {
            UnsynchronizedStringWriter writer = new UnsynchronizedStringWriter(n << 4);
            jGenerator = JSONObject.createGenerator(writer, false);
            jGenerator.setPrettyPrinter(STANDARD_DEFAULT_PRETTY_PRINTER);
            JSONObject.write(this, jGenerator);
            string = writer.toString();
        }
        catch (IOException e) {
            try {
                throw new JSONException(e);
            }
            catch (Throwable throwable) {
                JSONObject.close(jGenerator);
                throw throwable;
            }
        }
        JSONObject.close(jGenerator);
        return string;
    }

    static final String valueToString(Object value) throws JSONException {
        if (value == null || NULL.equals(value)) {
            return STR_NULL;
        }
        if (value instanceof JSONString) {
            String o;
            try {
                o = ((JSONString)value).toJSONString();
            }
            catch (Exception e) {
                throw new JSONException(e);
            }
            if (o instanceof String) {
                return o;
            }
            throw new JSONException("Bad value from toJSONString: " + o);
        }
        if (value instanceof Number) {
            return JSONObject.numberToString((Number)value);
        }
        if (value instanceof Boolean || value instanceof JSONValue) {
            return value.toString();
        }
        return JSONObject.quote(value.toString());
    }

    static final String valueToString(Object value, int indentFactor, int indent) throws JSONException {
        if (value == null || NULL.equals(value)) {
            return STR_NULL;
        }
        try {
            String o;
            if (value instanceof JSONString && (o = ((JSONString)value).toJSONString()) instanceof String) {
                return o;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (value instanceof Number) {
            return JSONObject.numberToString((Number)value);
        }
        if (value instanceof Boolean) {
            return value.toString();
        }
        if (value instanceof JSONValue) {
            return ((JSONValue)value).toString(indentFactor, indent);
        }
        return JSONObject.quote(value.toString());
    }

    @Override
    public Writer write(Writer writer) throws JSONException {
        return this.write(writer, false);
    }

    @Override
    public Writer write(Writer writer, boolean asciiOnly) throws JSONException {
        JsonGenerator jGenerator = null;
        try {
            jGenerator = JSONObject.createGenerator(writer, asciiOnly);
            jGenerator.setPrettyPrinter(STANDARD_MINIMAL_PRETTY_PRINTER);
            JSONObject.write(this, jGenerator);
            Writer writer2 = writer;
            return writer2;
        }
        catch (IOException e) {
            throw new JSONException(e);
        }
        finally {
            JSONObject.close(jGenerator);
        }
    }

    @Override
    protected void writeTo(JsonGenerator jGenerator) throws IOException, JSONException {
        JSONObject.write(this, jGenerator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void write(JSONObject jo, JsonGenerator jGenerator) throws IOException, JSONException {
        jGenerator.writeStartObject();
        try {
            Map<String, Object> myHashMap = jo.myHashMap;
            int len = myHashMap.size();
            if (len > 0) {
                Iterator<Map.Entry<String, Object>> iter = myHashMap.entrySet().iterator();
                for (int i = 0; i < len; ++i) {
                    Map.Entry<String, Object> entry = iter.next();
                    jGenerator.writeFieldName(entry.getKey());
                    JSONObject.write(entry.getValue(), jGenerator);
                }
            }
        }
        finally {
            JSONObject.writeEndAndFlush(jGenerator, true);
        }
    }

    public static JSONValue parse(Reader reader) throws JSONException {
        JsonParser jParser = null;
        try {
            jParser = JSONObject.createParser(reader);
            JsonToken token = jParser.nextToken();
            if (token == JsonToken.START_OBJECT) {
                JSONObject jSONObject = JSONObject.parse(jParser, null);
                return jSONObject;
            }
            if (token == JsonToken.START_ARRAY) {
                JSONArray jSONArray = JSONArray.parse(jParser, null);
                return jSONArray;
            }
            try {
                throw new JSONException("Neither a JSONObject nor a JSONArray");
            }
            catch (IOException e) {
                throw new JSONException(e);
            }
        }
        finally {
            JSONObject.close(jParser);
        }
    }

    protected static JSONObject parse(Reader reader, JSONObject optObject) throws JSONException {
        JsonParser jParser = null;
        try {
            jParser = JSONObject.createParser(reader);
            Object token = jParser.nextToken();
            if (token != JsonToken.START_OBJECT) {
                String content = JSONObject.readFrom(reader, 8192L);
                String sep = System.getProperty("line.separator");
                throw new JSONException("A JSONObject text must begin with '{', but got \"" + (null == token ? "null" : ((Enum)token).toString()) + "\" parse event." + sep + "Rest:" + sep + content);
            }
            token = JSONObject.parse(jParser, optObject);
            return token;
        }
        catch (IOException e) {
            throw new JSONException(e);
        }
        finally {
            JSONObject.close(jParser);
        }
    }

    protected static JSONObject parse(JsonParser jParser, JSONObject optObject) throws JSONException {
        try {
            JSONObject jo = null == optObject ? new JSONObject() : optObject;
            JsonToken current = jParser.nextToken();
            while (current != JsonToken.END_OBJECT) {
                if (current != JsonToken.FIELD_NAME) {
                    throw new JSONException("JSON parse error: field name expected, but got " + (null == current ? "null" : current.toString()));
                }
                String fieldName = jParser.getCurrentName();
                current = jParser.nextToken();
                switch (current) {
                    case START_OBJECT: {
                        jo.put(fieldName, JSONObject.parse(jParser, null));
                        break;
                    }
                    case START_ARRAY: {
                        jo.put(fieldName, JSONArray.parse(jParser, null));
                        break;
                    }
                    case VALUE_FALSE: {
                        jo.put(fieldName, false);
                        break;
                    }
                    case VALUE_NULL: {
                        jo.put(fieldName, NULL);
                        break;
                    }
                    case VALUE_NUMBER_FLOAT: {
                        try {
                            jo.put(fieldName, jParser.getFloatValue());
                        }
                        catch (JsonParseException e) {
                            jo.put(fieldName, jParser.getDoubleValue());
                        }
                        break;
                    }
                    case VALUE_NUMBER_INT: {
                        try {
                            jo.put(fieldName, jParser.getIntValue());
                        }
                        catch (JsonParseException e) {
                            jo.put(fieldName, jParser.getLongValue());
                        }
                        break;
                    }
                    case VALUE_TRUE: {
                        jo.put(fieldName, true);
                        break;
                    }
                    case VALUE_STRING: {
                        jo.put(fieldName, jParser.getText());
                        break;
                    }
                }
                current = jParser.nextToken();
            }
            return jo;
        }
        catch (IOException e) {
            throw new JSONException(e);
        }
    }

    @Override
    public boolean isArray() {
        return false;
    }

    @Override
    public boolean isObject() {
        return true;
    }

    @Override
    public JSONArray toArray() {
        return null;
    }

    @Override
    public JSONObject toObject() {
        return this;
    }

    private static String prepareJSONString(String sJson) {
        if (null == sJson) {
            return null;
        }
        return PATTERN_CRLF.matcher(sJson).replaceAll("");
    }

    private static final class Null
    implements Cloneable {
        protected Object clone() {
            return this;
        }

        public boolean equals(Object object) {
            return object == null || object == this;
        }

        public String toString() {
            return "null".intern();
        }
    }
}

