/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.webdav.xml.appointment;

import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.Participant;
import com.openexchange.groupware.container.ResourceParticipant;
import com.openexchange.groupware.container.UserParticipant;
import com.openexchange.resource.Resource;
import com.openexchange.webdav.xml.AppointmentTest;
import com.openexchange.webdav.xml.GroupUserTest;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Bug8123Test
extends AppointmentTest {
    private static final Log LOG = LogFactory.getLog(Bug8123Test.class);

    public Bug8123Test(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    public void testBug8123() throws Exception {
        Resource[] resource = GroupUserTest.searchResource(this.getWebConversation(), "*", new Date(0L), this.getHostName(), this.getLogin(), this.getPassword(), this.context);
        if (resource.length == 0) {
            Bug8123Test.fail((String)"no resource found for this test");
        }
        Appointment appointmentObj = new Appointment();
        appointmentObj.setTitle("testBug8123");
        appointmentObj.setStartDate(this.startTime);
        appointmentObj.setEndDate(this.endTime);
        appointmentObj.setShownAs(4);
        appointmentObj.setParentFolderID(this.appointmentFolderId);
        appointmentObj.setIgnoreConflicts(true);
        Participant[] participant = new Participant[2];
        participant[0] = new UserParticipant();
        participant[0].setIdentifier(this.userId);
        participant[1] = new ResourceParticipant();
        participant[1].setIdentifier(resource[0].getIdentifier());
        appointmentObj.setParticipants(participant);
        int objectId = Bug8123Test.insertAppointment(this.getWebConversation(), appointmentObj, "http://" + this.getHostName(), this.getLogin(), this.getPassword(), this.context);
        appointmentObj.setObjectID(objectId);
        Appointment loadAppointment = Bug8123Test.loadAppointment(this.getWebConversation(), objectId, this.appointmentFolderId, "http://" + this.getHostName(), this.getLogin(), this.getPassword(), this.context);
        Bug8123Test.compareObject(appointmentObj, loadAppointment);
        Date modified = new Date(loadAppointment.getCreationDate().getTime() - 1000L);
        loadAppointment = Bug8123Test.loadAppointment(this.getWebConversation(), objectId, this.appointmentFolderId, modified, this.getHostName(), this.getLogin(), this.getPassword(), this.context);
        Bug8123Test.compareObject(appointmentObj, loadAppointment);
        Bug8123Test.deleteAppointment(this.getWebConversation(), objectId, this.appointmentFolderId, "http://" + this.getHostName(), this.getLogin(), this.getPassword(), this.context);
    }
}

