/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.calendar.calendarsqltests;

import com.openexchange.groupware.calendar.CalendarDataObject;
import com.openexchange.groupware.calendar.calendarsqltests.CalendarSqlTest;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class FullTimeSeries
extends CalendarSqlTest {
    public void testFullTimeSeries() throws Throwable {
        CalendarDataObject appointment = this.appointments.buildAppointmentWithUserParticipants(this.user);
        appointment.setTitle("Test Full Time Series");
        long now = System.currentTimeMillis();
        appointment.setStartDate(new Date(now));
        appointment.setEndDate(new Date(now + 3600000L));
        appointment.setFullTime(true);
        appointment.setRecurrenceType(1);
        appointment.setInterval(1);
        appointment.setOccurrence(2);
        this.appointments.save(appointment);
        int objectId = appointment.getObjectID();
        this.clean.add(appointment);
        GregorianCalendar cal = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        cal.setTimeInMillis(now);
        CalendarDataObject loaded = this.appointments.load(objectId, this.folders.getStandardFolder(this.userId, this.ctx));
        GregorianCalendar loadedUntil = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        loadedUntil.setTime(loaded.getUntil());
        ((Calendar)cal).add(5, 1);
        FullTimeSeries.assertEquals((String)"Wrong day in until", (int)cal.get(5), (int)loadedUntil.get(5));
        FullTimeSeries.assertEquals((String)"Wrong hour in until", (int)0, (int)loadedUntil.get(11));
    }
}

