/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.calendar.calendarsqltests;

import com.openexchange.groupware.calendar.CalendarDataObject;
import com.openexchange.groupware.calendar.calendarsqltests.CalendarSqlTest;

public class Bug12923Test
extends CalendarSqlTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMoveFromPrivateToSharedFolder() throws Throwable {
        try {
            this.folders.sharePrivateFolder(this.session, this.ctx, this.secondUserId);
            int sharedFolderId = this.folders.getStandardFolder(this.userId, this.ctx);
            this.appointments.switchUser(this.secondUser);
            CalendarDataObject appointment = this.appointments.buildAppointmentWithUserParticipants(this.secondUser);
            appointment.setTitle("Bug 12923 Test");
            this.appointments.save(appointment);
            int objectId = appointment.getObjectID();
            this.clean.add(appointment);
            CalendarDataObject updateAppointment = this.appointments.createIdentifyingCopy(appointment);
            updateAppointment.setParentFolderID(sharedFolderId);
            this.appointments.move(updateAppointment, appointment.getParentFolderID());
            try {
                this.appointments.load(objectId, this.folders.getStandardFolder(this.secondUserId, this.ctx));
                Bug12923Test.fail((String)"Object should not be in this folder.");
            }
            catch (Exception e) {
                // empty catch block
            }
            CalendarDataObject appointmentInTargetFolder = this.appointments.load(objectId, sharedFolderId);
            Bug12923Test.assertNotNull((String)"Appointment should not be null", (Object)appointmentInTargetFolder);
            Bug12923Test.assertEquals((String)"Unexpected number of users.", (int)1, (int)appointmentInTargetFolder.getUsers().length);
            Bug12923Test.assertEquals((String)"Unexpected number of participants.", (int)1, (int)appointmentInTargetFolder.getParticipants().length);
            Bug12923Test.assertEquals((String)"Wrong User.", (int)this.userId, (int)appointmentInTargetFolder.getUsers()[0].getIdentifier());
            Bug12923Test.assertEquals((String)"Wrong Participant.", (int)this.userId, (int)appointmentInTargetFolder.getParticipants()[0].getIdentifier());
        }
        catch (NumberFormatException e) {
            Bug12923Test.fail((String)e.getMessage());
        }
        finally {
            this.folders.unsharePrivateFolder(this.session, this.ctx);
        }
    }
}

