/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.calendar.calendarsqltests;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.calendar.CalendarDataObject;
import com.openexchange.groupware.calendar.calendarsqltests.CalendarSqlTest;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.container.UserParticipant;
import java.sql.SQLException;
import java.util.Date;

public class Bug11316Test
extends CalendarSqlTest {
    public void testUpdatePublicAppointmentTimeShouldUpdateParticipantStatus() throws OXException, SQLException {
        FolderObject folder = this.folders.createPublicFolderFor(this.session, this.ctx, "A nice public folder", 2, this.userId, this.secondUserId);
        this.cleanFolders.add(folder);
        CalendarDataObject appointment = this.appointments.buildAppointmentWithUserParticipants(this.user, this.secondUser);
        appointment.setParentFolderID(folder.getObjectID());
        this.appointments.save(appointment);
        this.clean.add(appointment);
        this.appointments.switchUser(this.secondUser);
        appointment = this.appointments.reload(appointment);
        boolean found = false;
        for (UserParticipant participant : appointment.getUsers()) {
            if (participant.getIdentifier() != this.secondUserId) continue;
            found = true;
            participant.setConfirm(1);
        }
        Bug11316Test.assertTrue((boolean)found);
        this.appointments.save(appointment);
        this.appointments.switchUser(this.user);
        appointment = this.appointments.reload(appointment);
        found = false;
        for (UserParticipant participant : appointment.getUsers()) {
            if (participant.getIdentifier() != this.secondUserId) continue;
            found = true;
            Bug11316Test.assertEquals((int)participant.getConfirm(), (int)1);
        }
        Bug11316Test.assertTrue((String)"SecondUser disappeared from users!", (boolean)found);
        CalendarDataObject cdao = new CalendarDataObject();
        cdao.setStartDate(appointment.getStartDate());
        cdao.setEndDate(new Date(appointment.getEndDate().getTime() + 36000000L));
        cdao.setObjectID(appointment.getObjectID());
        cdao.setParentFolderID(appointment.getParentFolderID());
        cdao.setContext(appointment.getContext());
        this.appointments.save(cdao);
        appointment = this.appointments.reload(appointment);
        found = false;
        for (UserParticipant participant : appointment.getUsers()) {
            if (participant.getIdentifier() != this.secondUserId) continue;
            found = true;
            Bug11316Test.assertEquals((int)participant.getConfirm(), (int)0);
        }
        Bug11316Test.assertTrue((String)"SecondUser disappeared from users!", (boolean)found);
        Bug11316Test.assertEquals((int)appointment.getParticipants().length, (int)appointment.getUsers().length);
    }
}

