/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.dav.carddav.tests;

import com.openexchange.dav.SyncToken;
import com.openexchange.dav.carddav.CardDAVTest;
import com.openexchange.dav.carddav.VCardResource;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.container.FolderObject;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class NewTest
extends CardDAVTest {
    public NewTest(String name) {
        super(name);
    }

    public void testCreateSimpleOnClient() throws Exception {
        String syncToken = super.fetchSyncToken();
        String uid = NewTest.randomUID();
        String firstName = "test";
        String lastName = "horst";
        String vCard = "BEGIN:VCARD\r\nVERSION:3.0\r\nN:horst;test;;;\r\nFN:test horst\r\nORG:test3;\r\nEMAIL;type=INTERNET;type=WORK;type=pref:test@example.com\r\nTEL;type=WORK;type=pref:24235423\r\nTEL;type=CELL:352-3534\r\nTEL;type=HOME:346346\r\nUID:" + uid + "\r\n" + "REV:" + CardDAVTest.formatAsUTC(new Date()) + "\r\n" + "PRODID:-//Apple Inc.//AddressBook 6.0//EN" + "\r\n" + "END:VCARD" + "\r\n";
        NewTest.assertEquals((String)"response code wrong", (int)201, (int)super.putVCard(uid, vCard));
        Contact contact = super.getContact(uid);
        super.rememberForCleanUp(contact);
        NewTest.assertEquals((String)"uid wrong", (String)uid, (String)contact.getUid());
        NewTest.assertEquals((String)"firstname wrong", (String)"test", (String)contact.getGivenName());
        NewTest.assertEquals((String)"lastname wrong", (String)"horst", (String)contact.getSurName());
        Map<String, String> eTags = super.syncCollection(syncToken);
        NewTest.assertTrue((String)"no resource changes reported on sync collection", (0 < eTags.size() ? 1 : 0) != 0);
        List<VCardResource> addressData = super.addressbookMultiget(eTags.keySet());
        VCardResource card = NewTest.assertContains(uid, addressData);
        NewTest.assertEquals((String)"N wrong", (String)"test", (String)card.getGivenName());
        NewTest.assertEquals((String)"N wrong", (String)"horst", (String)card.getFamilyName());
        NewTest.assertEquals((String)"FN wrong", (String)"test horst", (String)card.getFN());
    }

    public void testCreateSimpleOnServer() throws Exception {
        String syncToken = super.fetchSyncToken();
        String uid = NewTest.randomUID();
        String firstName = "test";
        String lastName = "otto";
        Contact contact = new Contact();
        contact.setSurName("otto");
        contact.setGivenName("test");
        contact.setDisplayName("test otto");
        contact.setUid(uid);
        super.rememberForCleanUp(super.create(contact));
        Map<String, String> eTags = super.syncCollection(syncToken);
        NewTest.assertTrue((String)"no resource changes reported on sync collection", (0 < eTags.size() ? 1 : 0) != 0);
        List<VCardResource> addressData = super.addressbookMultiget(eTags.keySet());
        VCardResource card = NewTest.assertContains(uid, addressData);
        NewTest.assertEquals((String)"N wrong", (String)"test", (String)card.getGivenName());
        NewTest.assertEquals((String)"N wrong", (String)"otto", (String)card.getFamilyName());
        NewTest.assertEquals((String)"FN wrong", (String)"test otto", (String)card.getFN());
        contact = super.getContact(uid);
        super.rememberForCleanUp(contact);
        NewTest.assertEquals((String)"uid wrong", (String)uid, (String)contact.getUid());
        NewTest.assertEquals((String)"firstname wrong", (String)"test", (String)contact.getGivenName());
        NewTest.assertEquals((String)"lastname wrong", (String)"otto", (String)contact.getSurName());
    }

    public void testAddContactInSubfolderServer() throws Exception {
        SyncToken syncToken = new SyncToken(super.fetchSyncToken());
        String folderName = "testfolder_" + NewTest.randomUID();
        FolderObject folder = super.createFolder(folderName);
        super.rememberForCleanUp(folder);
        FolderObject createdFolder = super.getFolder(folderName);
        NewTest.assertNotNull((String)"folder not found on server", (Object)createdFolder);
        NewTest.assertEquals((String)"foldername wrong", (String)folderName, (String)createdFolder.getFolderName());
        String uid = NewTest.randomUID();
        String firstName = "test";
        String lastName = "herbert";
        Contact contact = new Contact();
        contact.setSurName(lastName);
        contact.setGivenName(firstName);
        contact.setDisplayName(firstName + " " + lastName);
        contact.setUid(uid);
        super.rememberForCleanUp(super.create(contact, createdFolder.getObjectID()));
        Map<String, String> eTags = super.syncCollection(syncToken).getETagsStatusOK();
        NewTest.assertTrue((String)"no resource changes reported on sync collection", (0 < eTags.size() ? 1 : 0) != 0);
        List<VCardResource> addressData = super.addressbookMultiget(eTags.keySet());
        VCardResource card = NewTest.assertContains(uid, addressData);
        NewTest.assertEquals((String)"N wrong", (String)firstName, (String)card.getGivenName());
        NewTest.assertEquals((String)"N wrong", (String)lastName, (String)card.getFamilyName());
        NewTest.assertEquals((String)"FN wrong", (String)(firstName + " " + lastName), (String)card.getFN());
    }
}

