/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.dav.carddav.bugs;

import com.openexchange.dav.carddav.CardDAVTest;
import com.openexchange.dav.carddav.VCardResource;
import com.openexchange.groupware.container.Contact;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class Bug21374Test
extends CardDAVTest {
    public Bug21374Test(String name) {
        super(name);
    }

    public void testCreateWithProfession() throws Exception {
        String syncToken = super.fetchSyncToken();
        String uid = Bug21374Test.randomUID();
        String firstName = "test";
        String lastName = "jupp";
        String profession = "profession?";
        String vCard = "BEGIN:VCARD\r\nVERSION:3.0\r\nN:jupp;test;;;\r\nFN:test jupp\r\nTITLE:profession?\r\nUID:" + uid + "\r\n" + "REV:" + CardDAVTest.formatAsUTC(new Date()) + "\r\n" + "PRODID:-//Apple Inc.//AddressBook 6.1//EN" + "\r\n" + "END:VCARD" + "\r\n";
        Bug21374Test.assertEquals((String)"response code wrong", (int)201, (int)super.putVCard(uid, vCard));
        Contact contact = super.getContact(uid);
        super.rememberForCleanUp(contact);
        Bug21374Test.assertEquals((String)"uid wrong", (String)uid, (String)contact.getUid());
        Bug21374Test.assertEquals((String)"profession wrong", (String)"profession?", (String)contact.getProfession());
        Map<String, String> eTags = super.syncCollection(syncToken);
        Bug21374Test.assertTrue((String)"no resource changes reported on sync collection", (0 < eTags.size() ? 1 : 0) != 0);
        List<VCardResource> addressData = super.addressbookMultiget(eTags.keySet());
        VCardResource card = Bug21374Test.assertContains(uid, addressData);
        Bug21374Test.assertEquals((String)"N wrong", (String)"test", (String)card.getGivenName());
        Bug21374Test.assertEquals((String)"N wrong", (String)"jupp", (String)card.getFamilyName());
        Bug21374Test.assertEquals((String)"FN wrong", (String)"test jupp", (String)card.getFN());
        Bug21374Test.assertEquals((String)"TITLE wrong", (String)"profession?", (String)card.getVCard().getTitle().getTitle());
    }
}

