/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.dav.caldav.bugs;

import com.openexchange.dav.SyncToken;
import com.openexchange.dav.caldav.CalDAVTest;
import com.openexchange.dav.caldav.ICalResource;
import com.openexchange.dav.caldav.ical.SimpleICal;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;

public class Bug23167Test
extends CalDAVTest {
    public Bug23167Test(String name) {
        super(name);
    }

    public void testUpdateOldChangeException() throws Exception {
        SyncToken syncToken = new SyncToken(super.fetchSyncToken());
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(TimeTools.D("One year ago in the morning", TimeZone.getTimeZone("Europe/Berlin")));
        Appointment appointment = new Appointment();
        appointment.setUid(Bug23167Test.randomUID());
        appointment.setTitle("Bug23167Test");
        appointment.setIgnoreConflicts(true);
        appointment.setRecurrenceType(2);
        appointment.setDays(1 << calendar.get(7) - 1);
        appointment.setInterval(1);
        appointment.setStartDate(calendar.getTime());
        calendar.add(11, 2);
        appointment.setEndDate(calendar.getTime());
        super.create(appointment);
        Date clientLastModified = this.getManager().getLastModification();
        Appointment exception = new Appointment();
        exception.setTitle("Bug23167Test_edit");
        exception.setObjectID(appointment.getObjectID());
        exception.setRecurrencePosition(2);
        exception.setLastModified(clientLastModified);
        exception.setParentFolderID(appointment.getParentFolderID());
        super.getManager().update(exception);
        clientLastModified = this.getManager().getLastModification();
        Map<String, String> eTags = super.syncCollection(syncToken).getETagsStatusOK();
        Bug23167Test.assertTrue((String)"no resource changes reported on sync collection", (0 < eTags.size() ? 1 : 0) != 0);
        List<ICalResource> calendarData = super.calendarMultiget(eTags.keySet());
        ICalResource iCalResource = Bug23167Test.assertContains(appointment.getUid(), calendarData);
        Bug23167Test.assertNotNull((String)"No VEVENT in iCal found", (Object)iCalResource.getVEvent());
        Bug23167Test.assertEquals((String)"No exception found in iCal", (int)2, (int)iCalResource.getVEvents().size());
        SimpleICal.Component vEventException = null;
        for (SimpleICal.Component vEvent : iCalResource.getVEvents()) {
            Date recurrenceID = vEvent.getRecurrenceID();
            if (null != recurrenceID) {
                Bug23167Test.assertEquals((String)"SUMMARY wrong", (String)exception.getTitle(), (String)vEvent.getSummary());
                vEventException = vEvent;
                continue;
            }
            Bug23167Test.assertEquals((String)"SUMMARY wrong", (String)appointment.getTitle(), (String)vEvent.getSummary());
        }
        vEventException.setProperty("SUMMARY", vEventException.getPropertyValue("SUMMARY") + "_edit2");
        vEventException.setProperty("DTSTAMP", Bug23167Test.formatAsUTC(new Date()));
        Bug23167Test.assertEquals((String)"response code wrong", (int)201, (int)super.putICalUpdate(iCalResource));
        List<Appointment> updates = super.getManager().updates(Bug23167Test.parse(this.getDefaultFolderID()), clientLastModified, false);
        Bug23167Test.assertNotNull((String)"no updates found on server", updates);
        Bug23167Test.assertTrue((String)"no updated appointments on server", (0 < updates.size() ? 1 : 0) != 0);
        exception = null;
        for (Appointment update : updates) {
            if (appointment.getObjectID() == update.getObjectID() || !appointment.getUid().equals(update.getUid())) continue;
            exception = update;
            break;
        }
        Bug23167Test.assertNotNull((String)"Exception not found", (Object)exception);
        Bug23167Test.assertEquals((String)"Title wrong", (String)vEventException.getSummary(), (String)exception.getTitle());
    }
}

