/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.task.actions;

import com.openexchange.ajax.container.Response;
import com.openexchange.ajax.framework.AbstractColumnsParser;
import com.openexchange.ajax.task.actions.TaskUpdatesResponse;
import com.openexchange.groupware.container.ExternalUserParticipant;
import com.openexchange.groupware.container.GroupParticipant;
import com.openexchange.groupware.container.Participant;
import com.openexchange.groupware.container.UserParticipant;
import com.openexchange.groupware.tasks.Task;
import com.openexchange.java.Autoboxing;
import java.util.ArrayList;
import java.util.Date;
import java.util.TimeZone;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class TaskUpdatesParser
extends AbstractColumnsParser<TaskUpdatesResponse> {
    private final int[] columns;
    private final TimeZone timeZone;

    protected TaskUpdatesParser(boolean failOnError, int[] columns, TimeZone timeZone) {
        super(failOnError, columns);
        this.columns = columns;
        this.timeZone = timeZone;
    }

    @Override
    protected TaskUpdatesResponse createResponse(Response response) throws JSONException {
        TaskUpdatesResponse taskUpdatesResponse = (TaskUpdatesResponse)super.createResponse(response);
        JSONArray rows = (JSONArray)response.getData();
        if (rows == null) {
            return taskUpdatesResponse;
        }
        ArrayList<Task> tasks = new ArrayList<Task>();
        int size = rows.length();
        for (int i = 0; i < size; ++i) {
            Object arrayOrId = rows.get(i);
            if (!JSONArray.class.isInstance(arrayOrId)) continue;
            JSONArray row = (JSONArray)arrayOrId;
            Task task = new Task();
            for (int colIndex = 0; colIndex < this.columns.length; ++colIndex) {
                int column;
                Object value = row.get(colIndex);
                if (value == JSONObject.NULL || (column = this.columns[colIndex]) == 6) continue;
                value = this.transform(value, column);
                task.set(column, value);
            }
            tasks.add(task);
        }
        taskUpdatesResponse.setTasks(tasks);
        return taskUpdatesResponse;
    }

    @Override
    protected TaskUpdatesResponse instantiateResponse(Response response) {
        return new TaskUpdatesResponse(response);
    }

    private Object transform(Object actual, int column) throws JSONException {
        switch (column) {
            case 4: 
            case 5: 
            case 201: 
            case 202: {
                return new Date(Autoboxing.l((Long)((Long)actual)));
            }
            case 220: {
                return this.buildParticipantArray((JSONArray)actual);
            }
        }
        return actual;
    }

    private Object buildParticipantArray(JSONArray actual) throws JSONException {
        ArrayList<Object> participants = new ArrayList<Object>();
        int size = actual.length();
        block5: for (int i = 0; i < size; ++i) {
            JSONObject jsonParticipant = actual.getJSONObject(i);
            int type = jsonParticipant.getInt("type");
            switch (type) {
                case 1: {
                    UserParticipant userParticipant = new UserParticipant(jsonParticipant.getInt("id"));
                    userParticipant.setConfirm(jsonParticipant.getInt("confirmation"));
                    participants.add(userParticipant);
                    continue block5;
                }
                case 2: {
                    GroupParticipant groupParticipant = new GroupParticipant(jsonParticipant.getInt("id"));
                    participants.add(groupParticipant);
                    continue block5;
                }
                case 5: {
                    ExternalUserParticipant externalUserParticipant = new ExternalUserParticipant(jsonParticipant.optString("mail"));
                    participants.add(externalUserParticipant);
                }
            }
        }
        return participants.toArray(new Participant[participants.size()]);
    }
}

