/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.task;

import com.meterware.httpunit.GetMethodWebRequest;
import com.meterware.httpunit.PutMethodWebRequest;
import com.meterware.httpunit.WebConversation;
import com.meterware.httpunit.WebRequest;
import com.meterware.httpunit.WebResponse;
import com.openexchange.ajax.container.Response;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AJAXSession;
import com.openexchange.ajax.framework.CommonAllResponse;
import com.openexchange.ajax.framework.CommonDeleteResponse;
import com.openexchange.ajax.framework.Executor;
import com.openexchange.ajax.framework.MultipleRequest;
import com.openexchange.ajax.framework.MultipleResponse;
import com.openexchange.ajax.task.actions.AllRequest;
import com.openexchange.ajax.task.actions.DeleteRequest;
import com.openexchange.ajax.task.actions.GetRequest;
import com.openexchange.ajax.task.actions.GetResponse;
import com.openexchange.ajax.task.actions.InsertRequest;
import com.openexchange.ajax.task.actions.InsertResponse;
import com.openexchange.ajax.task.actions.SearchRequest;
import com.openexchange.ajax.task.actions.SearchResponse;
import com.openexchange.ajax.task.actions.UpdateRequest;
import com.openexchange.ajax.task.actions.UpdateResponse;
import com.openexchange.ajax.writer.TaskWriter;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.tasks.Task;
import com.openexchange.tools.URLParameter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.TimeZone;
import junit.framework.Assert;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONException;
import org.json.JSONObject;
import org.xml.sax.SAXException;

public final class TaskTools
extends Assert {
    private static final Log LOG = LogFactory.getLog(TaskTools.class);
    private static final String ENCODING = "UTF-8";
    private static final String TASKS_URL = "/ajax/tasks";

    private TaskTools() {
    }

    @Deprecated
    public static int getPrivateTaskFolder(WebConversation conversation, String hostName, String sessionId) throws IOException, JSONException, OXException {
        AJAXClient client = new AJAXClient(new AJAXSession(conversation, hostName, sessionId), false);
        return client.getValues().getPrivateTaskFolder();
    }

    @Deprecated
    public static Response insertTask(WebConversation conversation, String hostName, String sessionId, Task task) throws JSONException, IOException, OXException {
        LOG.trace((Object)"Inserting task.");
        AJAXClient client = new AJAXClient(new AJAXSession(conversation, hostName, sessionId), false);
        InsertResponse insertR = client.execute(new InsertRequest(task, client.getValues().getTimeZone()));
        return insertR.getResponse();
    }

    @Deprecated
    public static Response updateTask(WebConversation conversation, String hostName, String sessionId, int folderId, int taskId, JSONObject json, Date lastModified) throws JSONException, IOException, SAXException {
        LOG.trace((Object)"Updating task.");
        String object = json.toString();
        LOG.trace((Object)object);
        ByteArrayInputStream bais = new ByteArrayInputStream(object.getBytes(ENCODING));
        URLParameter parameter = new URLParameter();
        parameter.setParameter("action", "update");
        parameter.setParameter("session", sessionId);
        parameter.setParameter("folder", String.valueOf(folderId));
        parameter.setParameter("id", String.valueOf(taskId));
        parameter.setParameter("timestamp", String.valueOf(lastModified.getTime()));
        PutMethodWebRequest req = new PutMethodWebRequest("http://" + hostName + TASKS_URL + parameter.getURLParameters(), (InputStream)bais, "text/javascript; charset=UTF-8");
        WebResponse resp = conversation.getResponse((WebRequest)req);
        TaskTools.assertEquals((String)"Response code is not okay.", (int)200, (int)resp.getResponseCode());
        String body = resp.getText();
        LOG.trace((Object)("Response body: " + body));
        return Response.parse((String)body);
    }

    @Deprecated
    public static Response updateTask(WebConversation conversation, String hostName, String sessionId, int folderId, Task task, Date lastModified) throws JSONException, IOException, SAXException, OXException {
        TimeZone timeZone = new AJAXClient(new AJAXSession(conversation, hostName, sessionId), false).getValues().getTimeZone();
        JSONObject jsonObj = new JSONObject();
        new TaskWriter(timeZone).writeTask(task, jsonObj);
        return TaskTools.updateTask(conversation, hostName, sessionId, folderId, task.getObjectID(), jsonObj, lastModified);
    }

    public static UpdateResponse update(AJAXClient client, UpdateRequest request) throws OXException, IOException, JSONException {
        return Executor.execute(client, request);
    }

    @Deprecated
    public static Response getTask(WebConversation conversation, String hostName, String sessionId, int folderId, int taskId) throws IOException, JSONException, OXException, OXException {
        LOG.trace((Object)"Getting task.");
        AJAXClient client = new AJAXClient(new AJAXSession(conversation, hostName, sessionId), false);
        GetResponse getR = TaskTools.get(client, new GetRequest(folderId, taskId));
        Response response = getR.getResponse();
        response.setData((Object)getR.getTask(client.getValues().getTimeZone()));
        return response;
    }

    @Deprecated
    public static GetResponse get(AJAXClient client, GetRequest request) throws OXException, IOException, JSONException {
        return client.execute(request);
    }

    @Deprecated
    public static void deleteTask(WebConversation conversation, String hostName, String sessionId, Date lastUpdate, int folder, int task) throws IOException, JSONException {
        LOG.trace((Object)"Deleting tasks.");
        AJAXSession session = new AJAXSession(conversation, hostName, sessionId);
        AJAXClient client = new AJAXClient(session, false);
        DeleteRequest request = new DeleteRequest(folder, task, lastUpdate);
        try {
            client.execute(request);
        }
        catch (OXException e) {
            throw new JSONException((Throwable)e);
        }
    }

    public static CommonDeleteResponse delete(WebConversation conversation, String hostName, String sessionId, String protocol, DeleteRequest request) throws OXException, IOException, JSONException {
        return Executor.execute(new AJAXSession(conversation, hostName, sessionId), request, protocol, hostName);
    }

    @Deprecated
    public static Response getAllTasksInFolder(WebConversation conversation, String hostName, String sessionId, int folderId, int[] columns, int sort, String order) throws IOException, SAXException, JSONException {
        LOG.trace((Object)"Getting all task in a folder.");
        GetMethodWebRequest req = new GetMethodWebRequest("http://" + hostName + TASKS_URL);
        req.setParameter("action", "all");
        req.setParameter("session", sessionId);
        req.setParameter("folder", String.valueOf(folderId));
        StringBuilder columnSB = new StringBuilder();
        for (int i : columns) {
            columnSB.append(i);
            columnSB.append(',');
        }
        columnSB.delete(columnSB.length() - 1, columnSB.length());
        req.setParameter("columns", columnSB.toString());
        if (null != order) {
            req.setParameter("sort", String.valueOf(sort));
            req.setParameter("order", order);
        }
        WebResponse resp = conversation.getResponse((WebRequest)req);
        TaskTools.assertEquals((String)"Response code is not okay.", (int)200, (int)resp.getResponseCode());
        String body = resp.getText();
        LOG.trace((Object)("Response body: " + body));
        Response response = Response.parse((String)body);
        TaskTools.assertFalse((String)response.getErrorMessage(), (boolean)response.hasError());
        return response;
    }

    public static CommonAllResponse all(AJAXClient client, AllRequest request) throws OXException, IOException, JSONException {
        return client.execute(request);
    }

    public static CommonAllResponse all(WebConversation conversation, String hostName, String sessionId, String protocol, AllRequest request) throws OXException, IOException, JSONException {
        return Executor.execute(new AJAXSession(conversation, hostName, sessionId), request, protocol, hostName);
    }

    public static void confirmTask(WebConversation conversation, String hostName, String sessionId, int folderId, int taskId, int confirm, String confirmMessage) throws IOException, SAXException, JSONException {
        JSONObject json = new JSONObject();
        json.put("confirmation", confirm);
        json.put("folder_id", folderId);
        json.put("id", taskId);
        json.put("confirmmessage", (Object)confirmMessage);
        ByteArrayInputStream bais = new ByteArrayInputStream(json.toString().getBytes(ENCODING));
        URLParameter parameter = new URLParameter();
        parameter.setParameter("session", sessionId);
        parameter.setParameter("action", "confirm");
        PutMethodWebRequest req = new PutMethodWebRequest("http://" + hostName + TASKS_URL + parameter.getURLParameters(), (InputStream)bais, "text/javascript; charset=UTF-8");
        WebResponse resp = conversation.getResponse((WebRequest)req);
        TaskTools.assertEquals((String)"Response code is not okay.", (int)200, (int)resp.getResponseCode());
        String body = resp.getText();
        LOG.trace((Object)("Response body: " + body));
        Response response = Response.parse((String)body);
        TaskTools.assertFalse((String)response.getErrorMessage(), (boolean)response.hasError());
    }

    public static SearchResponse search(AJAXClient client, SearchRequest request) throws OXException, IOException, JSONException {
        return Executor.execute(client, request);
    }

    public static int extractInsertId(Response response) throws JSONException {
        int taskId;
        TaskTools.assertFalse((String)response.getErrorMessage(), (boolean)response.hasError());
        JSONObject data = (JSONObject)response.getData();
        if (!data.has("id")) {
            TaskTools.fail((String)response.getErrorMessage());
        }
        TaskTools.assertTrue((String)"Problem while inserting task", ((taskId = data.getInt("id")) > 0 ? 1 : 0) != 0);
        return taskId;
    }

    public static void compareAttributes(Task task, Task reload) {
        TaskTools.assertEquals((String)"Title differs", (boolean)task.containsTitle(), (boolean)reload.containsTitle());
        TaskTools.assertEquals((String)"Title differs", (String)task.getTitle(), (String)reload.getTitle());
        TaskTools.assertEquals((String)"Private Flag differs", (boolean)task.containsPrivateFlag(), (boolean)reload.containsPrivateFlag());
        TaskTools.assertEquals((String)"Private Flag differs", (boolean)task.getPrivateFlag(), (boolean)reload.getPrivateFlag());
        TaskTools.assertEquals((String)"Start date differs", (boolean)task.containsStartDate(), (boolean)reload.containsStartDate());
        TaskTools.assertEquals((String)"Start date differs", (Object)task.getStartDate(), (Object)reload.getStartDate());
        TaskTools.assertEquals((String)"End date differs", (boolean)task.containsEndDate(), (boolean)reload.containsEndDate());
        TaskTools.assertEquals((String)"End date differs", (Object)task.getEndDate(), (Object)reload.getEndDate());
        TaskTools.assertEquals((String)"Status differs", (boolean)task.containsStatus(), (boolean)reload.containsStatus());
        TaskTools.assertEquals((String)"Status differs", (int)task.getStatus(), (int)reload.getStatus());
        TaskTools.assertEquals((String)"Priority differs", (boolean)task.containsPriority(), (boolean)reload.containsPriority());
        TaskTools.assertEquals((String)"Priority differs", (int)task.getPriority(), (int)reload.getPriority());
        TaskTools.assertEquals((String)"PercentComplete differs", (boolean)task.containsPercentComplete(), (boolean)reload.containsPercentComplete());
        TaskTools.assertEquals((String)"PercentComplete differs", (int)task.getPercentComplete(), (int)reload.getPercentComplete());
        TaskTools.assertEquals((String)"TargetDuration differs", (boolean)task.containsTargetDuration(), (boolean)reload.containsTargetDuration());
        TaskTools.assertEquals((String)"TargetDuration differs", (Object)task.getTargetDuration(), (Object)reload.getTargetDuration());
        TaskTools.assertEquals((String)"ActualDuration differs", (boolean)task.containsActualDuration(), (boolean)reload.containsActualDuration());
        TaskTools.assertEquals((String)"ActualDuration differs", (Object)task.getActualDuration(), (Object)reload.getActualDuration());
    }

    public static void insert(AJAXClient client, Task ... tasks) throws OXException, IOException, JSONException {
        TimeZone tz = client.getValues().getTimeZone();
        InsertRequest[] inserts = new InsertRequest[tasks.length];
        for (int i = 0; i < tasks.length; ++i) {
            inserts[i] = new InsertRequest(tasks[i], tz);
        }
        MultipleRequest request = MultipleRequest.create(inserts);
        MultipleResponse response = (MultipleResponse)client.execute(request);
        for (int i = 0; i < tasks.length; ++i) {
            ((InsertResponse)((Object)response.getResponse(i))).fillTask(tasks[i]);
        }
    }

    public static Task valuesForUpdate(Task task) {
        return TaskTools.valuesForUpdate(task, task.getParentFolderID());
    }

    public static Task valuesForUpdate(Task task, int folderId) {
        Task retval = new Task();
        retval.setObjectID(task.getObjectID());
        retval.setParentFolderID(folderId);
        retval.setLastModified(task.getLastModified());
        return retval;
    }
}

