/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.task;

import com.openexchange.ajax.framework.AJAXRequest;
import com.openexchange.ajax.framework.AbstractAJAXResponse;
import com.openexchange.ajax.framework.Executor;
import com.openexchange.ajax.task.AbstractTaskTest;
import com.openexchange.ajax.task.actions.AllRequest;
import com.openexchange.ajax.task.actions.DeleteRequest;
import com.openexchange.ajax.task.actions.GetRequest;
import com.openexchange.ajax.task.actions.GetResponse;
import com.openexchange.ajax.task.actions.InsertRequest;
import com.openexchange.ajax.task.actions.InsertResponse;
import com.openexchange.ajax.task.actions.ListRequest;
import com.openexchange.ajax.task.actions.SearchRequest;
import com.openexchange.ajax.task.actions.UpdatesRequest;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.search.TaskSearchObject;
import com.openexchange.groupware.tasks.Task;
import java.io.IOException;
import java.util.Date;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.xml.sax.SAXException;

public class LastModifiedUTCTest
extends AbstractTaskTest {
    private static final int[] LAST_MODIFIED_UTC = new int[]{6, 1, 20};
    private int id;
    private Date lastModified;

    public LastModifiedUTCTest(String name) throws JSONException, OXException, IOException, SAXException {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        Task task = new Task();
        task.setTitle("lastModifiedUTC");
        task.setParentFolderID(this.getPrivateFolder());
        InsertRequest request = new InsertRequest(task, this.getTimeZone());
        InsertResponse response = Executor.execute(this.getClient(), request);
        this.id = response.getId();
        this.lastModified = response.getTimestamp();
    }

    @Override
    public void tearDown() throws Exception {
        DeleteRequest deleteRequest = new DeleteRequest(this.getPrivateFolder(), this.getId(), this.lastModified);
        Executor.execute(this.getClient(), deleteRequest);
        super.tearDown();
    }

    public int getId() {
        return this.id;
    }

    public void testAll() throws JSONException, OXException, IOException, SAXException {
        AllRequest request = new AllRequest(this.getPrivateFolder(), LAST_MODIFIED_UTC, -1, null);
        this.checkListSyleRequest(request);
    }

    public void testGet() throws JSONException, OXException, IOException, SAXException {
        GetRequest getRequest = new GetRequest(this.getPrivateFolder(), this.getId());
        GetResponse getResponse = Executor.execute(this.getClient(), getRequest);
        JSONObject object = (JSONObject)getResponse.getData();
        LastModifiedUTCTest.assertTrue((boolean)object.has("last_modified_utc"));
    }

    public void testList() throws JSONException, OXException, IOException, SAXException {
        ListRequest listRequest = new ListRequest((int[][])new int[][]{{this.getPrivateFolder(), this.getId()}}, LAST_MODIFIED_UTC);
        this.checkListSyleRequest(listRequest);
    }

    public void testSearch() throws JSONException, OXException, IOException, SAXException {
        TaskSearchObject search = new TaskSearchObject();
        search.setFolder(this.getPrivateFolder());
        search.setPattern("*");
        SearchRequest searchRequest = new SearchRequest(search, LAST_MODIFIED_UTC, true);
        this.checkListSyleRequest(searchRequest);
    }

    public void testUpdates() throws JSONException, OXException, IOException, SAXException {
        UpdatesRequest updatesRequest = new UpdatesRequest(this.getPrivateFolder(), LAST_MODIFIED_UTC, -1, null, new Date(0L));
        this.checkListSyleRequest(updatesRequest);
    }

    private void checkListSyleRequest(AJAXRequest<? extends AbstractAJAXResponse> request) throws JSONException, OXException, IOException, SAXException {
        AbstractAJAXResponse response = Executor.execute(this.getClient(), request);
        JSONArray arr = (JSONArray)response.getData();
        int size = arr.length();
        LastModifiedUTCTest.assertTrue((size > 0 ? 1 : 0) != 0);
        for (int i = 0; i < size; ++i) {
            JSONArray row = arr.getJSONArray(i);
            LastModifiedUTCTest.assertTrue((String)row.toString(), (row.length() == 3 ? 1 : 0) != 0);
            LastModifiedUTCTest.assertTrue((String)row.toString(), (row.optLong(0) > 0L ? 1 : 0) != 0);
        }
    }
}

