/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.task;

import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.task.AbstractTaskTest;
import com.openexchange.ajax.task.TaskTools;
import com.openexchange.ajax.task.actions.DeleteRequest;
import com.openexchange.ajax.task.actions.GetRequest;
import com.openexchange.ajax.task.actions.GetResponse;
import com.openexchange.ajax.task.actions.InsertRequest;
import com.openexchange.ajax.task.actions.InsertResponse;
import com.openexchange.groupware.tasks.Create;
import com.openexchange.groupware.tasks.Task;
import java.util.TimeZone;
import org.json.JSONException;
import org.json.JSONObject;

public class Bug8935Test
extends AbstractTaskTest {
    private AJAXClient client;

    public Bug8935Test(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.client = this.getClient();
    }

    public void testNull() throws Throwable {
        Task task = Create.createWithDefaults();
        task.setTitle("null");
        task.setParentFolderID(this.client.getValues().getPrivateTaskFolder());
        InsertResponse iResponse = this.client.execute(new InsertRequest(task, this.client.getValues().getTimeZone()));
        GetResponse gResponse = TaskTools.get(this.client, new GetRequest(iResponse));
        Task reload = gResponse.getTask(this.client.getValues().getTimeZone());
        TaskTools.compareAttributes(task, reload);
        this.client.execute(new DeleteRequest(reload));
    }

    public void testRealNull() throws Throwable {
        Task task = Create.createWithDefaults();
        task.removeTitle();
        task.setParentFolderID(this.client.getValues().getPrivateTaskFolder());
        InsertResponse iResponse = this.client.execute(new SpecialInsertRequest(task, this.client.getValues().getTimeZone()));
        GetResponse gResponse = TaskTools.get(this.client, new GetRequest(iResponse));
        Task reload = gResponse.getTask(this.client.getValues().getTimeZone());
        TaskTools.compareAttributes(task, reload);
        this.client.execute(new DeleteRequest(reload));
    }

    public void testEmptyString() throws Throwable {
        Task task = Create.createWithDefaults();
        task.setTitle("");
        task.setParentFolderID(this.client.getValues().getPrivateTaskFolder());
        InsertResponse iResponse = this.client.execute(new SpecialInsertRequest(task, this.client.getValues().getTimeZone()));
        task.removeTitle();
        GetResponse gResponse = TaskTools.get(this.client, new GetRequest(iResponse));
        Task reload = gResponse.getTask(this.client.getValues().getTimeZone());
        TaskTools.compareAttributes(task, reload);
        this.client.execute(new DeleteRequest(reload));
    }

    private class SpecialInsertRequest
    extends InsertRequest {
        public SpecialInsertRequest(Task task, TimeZone timeZone) {
            super(task, timeZone);
        }

        @Override
        public JSONObject getBody() throws JSONException {
            JSONObject json = super.getBody();
            json.put("title", JSONObject.NULL);
            return json;
        }
    }
}

