/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.reminder;

import com.openexchange.ajax.AppointmentTest;
import com.openexchange.ajax.FolderTest;
import com.openexchange.ajax.appointment.action.DeleteRequest;
import com.openexchange.ajax.appointment.action.GetRequest;
import com.openexchange.ajax.appointment.action.GetResponse;
import com.openexchange.ajax.config.ConfigTools;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AJAXSession;
import com.openexchange.ajax.reminder.ReminderTest;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.reminder.ReminderObject;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class UpdatesTest
extends ReminderTest {
    public UpdatesTest(String name) {
        super(name);
    }

    public void testRange() throws Exception {
        int userId = ConfigTools.getUserId(this.getWebConversation(), this.getHostName(), this.getSessionId());
        TimeZone timeZone = ConfigTools.getTimeZone(this.getWebConversation(), this.getHostName(), this.getSessionId());
        Calendar c = TimeTools.createCalendar(timeZone);
        c.add(11, 2);
        long startTime = c.getTimeInMillis();
        long endTime = startTime + 3600000L;
        FolderObject folderObj = FolderTest.getStandardCalendarFolder(this.getWebConversation(), this.getHostName(), this.getSessionId());
        int folderId = folderObj.getObjectID();
        Appointment appointmentObj = new Appointment();
        appointmentObj.setTitle("testRange");
        appointmentObj.setStartDate(new Date(startTime));
        appointmentObj.setEndDate(new Date(endTime));
        appointmentObj.setShownAs(3);
        appointmentObj.setAlarm(45);
        appointmentObj.setParentFolderID(folderId);
        appointmentObj.setIgnoreConflicts(true);
        int targetId = AppointmentTest.insertAppointment(this.getWebConversation(), appointmentObj, timeZone, this.getHostName(), this.getSessionId());
        ReminderObject[] reminderObj = UpdatesTest.listUpdates(this.getWebConversation(), new Date(System.currentTimeMillis() - 5000L), this.getHostName(), this.getSessionId(), timeZone);
        int pos = -1;
        for (int a = 0; a < reminderObj.length; ++a) {
            if (reminderObj[a].getTargetId() != targetId) continue;
            pos = a;
        }
        UpdatesTest.assertTrue((String)"reminder not found in response", (pos > -1 ? 1 : 0) != 0);
        UpdatesTest.assertTrue((String)"object id not found", (reminderObj[pos].getObjectId() > 0 ? 1 : 0) != 0);
        UpdatesTest.assertNotNull((String)"last modified is null", (Object)reminderObj[pos].getLastModified());
        UpdatesTest.assertEquals((String)"target id is not equals", (int)targetId, (int)reminderObj[pos].getTargetId());
        UpdatesTest.assertEquals((String)"folder id is not equals", (int)folderId, (int)reminderObj[pos].getFolder());
        UpdatesTest.assertEquals((String)"user id is not equals", (int)userId, (int)reminderObj[pos].getUser());
        long expectedAlarm = startTime - 2700000L;
        UpdatesTest.assertEquals((String)"alarm is not equals", (Object)new Date(expectedAlarm), (Object)reminderObj[pos].getDate());
        AJAXClient client = new AJAXClient(new AJAXSession(this.getWebConversation(), this.getHostName(), this.getSessionId()), false);
        GetResponse aGetR = client.execute(new GetRequest(folderId, targetId));
        client.execute(new DeleteRequest(targetId, folderId, aGetR.getTimestamp()));
    }
}

