/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.reminder;

import com.openexchange.ajax.appointment.action.AppointmentInsertResponse;
import com.openexchange.ajax.appointment.action.DeleteRequest;
import com.openexchange.ajax.appointment.action.InsertRequest;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.ajax.reminder.ReminderTest;
import com.openexchange.ajax.reminder.actions.RangeRequest;
import com.openexchange.ajax.reminder.actions.RangeResponse;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.reminder.ReminderObject;
import java.io.IOException;
import java.util.Calendar;
import java.util.TimeZone;
import org.json.JSONException;
import org.xml.sax.SAXException;

public class Bug15740Test
extends AbstractAJAXSession {
    private static final int alarmMinutes = 15;
    private AJAXClient client;
    private TimeZone tz;
    private int folderId;
    private Calendar calendar;
    private Appointment appointment;

    public Bug15740Test(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.client = this.getClient();
        this.tz = this.client.getValues().getTimeZone();
        this.folderId = this.client.getValues().getPrivateAppointmentFolder();
        this.calendar = TimeTools.createCalendar(this.tz);
        this.appointment = this.createAppointment();
    }

    @Override
    protected void tearDown() throws Exception {
        this.client.execute(new DeleteRequest(this.appointment));
        super.tearDown();
    }

    public void testBug15740() throws Exception {
        this.calendar.setTime(this.appointment.getEndDate());
        this.calendar.add(5, 1);
        RangeRequest request = new RangeRequest(this.calendar.getTime());
        RangeResponse response = this.client.execute(request);
        ReminderObject actual = null;
        for (ReminderObject reminder : response.getReminder(this.tz)) {
            if (this.appointment.getObjectID() != reminder.getTargetId()) continue;
            actual = reminder;
            break;
        }
        Bug15740Test.assertNotNull((String)"No reminder found for created appointment.", actual);
        ReminderObject expected = new ReminderObject();
        int reminder = actual.getObjectId();
        expected.setObjectId(reminder);
        expected.setFolder(this.folderId);
        expected.setTargetId(this.appointment.getObjectID());
        this.calendar.setTime(this.appointment.getStartDate());
        this.calendar.add(5, 1);
        this.calendar.add(12, -15);
        expected.setDate(this.calendar.getTime());
        ReminderTest.compareReminder(expected, actual);
    }

    private Appointment createAppointment() throws OXException, IOException, SAXException, JSONException {
        Appointment appointmentObj = new Appointment();
        appointmentObj.setTitle("testBug15740");
        this.calendar.add(5, -1);
        this.calendar.add(10, 1);
        Calendar endCal = (Calendar)this.calendar.clone();
        appointmentObj.setStartDate(this.calendar.getTime());
        endCal.add(10, 1);
        appointmentObj.setEndDate(endCal.getTime());
        appointmentObj.setAlarm(15);
        appointmentObj.setShownAs(3);
        appointmentObj.setParentFolderID(this.folderId);
        appointmentObj.setRecurrenceType(1);
        appointmentObj.setInterval(1);
        appointmentObj.setOccurrence(4);
        appointmentObj.setIgnoreConflicts(true);
        AppointmentInsertResponse insertR = this.client.execute(new InsertRequest(appointmentObj, this.tz));
        insertR.fillAppointment(appointmentObj);
        return appointmentObj;
    }
}

