/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.publish.tests;

import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.infostore.actions.InfostoreTestManager;
import com.openexchange.ajax.publish.actions.AllPublicationsRequest;
import com.openexchange.ajax.publish.actions.AllPublicationsResponse;
import com.openexchange.ajax.publish.actions.NewPublicationRequest;
import com.openexchange.ajax.publish.actions.NewPublicationResponse;
import com.openexchange.ajax.publish.tests.AbstractPublicationTest;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.infostore.DocumentMetadata;
import com.openexchange.groupware.infostore.database.impl.DocumentMetadataImpl;
import com.openexchange.java.Autoboxing;
import com.openexchange.publish.Publication;
import com.openexchange.publish.PublicationTargetDiscoveryService;
import com.openexchange.publish.SimPublicationTargetDiscoveryService;
import com.openexchange.test.TestInit;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.xml.sax.SAXException;

public class AllPublicationsTest
extends AbstractPublicationTest {
    public AllPublicationsTest(String name) {
        super(name);
    }

    public void testShouldNotFindNonExistingPublication() throws OXException, IOException, SAXException, JSONException {
        AJAXClient myClient = this.getClient();
        FolderObject testFolder = this.getFolderManager().generatePublicFolder("pubsub", 3, this.getClient().getValues().getPrivateContactFolder(), this.getClient().getValues().getUserId());
        this.getFolderManager().insertFolderOnServer(testFolder);
        AllPublicationsRequest req = new AllPublicationsRequest(String.valueOf(testFolder.getObjectID()), Integer.MAX_VALUE, "calendar", new LinkedList<String>());
        AllPublicationsResponse res = myClient.execute(req);
        JSONArray data = (JSONArray)res.getData();
        AllPublicationsTest.assertEquals((String)"Array should be empty", (Object)Autoboxing.I((int)0), (Object)Autoboxing.I((int)data.length()));
    }

    public void testShouldFindOneFreshlyCreatedPublication() throws OXException, IOException, SAXException, JSONException, OXException, OXException {
        Contact contact = this.createDefaultContactFolderWithOneContact();
        String folderID = String.valueOf(contact.getParentFolderID());
        String module = "contacts";
        SimPublicationTargetDiscoveryService discovery = new SimPublicationTargetDiscoveryService();
        Publication expected = this.generatePublication(module, folderID, discovery);
        expected.setDisplayName("This will be changed");
        NewPublicationRequest newReq = new NewPublicationRequest(expected);
        AJAXClient myClient = this.getClient();
        NewPublicationResponse newResp = myClient.execute(newReq);
        AllPublicationsTest.assertFalse((String)("Precondition: Should be able to create a publication: " + (Object)((Object)newResp.getException())), (boolean)newResp.hasError());
        expected.setId(newResp.getId());
        AllPublicationsRequest req = new AllPublicationsRequest(folderID, expected.getId(), module, Arrays.asList("id", "entity", "entityModule", "displayName", "target"));
        AllPublicationsResponse resp = this.getClient().execute(req);
        AllPublicationsTest.assertFalse((String)"Should work", (boolean)resp.hasError());
        AllPublicationsTest.assertEquals((String)"Should have exactly one result", (int)1, (int)resp.getAll().size());
        JSONArray actual = resp.getAll().get(0);
        AllPublicationsTest.assertEquals((String)"Should have same publication ID", (int)expected.getId(), (int)actual.getInt(0));
        AllPublicationsTest.assertEquals((Object)expected.getEntityId(), (Object)actual.getJSONObject(1).get("folder"));
        AllPublicationsTest.assertEquals((String)"Should have same module", (String)expected.getModule(), (String)actual.getString(2));
        AllPublicationsTest.assertFalse((String)"Should change display name", (boolean)expected.getDisplayName().equals(actual.getString(3)));
        AllPublicationsTest.assertEquals((String)"Should have same target ID", (String)expected.getTarget().getId(), (String)actual.getString(4));
    }

    public void testShouldFindOneFreshlyCreatedPublicationForEmptyFolder() throws OXException, IOException, SAXException, JSONException, OXException, OXException {
        FolderObject folder = this.createDefaultContactFolder();
        String folderID = String.valueOf(folder.getObjectID());
        String module = "contacts";
        SimPublicationTargetDiscoveryService discovery = new SimPublicationTargetDiscoveryService();
        this.pubMgr.setPublicationTargetDiscoveryService((PublicationTargetDiscoveryService)discovery);
        Publication expected = this.generatePublication(module, folderID, discovery);
        expected.setDisplayName("This will be changed");
        this.pubMgr.newAction(expected);
        AllPublicationsTest.assertFalse((String)"Precondition: Should be able to create a publication", (boolean)this.pubMgr.getLastResponse().hasError());
        this.pubMgr.allAction(folderID, expected.getId(), module, Arrays.asList("id", "entity", "entityModule", "displayName", "target"));
        AllPublicationsResponse resp = (AllPublicationsResponse)this.pubMgr.getLastResponse();
        AllPublicationsTest.assertFalse((String)"Should work", (boolean)resp.hasError());
        AllPublicationsTest.assertEquals((String)"Should have exactly one result", (int)1, (int)resp.getAll().size());
        JSONArray actual = resp.getAll().get(0);
        AllPublicationsTest.assertEquals((String)"Should have same publication ID", (int)expected.getId(), (int)actual.getInt(0));
        AllPublicationsTest.assertEquals((Object)expected.getEntityId(), (Object)actual.getJSONObject(1).get("folder"));
        AllPublicationsTest.assertEquals((String)"Should have same module", (String)expected.getModule(), (String)actual.getString(2));
        AllPublicationsTest.assertFalse((String)"Should change display name", (boolean)expected.getDisplayName().equals(actual.getString(3)));
        AllPublicationsTest.assertEquals((String)"Should have same target ID", (String)expected.getTarget().getId(), (String)actual.getString(4));
    }

    public void testShouldFindAllPublicationsOfUser() throws OXException, IOException, SAXException, JSONException, OXException, OXException {
        FolderObject contactFolder = this.createDefaultContactFolder();
        String contactModule = "contacts";
        FolderObject infostoreFolder = this.createDefaultInfostoreFolder("Folder for Publication-" + System.currentTimeMillis());
        String infostoreModule = "infostore";
        InfostoreTestManager infoMgr = this.getInfostoreManager();
        FolderObject infostorePublicationFolder = this.createDefaultInfostoreFolder("Second Folder for Publication-" + System.currentTimeMillis());
        DocumentMetadataImpl data = new DocumentMetadataImpl();
        data.setTitle("Infostore Item To Be Published");
        data.setDescription("Infostore Item To Be Published");
        data.setFileMIMEType("text/plain");
        data.setFolderId((long)infostorePublicationFolder.getObjectID());
        File upload = new File(TestInit.getTestProperty("ajaxPropertiesFile"));
        data.setFileName(upload.getName());
        infoMgr.newAction((DocumentMetadata)data, upload);
        ArrayList<Publication> expectedPublications = new ArrayList<Publication>();
        SimPublicationTargetDiscoveryService discovery = new SimPublicationTargetDiscoveryService();
        this.pubMgr.setPublicationTargetDiscoveryService((PublicationTargetDiscoveryService)discovery);
        Publication contactPublication = this.generatePublication(contactModule, String.valueOf(contactFolder.getObjectID()), discovery);
        contactPublication.setDisplayName("My Contact Publication");
        expectedPublications.add(contactPublication);
        Publication infostorePublication = this.generatePublication(infostoreModule, String.valueOf(infostoreFolder.getObjectID()), discovery);
        infostorePublication.setDisplayName("My InfostoreFolder Publication");
        expectedPublications.add(infostorePublication);
        Publication infostoreItemPublication = this.generateInfostoreItemPublication(String.valueOf(data.getId()), discovery);
        expectedPublications.add(infostoreItemPublication);
        for (Publication p : expectedPublications) {
            this.pubMgr.newAction(p);
            AllPublicationsTest.assertFalse((String)"Precondition: Should be able to create a publication", (boolean)this.pubMgr.getLastResponse().hasError());
        }
        this.pubMgr.allAction(Arrays.asList("id", "entity", "entityModule", "displayName", "target"));
        AllPublicationsResponse resp = (AllPublicationsResponse)this.pubMgr.getLastResponse();
        List<JSONArray> all = resp.getAll();
        ArrayList<Integer> foundIds = new ArrayList<Integer>();
        for (JSONArray c : all) {
            int id = c.getInt(0);
            foundIds.add(id);
        }
        boolean foundAllContacts = true;
        for (Publication p : expectedPublications) {
            if (foundIds.contains(p.getId())) continue;
            foundAllContacts = false;
        }
        AllPublicationsTest.assertTrue((String)"Did not get all contact publications.", (boolean)foundAllContacts);
        this.pubMgr.allAction(contactModule, -1, Arrays.asList("id", "entity", "entityModule", "displayName", "target"));
        resp = (AllPublicationsResponse)this.pubMgr.getLastResponse();
        AllPublicationsTest.assertFalse((String)"Should work", (boolean)resp.hasError());
        List<JSONArray> allContacts = resp.getAll();
        foundIds.clear();
        for (JSONArray c : allContacts) {
            int id = c.getInt(0);
            foundIds.add(id);
        }
        AllPublicationsTest.assertTrue((String)"Did not get published contact.", (boolean)foundIds.contains(contactPublication.getId()));
        infoMgr.cleanUp();
    }
}

