/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.mail.netsol.actions;

import com.openexchange.ajax.container.Response;
import com.openexchange.ajax.framework.AJAXRequest;
import com.openexchange.ajax.framework.AbstractAJAXParser;
import com.openexchange.ajax.mail.actions.AbstractMailRequest;
import com.openexchange.ajax.mail.netsol.actions.NetsolFolderResponse;
import org.json.JSONException;

public final class NetsolFolderRequest
extends AbstractMailRequest {
    public static final int[] COLUMNS_DEFAULT_LIST = new int[]{1, 301, 300, 307, 304, 306, 302, 305, 308, 311, 2, 314, 313, 315};
    private final String folderIdentifer;
    private final int[] columns;
    private final boolean failOnError;

    @Override
    public String getServletPath() {
        return "/ajax/folders";
    }

    public NetsolFolderRequest(String folderIdentifer) {
        this(folderIdentifer, COLUMNS_DEFAULT_LIST, true);
    }

    public NetsolFolderRequest(String folderIdentifer, int[] columns) {
        this(folderIdentifer, columns, true);
    }

    public NetsolFolderRequest(String folderIdentifer, int[] columns, boolean failOnError) {
        this.folderIdentifer = folderIdentifer;
        this.columns = columns;
        this.failOnError = failOnError;
    }

    @Override
    public Object getBody() throws JSONException {
        return null;
    }

    @Override
    public AJAXRequest.Method getMethod() {
        return AJAXRequest.Method.GET;
    }

    @Override
    public AJAXRequest.Parameter[] getParameters() {
        return new AJAXRequest.Parameter[]{new AJAXRequest.Parameter("action", "list"), new AJAXRequest.Parameter("parent", this.folderIdentifer), new AJAXRequest.Parameter("columns", this.columns)};
    }

    @Override
    public AbstractAJAXParser<NetsolFolderResponse> getParser() {
        return new NetsolFolderParser(this.failOnError);
    }

    static final class NetsolFolderParser
    extends AbstractAJAXParser<NetsolFolderResponse> {
        NetsolFolderParser(boolean failOnError) {
            super(failOnError);
        }

        @Override
        protected NetsolFolderResponse createResponse(Response response) throws JSONException {
            return new NetsolFolderResponse(response);
        }
    }
}

