/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.kata.appointments;

import com.openexchange.ajax.appointment.action.AllRequest;
import com.openexchange.ajax.appointment.action.HasRequest;
import com.openexchange.ajax.appointment.action.HasResponse;
import com.openexchange.ajax.appointment.action.ListRequest;
import com.openexchange.ajax.appointment.action.SearchRequest;
import com.openexchange.ajax.appointment.action.SearchResponse;
import com.openexchange.ajax.appointment.action.UpdatesRequest;
import com.openexchange.ajax.appointment.action.UpdatesResponse;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.CommonAllResponse;
import com.openexchange.ajax.framework.CommonListResponse;
import com.openexchange.ajax.framework.ListIDs;
import com.openexchange.ajax.kata.NeedExistingStep;
import com.openexchange.ajax.kata.appointments.ParticipantComparisonFailure;
import com.openexchange.ajax.kata.appointments.UserParticipantComparisonFailure;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.ExternalUserParticipant;
import com.openexchange.groupware.container.GroupParticipant;
import com.openexchange.groupware.container.Participant;
import com.openexchange.groupware.container.UserParticipant;
import com.openexchange.test.CalendarTestManager;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.junit.Assert;
import org.xml.sax.SAXException;

public class AppointmentVerificationStep
extends NeedExistingStep<Appointment> {
    private final Appointment entry;
    private CalendarTestManager manager;
    private int expectedFolderId;

    public AppointmentVerificationStep(Appointment entry, String name) {
        super(name, null);
        this.entry = entry;
    }

    @Override
    public void cleanUp() throws Exception {
    }

    @Override
    protected void assumeIdentity(Appointment thing) {
        this.expectedFolderId = this.entry.getParentFolderID();
        boolean containsFolderId = this.entry.containsParentFolderID();
        super.assumeIdentity(this.entry);
        if (!containsFolderId) {
            this.expectedFolderId = this.entry.getParentFolderID();
        }
    }

    @Override
    public void perform(AJAXClient client) throws Exception {
        this.client = client;
        this.manager = new CalendarTestManager(client);
        this.assumeIdentity(this.entry);
        this.checkWithReadMethods(this.entry);
    }

    private void checkWithReadMethods(Appointment appointment) throws OXException, JSONException, OXException, IOException, SAXException {
        this.checkViaGet(appointment);
        this.checkViaAll(appointment);
        this.checkViaList(appointment);
        this.checkViaUpdates(appointment);
        this.checkViaSearch(appointment);
        this.checkViaHas(appointment);
    }

    private void checkViaGet(Appointment appointment) throws OXException, JSONException {
        Appointment loaded = this.manager.get(this.expectedFolderId, appointment.getObjectID());
        this.compare(appointment, loaded);
    }

    private void checkViaAll(Appointment appointment) throws OXException, IOException, SAXException, JSONException {
        Object[][] rows = this.getViaAll(appointment);
        this.checkInList(appointment, rows, Appointment.ALL_COLUMNS);
    }

    private void checkViaList(Appointment appointment) throws OXException, IOException, SAXException, JSONException {
        ListRequest listRequest = new ListRequest(ListIDs.l(new int[][]{{this.expectedFolderId, appointment.getObjectID()}}), Appointment.ALL_COLUMNS);
        CommonListResponse response = this.client.execute(listRequest);
        Object[][] rows = response.getArray();
        this.checkInList(appointment, rows, Appointment.ALL_COLUMNS);
    }

    private void checkViaUpdates(Appointment appointment) throws OXException, IOException, SAXException, JSONException, OXException {
        UpdatesRequest updates = new UpdatesRequest(this.expectedFolderId, Appointment.ALL_COLUMNS, new Date(0L), true);
        UpdatesResponse response = this.client.execute(updates);
        List<Appointment> appointments = response.getAppointments(this.getTimeZone());
        this.checkInList(appointment, appointments);
    }

    private void checkViaSearch(Appointment appointment) throws OXException, IOException, SAXException, JSONException {
        Object[][] rows = this.getViaSearch(appointment);
        this.checkInList(appointment, rows, Appointment.ALL_COLUMNS);
    }

    private void checkViaHas(Appointment appointment) throws OXException, IOException, SAXException, JSONException {
        HasRequest hasRequest = new HasRequest(appointment.getStartDate(), appointment.getEndDate(), this.getTimeZone());
        HasResponse hasResponse = this.client.execute(hasRequest);
        boolean[] values = hasResponse.getValues();
        for (int i = 0; i < values.length; ++i) {
            Assert.assertTrue((String)("Should return true for day " + i + " of the appointment"), (boolean)values[i]);
        }
    }

    private Object[][] getViaAll(Appointment appointment) throws OXException, IOException, SAXException, JSONException {
        long rangeStart = appointment.getStartDate().getTime() - 86400000L;
        long rangeEnd = appointment.getEndDate().getTime() + 86400000L;
        AllRequest all = new AllRequest(this.expectedFolderId, Appointment.ALL_COLUMNS, new Date(rangeStart), new Date(rangeEnd), this.getTimeZone(), true);
        CommonAllResponse response = this.client.execute(all);
        return response.getArray();
    }

    private Object[][] getViaSearch(Appointment appointment) throws OXException, IOException, SAXException, JSONException {
        SearchRequest searchRequest = new SearchRequest("*", this.expectedFolderId, new Date(0L), new Date(Integer.MAX_VALUE), Appointment.ALL_COLUMNS, -1, null, false, true);
        SearchResponse searchResponse = this.client.execute(searchRequest);
        return searchResponse.getArray();
    }

    private void compare(Appointment appointment, Appointment loaded) {
        int[] columns = Appointment.ALL_COLUMNS;
        for (int i = 0; i < columns.length; ++i) {
            Participant[] actual;
            Participant[] expected;
            int col = columns[i];
            if (col == 220 && appointment.containsParticipants()) {
                expected = appointment.getParticipants();
                if (this.compareArrays(expected, actual = loaded.getParticipants())) continue;
                throw new ParticipantComparisonFailure("Missing participant", expected, actual);
            }
            if (col == 221 && appointment.containsUserParticipants()) {
                expected = appointment.getUsers();
                if (this.compareArrays(expected, actual = loaded.getUsers())) continue;
                throw new UserParticipantComparisonFailure("Missing user", (UserParticipant[])expected, (UserParticipant[])actual);
            }
            if (col == 6 || col == 5) continue;
            if (appointment.containsParentFolderID()) {
                Assert.assertEquals((String)(this.name + " : Column " + col + " differs!"), (long)this.expectedFolderId, (long)loaded.getParentFolderID());
                continue;
            }
            if (!appointment.contains(col)) continue;
            Assert.assertEquals((String)(this.name + ": Column " + col + " differs!"), (Object)appointment.get(col), (Object)loaded.get(col));
        }
    }

    private void checkInList(Appointment appointment, Object[][] rows, int[] columns) throws OXException, IOException, SAXException, JSONException {
        int idPos = this.findIDIndex(columns);
        for (int i = 0; i < rows.length; ++i) {
            Object[] row = rows[i];
            int id = (Integer)row[idPos];
            if (id != appointment.getObjectID()) continue;
            this.compare(appointment, row, columns);
            return;
        }
        Assert.fail((String)("Object not found in response. " + this.name));
    }

    private void compare(Appointment appointment, Object[] row, int[] columns) throws OXException, IOException, SAXException, JSONException {
        for (int i = 0; i < columns.length; ++i) {
            Object actual;
            Object expected;
            int column = columns[i];
            if (column == 6 || column == 5) continue;
            if (column == 220 && appointment.containsParticipants()) {
                expected = appointment.getParticipants();
                if (this.compareArrays((T[])expected, (T[])(actual = (Participant[])this.transform(column, row[i])))) continue;
                throw new ParticipantComparisonFailure("", (Participant[])expected, (Participant[])actual);
            }
            if (column == 221 && appointment.containsUserParticipants()) {
                expected = appointment.getUsers();
                if (this.compareArrays((T[])expected, (T[])(actual = (UserParticipant[])this.transform(column, row[i])))) continue;
                throw new UserParticipantComparisonFailure("", (UserParticipant[])expected, (UserParticipant[])actual);
            }
            if (column == 20) {
                Assert.assertEquals((String)(this.name + " Column: " + column), (Object)this.expectedFolderId, (Object)row[i]);
                continue;
            }
            if (!appointment.contains(column)) continue;
            expected = appointment.get(column);
            actual = row[i];
            actual = this.transform(column, actual);
            Assert.assertEquals((String)(this.name + " Column: " + column), (Object)expected, (Object)actual);
        }
    }

    private void checkInList(Appointment appointment, List<Appointment> appointments) {
        for (Appointment appointmentFromList : appointments) {
            if (appointmentFromList.getObjectID() != appointment.getObjectID()) continue;
            this.compare(appointment, appointmentFromList);
            return;
        }
        Assert.fail((String)("Object not found in response. " + this.name));
    }

    private int findIDIndex(int[] columns) {
        for (int i = 0; i < columns.length; ++i) {
            if (columns[i] != 1) continue;
            return i;
        }
        Assert.fail((String)("No ID column requested. This won't work. " + this.name));
        return -1;
    }

    protected <T> boolean compareArrays(T[] expected, T[] actual) {
        if (expected == null && actual == null) {
            return true;
        }
        if (expected == null && actual != null) {
            return false;
        }
        if (expected != null && actual == null) {
            return false;
        }
        HashSet<T> expectedParticipants = new HashSet<T>(Arrays.asList(expected));
        HashSet<T> actualParticipants = new HashSet<T>(Arrays.asList(actual));
        if (expectedParticipants.size() != actualParticipants.size()) {
            return false;
        }
        return expectedParticipants.containsAll(actualParticipants);
    }

    protected Object transform(int column, Object actual) throws OXException, IOException, SAXException, JSONException {
        switch (column) {
            case 201: 
            case 202: {
                int offset = this.getTimeZone().getOffset((Long)actual);
                return new Date((Long)actual - (long)offset);
            }
            case 220: {
                JSONArray participantArr = (JSONArray)actual;
                LinkedList<Object> participants = new LinkedList<Object>();
                int size = participantArr.length();
                block10: for (int i = 0; i < size; ++i) {
                    JSONObject participantObj = participantArr.getJSONObject(i);
                    int type = participantObj.getInt("type");
                    switch (type) {
                        case 1: {
                            participants.add(new UserParticipant(participantObj.getInt("id")));
                            continue block10;
                        }
                        case 2: {
                            participants.add(new GroupParticipant(participantObj.getInt("id")));
                            continue block10;
                        }
                        case 5: {
                            participants.add(new ExternalUserParticipant(participantObj.getString("mail")));
                        }
                    }
                }
                return participants.toArray(new Participant[participants.size()]);
            }
            case 221: {
                JSONArray userParticipantArr = (JSONArray)actual;
                LinkedList<UserParticipant> userParticipants = new LinkedList<UserParticipant>();
                int size = userParticipantArr.length();
                for (int i = 0; i < size; ++i) {
                    JSONObject participantObj = userParticipantArr.getJSONObject(i);
                    userParticipants.add(new UserParticipant(participantObj.getInt("id")));
                }
                return userParticipants.toArray(new UserParticipant[userParticipants.size()]);
            }
        }
        return actual;
    }
}

