/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.folder.api2;

import com.openexchange.ajax.folder.actions.API;
import com.openexchange.ajax.folder.actions.DeleteRequest;
import com.openexchange.ajax.folder.actions.EnumAPI;
import com.openexchange.ajax.folder.actions.GetRequest;
import com.openexchange.ajax.folder.actions.InsertRequest;
import com.openexchange.ajax.folder.actions.UpdateRequest;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AbstractAJAXResponse;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.server.impl.OCLPermission;
import org.json.JSONArray;
import org.json.JSONObject;

public class UpdateTest
extends AbstractAJAXSession {
    private AJAXClient client;

    public UpdateTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.client = this.getClient();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void testUpdatePrivate() throws Throwable {
        FolderObject fo = null;
        try {
            fo = new FolderObject();
            fo.setParentFolderID(1);
            fo.setFolderName("testCalendarFolder" + System.currentTimeMillis());
            fo.setModule(2);
            OCLPermission oclP = new OCLPermission();
            oclP.setEntity(this.client.getValues().getUserId());
            oclP.setGroupPermission(false);
            oclP.setFolderAdmin(true);
            oclP.setAllPermission(128, 128, 128, 128);
            fo.setPermissionsAsArray(new OCLPermission[]{oclP});
            InsertRequest insertRequest = new InsertRequest(EnumAPI.OUTLOOK, fo);
            AbstractAJAXResponse response = this.client.execute(insertRequest);
            String newId = (String)response.getResponse().getData();
            UpdateTest.assertNotNull((String)"New ID must not be null!", (Object)newId);
            fo.setLastModified(this.client.execute(new GetRequest((API)EnumAPI.OUTLOOK, newId)).getTimestamp());
            fo.setFolderName("testCalendarFolderRename" + System.currentTimeMillis());
            fo.setObjectID(Integer.parseInt(newId));
            OCLPermission oCLPermission = new OCLPermission();
            oCLPermission.setEntity(this.client.getValues().getUserId());
            oCLPermission.setGroupPermission(false);
            oCLPermission.setFolderAdmin(true);
            oCLPermission.setAllPermission(128, 128, 128, 128);
            OCLPermission oclP2 = new OCLPermission();
            oclP2.setEntity(0);
            oclP2.setGroupPermission(true);
            oclP2.setFolderAdmin(false);
            oclP2.setAllPermission(2, 4, 0, 0);
            fo.setPermissionsAsArray(new OCLPermission[]{oCLPermission, oclP2});
            UpdateRequest updateRequest = new UpdateRequest(EnumAPI.OUTLOOK, fo);
            this.client.execute(updateRequest).getResponse();
            GetRequest getRequest = new GetRequest((API)EnumAPI.OUTLOOK, newId);
            response = this.client.execute(getRequest);
            fo.setLastModified(response.getTimestamp());
            JSONObject jsonObject = (JSONObject)response.getResponse().getData();
            String name = jsonObject.getString("title");
            UpdateTest.assertNotNull((String)"Folder name expected", (Object)name);
            UpdateTest.assertEquals((String)"Rename failed.", (String)fo.getFolderName(), (String)name);
            JSONArray permissions = jsonObject.getJSONArray("permissions");
            UpdateTest.assertEquals((String)"Unexpected number of permissions.", (int)2, (int)permissions.length());
            if (null == fo) return;
        }
        catch (Throwable throwable) {
            if (null == fo) throw throwable;
            try {
                DeleteRequest deleteRequest = new DeleteRequest((API)EnumAPI.OUTLOOK, fo);
                this.client.execute(deleteRequest);
                throw throwable;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            throw throwable;
        }
        try {
            DeleteRequest deleteRequest = new DeleteRequest((API)EnumAPI.OUTLOOK, fo);
            this.client.execute(deleteRequest);
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

