/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.folder.api2;

import com.openexchange.ajax.folder.actions.API;
import com.openexchange.ajax.folder.actions.DeleteRequest;
import com.openexchange.ajax.folder.actions.EnumAPI;
import com.openexchange.ajax.folder.actions.InsertRequest;
import com.openexchange.ajax.folder.actions.InsertResponse;
import com.openexchange.ajax.folder.actions.PathRequest;
import com.openexchange.ajax.folder.actions.PathResponse;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.server.impl.OCLPermission;
import java.util.Date;
import org.json.JSONArray;

public class PathTest
extends AbstractAJAXSession {
    private static final String PRIVATE_FOLDER_ID = String.valueOf(1);
    private AJAXClient client;

    public PathTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.client = this.getClient();
    }

    public void testPath1() throws Throwable {
        PathRequest pathRequest = new PathRequest(EnumAPI.OUTLOOK, String.valueOf(0));
        PathResponse pathResponse = this.client.execute(pathRequest);
        JSONArray jsonArray = (JSONArray)pathResponse.getResponse().getData();
        int length = jsonArray.length();
        PathTest.assertEquals((String)"Unexpected path length.", (int)0, (int)length);
    }

    public void testPath2() throws Throwable {
        PathRequest pathRequest = new PathRequest(EnumAPI.OUTLOOK, PRIVATE_FOLDER_ID);
        PathResponse pathResponse = this.client.execute(pathRequest);
        JSONArray jsonArray = (JSONArray)pathResponse.getResponse().getData();
        int length = jsonArray.length();
        PathTest.assertEquals((String)"Unexpected path length.", (int)1, (int)length);
        PathTest.assertEquals((String)"Unexpected path element.", (String)PRIVATE_FOLDER_ID, (String)jsonArray.getJSONArray(0).getString(0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void testPath3() throws Throwable {
        String newId = null;
        try {
            FolderObject fo = new FolderObject();
            fo.setParentFolderID(1);
            fo.setFolderName("testCalendarFolder" + System.currentTimeMillis());
            fo.setModule(2);
            OCLPermission oclP = new OCLPermission();
            oclP.setEntity(this.client.getValues().getUserId());
            oclP.setGroupPermission(false);
            oclP.setFolderAdmin(true);
            oclP.setAllPermission(128, 128, 128, 128);
            fo.setPermissionsAsArray(new OCLPermission[]{oclP});
            InsertRequest request = new InsertRequest(EnumAPI.OUTLOOK, fo);
            InsertResponse response = this.client.execute(request);
            newId = (String)response.getResponse().getData();
            PathTest.assertNotNull((String)"New ID must not be null!", (Object)newId);
            PathRequest pathRequest = new PathRequest(EnumAPI.OUTLOOK, newId);
            PathResponse pathResponse = this.client.execute(pathRequest);
            JSONArray jsonArray = (JSONArray)pathResponse.getResponse().getData();
            int length = jsonArray.length();
            PathTest.assertEquals((String)("Unexpected path length:" + System.getProperty("line.separator") + jsonArray), (int)2, (int)length);
            PathTest.assertEquals((String)"Unexpected path element.", (String)newId, (String)jsonArray.getJSONArray(0).getString(0));
            PathTest.assertEquals((String)"Unexpected path element.", (String)PRIVATE_FOLDER_ID, (String)jsonArray.getJSONArray(1).getString(0));
            if (null == newId) return;
        }
        catch (Throwable throwable) {
            if (null == newId) throw throwable;
            try {
                DeleteRequest deleteRequest = new DeleteRequest((API)EnumAPI.OUTLOOK, newId, new Date());
                this.client.execute(deleteRequest);
                throw throwable;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            throw throwable;
        }
        try {
            DeleteRequest deleteRequest = new DeleteRequest((API)EnumAPI.OUTLOOK, newId, new Date());
            this.client.execute(deleteRequest);
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

