/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.contact;

import com.openexchange.ajax.attach.actions.AttachRequest;
import com.openexchange.ajax.contact.action.AllRequest;
import com.openexchange.ajax.contact.action.DeleteRequest;
import com.openexchange.ajax.contact.action.GetRequest;
import com.openexchange.ajax.contact.action.GetResponse;
import com.openexchange.ajax.contact.action.InsertRequest;
import com.openexchange.ajax.contact.action.ListRequest;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.ajax.framework.CommonAllResponse;
import com.openexchange.ajax.framework.CommonListResponse;
import com.openexchange.ajax.framework.ListIDs;
import com.openexchange.groupware.container.CommonObject;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.container.DataObject;
import java.io.ByteArrayInputStream;
import java.util.Date;
import java.util.TimeZone;
import junit.framework.AssertionFailedError;

public class ContactAttachmentTests
extends AbstractAJAXSession {
    private int folderId;
    private TimeZone tz;
    private Contact contact;
    private int attachmentId;
    private Date creationDate;

    public ContactAttachmentTests(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.folderId = this.client.getValues().getPrivateContactFolder();
        this.tz = this.client.getValues().getTimeZone();
        this.contact = new Contact();
        this.contact.setParentFolderID(this.folderId);
        this.contact.setDisplayName("Test contact for testing attachments");
        this.client.execute(new InsertRequest(this.contact)).fillObject((DataObject)this.contact);
        this.attachmentId = this.client.execute(new AttachRequest((CommonObject)this.contact, "test.txt", new ByteArrayInputStream("Test".getBytes()), "text/plain")).getId();
        com.openexchange.ajax.attach.actions.GetResponse response = this.client.execute(new com.openexchange.ajax.attach.actions.GetRequest((CommonObject)this.contact, this.attachmentId));
        long timestamp = response.getAttachment().getCreationDate().getTime();
        this.creationDate = new Date(timestamp - (long)this.tz.getOffset(timestamp));
    }

    @Override
    protected void tearDown() throws Exception {
        this.client.execute(new DeleteRequest(this.contact));
        super.tearDown();
    }

    public void testLastModifiedOfNewestAttachmentWithGet() throws Throwable {
        GetResponse response = this.client.execute(new GetRequest(this.contact.getParentFolderID(), this.contact.getObjectID(), this.tz));
        this.contact.setLastModified(response.getTimestamp());
        Contact test = response.getContact();
        ContactAttachmentTests.assertEquals((String)"Creation date of attachment does not match.", (Object)this.creationDate, (Object)test.getLastModifiedOfNewestAttachment());
    }

    public void testLastModifiedOfNewestAttachmentWithAll() throws Throwable {
        CommonAllResponse response = this.client.execute(new AllRequest(this.contact.getParentFolderID(), new int[]{1, 105}));
        this.contact.setLastModified(response.getTimestamp());
        Contact test = null;
        int objectIdPos = response.getColumnPos(1);
        int lastModifiedOfNewestAttachmentPos = response.getColumnPos(105);
        for (Object[] objA : response) {
            if (this.contact.getObjectID() != ((Integer)objA[objectIdPos]).intValue()) continue;
            test = new Contact();
            test.setLastModifiedOfNewestAttachment(new Date((Long)objA[lastModifiedOfNewestAttachmentPos]));
            break;
        }
        if (null == test) {
            throw new AssertionFailedError("Can not find the created contact with an attachment.");
        }
        ContactAttachmentTests.assertEquals((String)"Creation date of attachment does not match.", (Object)this.creationDate, (Object)test.getLastModifiedOfNewestAttachment());
    }

    public void testLastModifiedOfNewestAttachmentWithList() throws Throwable {
        CommonListResponse response = this.client.execute(new ListRequest(ListIDs.l(new int[][]{{this.contact.getParentFolderID(), this.contact.getObjectID()}}), new int[]{1, 105}));
        this.contact.setLastModified(response.getTimestamp());
        Contact test = null;
        int objectIdPos = response.getColumnPos(1);
        int lastModifiedOfNewestAttachmentPos = response.getColumnPos(105);
        for (Object[] objA : response) {
            if (this.contact.getObjectID() != ((Integer)objA[objectIdPos]).intValue()) continue;
            test = new Contact();
            test.setLastModifiedOfNewestAttachment(new Date((Long)objA[lastModifiedOfNewestAttachmentPos]));
            break;
        }
        if (null == test) {
            throw new AssertionFailedError("Can not find the created contact with an attachment.");
        }
        ContactAttachmentTests.assertEquals((String)"Creation date of attachment does not match.", (Object)this.creationDate, (Object)test.getLastModifiedOfNewestAttachment());
    }
}

