/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.appointment.bugtests;

import com.openexchange.ajax.appointment.action.AppointmentInsertResponse;
import com.openexchange.ajax.appointment.action.ConflictObject;
import com.openexchange.ajax.appointment.action.DeleteRequest;
import com.openexchange.ajax.appointment.action.InsertRequest;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.ajax.resource.ResourceTools;
import com.openexchange.calendar.ConflictTools;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.Participant;
import com.openexchange.groupware.container.ResourceParticipant;
import java.util.Calendar;
import java.util.TimeZone;

public class Bug15585Test
extends AbstractAJAXSession {
    private AJAXClient client;
    private Appointment appointment;
    private Appointment appointment2;
    private TimeZone timeZone;

    public Bug15585Test(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.client = this.getClient();
        this.timeZone = this.client.getValues().getTimeZone();
        this.appointment = new Appointment();
        this.appointment.setParentFolderID(this.client.getValues().getPrivateAppointmentFolder());
        this.appointment.setTitle("Test for bug 15585");
        this.appointment.setIgnoreConflicts(true);
        Calendar calendar = TimeTools.createCalendar(this.timeZone);
        this.appointment.setStartDate(calendar.getTime());
        calendar.add(10, 1);
        this.appointment.setEndDate(calendar.getTime());
        this.appointment.addParticipant((Participant)new ResourceParticipant(ResourceTools.getSomeResource(this.client)));
        this.appointment2 = this.appointment.clone();
        InsertRequest request = new InsertRequest(this.appointment, this.timeZone);
        AppointmentInsertResponse response = this.client.execute(request);
        response.fillAppointment(this.appointment);
    }

    @Override
    protected void tearDown() throws Exception {
        this.client.execute(new DeleteRequest(this.appointment));
        super.tearDown();
    }

    public void testConflictTitle() throws Throwable {
        InsertRequest request = new InsertRequest(this.appointment2, this.timeZone);
        AppointmentInsertResponse response = this.client.execute(request);
        Bug15585Test.assertTrue((String)"Resource hard conflict expected.", (boolean)response.hasConflicts());
        response.getConflicts();
        ConflictObject conflict = ConflictTools.findById(response.getConflicts(), this.appointment.getObjectID());
        Bug15585Test.assertEquals((String)"Title of my appointment is not readable.", (String)this.appointment.getTitle(), (String)conflict.getTitle());
    }
}

