/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.appointment;

import com.openexchange.ajax.AppointmentTest;
import com.openexchange.groupware.container.Appointment;
import java.util.Date;

public class ResolveUidTest
extends AppointmentTest {
    public ResolveUidTest(String name) {
        super(name);
    }

    public void testWithUid() throws Exception {
        Appointment appointmentObj = new Appointment();
        appointmentObj.setTitle("testSimple");
        appointmentObj.setStartDate(new Date(startTime));
        appointmentObj.setEndDate(new Date(endTime));
        appointmentObj.setShownAs(3);
        appointmentObj.setParentFolderID(appointmentFolderId);
        appointmentObj.setIgnoreConflicts(true);
        appointmentObj.setUid("1234567890abcdefgh");
        int objectId = ResolveUidTest.insertAppointment(this.getWebConversation(), appointmentObj, this.timeZone, "http://" + this.getHostName(), this.getSessionId());
        appointmentObj.setObjectID(objectId);
        int loadId = ResolveUidTest.resolveUid(this.getWebConversation(), "http://" + this.getHostName(), this.getSessionId(), "1234567890abcdefgh");
        ResolveUidTest.assertEquals((String)"Wrong id", (int)objectId, (int)loadId);
        ResolveUidTest.deleteAppointment(this.getWebConversation(), objectId, appointmentFolderId, "http://" + this.getHostName(), this.getSessionId(), false);
    }

    public void testWithoutUid() throws Exception {
        Appointment appointmentObj = new Appointment();
        appointmentObj.setTitle("testSimple");
        appointmentObj.setStartDate(new Date(startTime));
        appointmentObj.setEndDate(new Date(endTime));
        appointmentObj.setShownAs(3);
        appointmentObj.setParentFolderID(appointmentFolderId);
        appointmentObj.setIgnoreConflicts(true);
        int objectId = ResolveUidTest.insertAppointment(this.getWebConversation(), appointmentObj, this.timeZone, "http://" + this.getHostName(), this.getSessionId());
        appointmentObj.setObjectID(objectId);
        Appointment loadAppointment = ResolveUidTest.loadAppointment(this.getWebConversation(), objectId, appointmentFolderId, this.timeZone, "http://" + this.getHostName(), this.getSessionId());
        int loadId = ResolveUidTest.resolveUid(this.getWebConversation(), "http://" + this.getHostName(), this.getSessionId(), loadAppointment.getUid());
        ResolveUidTest.assertEquals((String)"Wrong id", (int)objectId, (int)loadId);
        ResolveUidTest.deleteAppointment(this.getWebConversation(), objectId, appointmentFolderId, "http://" + this.getHostName(), this.getSessionId(), false);
    }

    public void testInsertSameUidTwice() throws Exception {
        Appointment appointmentObj = new Appointment();
        appointmentObj.setTitle("testSimple");
        appointmentObj.setStartDate(new Date(startTime));
        appointmentObj.setEndDate(new Date(endTime));
        appointmentObj.setShownAs(3);
        appointmentObj.setParentFolderID(appointmentFolderId);
        appointmentObj.setIgnoreConflicts(true);
        appointmentObj.setUid("1234567890abcdefgh");
        int objectId = ResolveUidTest.insertAppointment(this.getWebConversation(), appointmentObj, this.timeZone, "http://" + this.getHostName(), this.getSessionId());
        try {
            ResolveUidTest.insertAppointment(this.getWebConversation(), appointmentObj, this.timeZone, "http://" + this.getHostName(), this.getSessionId());
            ResolveUidTest.fail((String)"Exception expected.");
        }
        catch (Exception exception) {
            // empty catch block
        }
        ResolveUidTest.deleteAppointment(this.getWebConversation(), objectId, appointmentFolderId, "http://" + this.getHostName(), this.getSessionId(), false);
    }
}

