/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.subscribe.parser;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.Contact;
import com.openexchange.java.Streams;
import com.openexchange.subscribe.SubscribeService;
import com.openexchange.subscribe.Subscription;
import com.openexchange.subscribe.SubscriptionHandler;
import com.openexchange.subscribe.TargetFolderSession;
import com.openexchange.subscribe.parser.ContactHandler;
import com.openexchange.subscribe.parser.MicroformatContactSAXHandler;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collection;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class MicroformatContactParser
extends ContactHandler
implements SubscriptionHandler {
    protected Collection<Contact> contacts;
    protected SubscribeService service;

    public MicroformatContactParser() {
    }

    public MicroformatContactParser(SubscribeService service) {
        this.service = service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String readSubscription(Subscription subscription) throws IOException {
        BufferedReader buffy = null;
        StringBuilder bob = new StringBuilder();
        try {
            URL url = new URL("");
            URLConnection connection = url.openConnection();
            buffy = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            String line = buffy.readLine();
            while (line != null) {
                bob.append(line);
                bob.append('\n');
                line = buffy.readLine();
            }
        }
        catch (Throwable throwable) {
            Streams.close(buffy);
            throw throwable;
        }
        Streams.close((Closeable)buffy);
        return bob.toString();
    }

    @Override
    public void handleSubscription(Subscription subscription) throws OXException {
        try {
            String website = this.readSubscription(subscription);
            this.parse(website);
            this.storeContacts(new TargetFolderSession(subscription), subscription.getFolderIdAsInt(), this.getContacts());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (OXException e) {
            e.printStackTrace();
        }
    }

    public void parse(String text) {
        XMLReader xmlReader = null;
        try {
            MicroformatContactSAXHandler handler = new MicroformatContactSAXHandler();
            xmlReader = XMLReaderFactory.createXMLReader();
            xmlReader.setContentHandler(handler);
            xmlReader.setErrorHandler(handler);
            xmlReader.parse(new InputSource(new ByteArrayInputStream(text.getBytes())));
            this.contacts = handler.getObjects();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Collection<Contact> getContacts() {
        return this.contacts;
    }
}

