/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.webdav.xml;

import com.openexchange.contact.ContactFieldOperand;
import com.openexchange.contact.ContactService;
import com.openexchange.contact.SortOptions;
import com.openexchange.groupware.contact.helpers.ContactField;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.groupware.search.Order;
import com.openexchange.java.Strings;
import com.openexchange.log.LogFactory;
import com.openexchange.mail.mime.QuotedInternetAddress;
import com.openexchange.search.CompositeSearchTerm;
import com.openexchange.search.SingleSearchTerm;
import com.openexchange.search.internal.operands.ConstantOperand;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.tools.StringCollection;
import com.openexchange.tools.iterator.SearchIterator;
import com.openexchange.webdav.xml.ContactWriter;
import com.openexchange.webdav.xml.XmlServlet;
import java.io.OutputStream;
import java.util.Date;
import java.util.HashSet;
import javax.mail.internet.InternetAddress;
import org.apache.commons.logging.Log;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.output.XMLOutputter;

public class GroupUserWriter
extends ContactWriter {
    protected static final ContactField[] changeFields = new ContactField[]{ContactField.CREATED_BY, ContactField.CREATION_DATE, ContactField.LAST_MODIFIED, ContactField.MODIFIED_BY, ContactField.FOLDER_ID, ContactField.PRIVATE_FLAG, ContactField.CATEGORIES, ContactField.GIVEN_NAME, ContactField.SUR_NAME, ContactField.ANNIVERSARY, ContactField.ASSISTANT_NAME, ContactField.BIRTHDAY, ContactField.BRANCHES, ContactField.BUSINESS_CATEGORY, ContactField.CELLULAR_TELEPHONE1, ContactField.CELLULAR_TELEPHONE2, ContactField.CITY_BUSINESS, ContactField.CITY_HOME, ContactField.CITY_OTHER, ContactField.COMMERCIAL_REGISTER, ContactField.COMPANY, ContactField.COUNTRY_BUSINESS, ContactField.COUNTRY_HOME, ContactField.COUNTRY_OTHER, ContactField.DEPARTMENT, ContactField.DISPLAY_NAME, ContactField.EMAIL1, ContactField.EMAIL2, ContactField.EMAIL3, ContactField.EMPLOYEE_TYPE, ContactField.FAX_BUSINESS, ContactField.FAX_HOME, ContactField.FAX_OTHER, ContactField.FOLDER_ID, ContactField.GIVEN_NAME, ContactField.IMAGE1, ContactField.INFO, ContactField.INSTANT_MESSENGER1, ContactField.INSTANT_MESSENGER2, ContactField.MANAGER_NAME, ContactField.MARITAL_STATUS, ContactField.MIDDLE_NAME, ContactField.NICKNAME, ContactField.NOTE, ContactField.NUMBER_OF_CHILDREN, ContactField.NUMBER_OF_EMPLOYEE, ContactField.POSITION, ContactField.POSTAL_CODE_BUSINESS, ContactField.POSTAL_CODE_HOME, ContactField.POSTAL_CODE_OTHER, ContactField.PRIVATE_FLAG, ContactField.PROFESSION, ContactField.ROOM_NUMBER, ContactField.SALES_VOLUME, ContactField.SPOUSE_NAME, ContactField.STATE_BUSINESS, ContactField.STATE_HOME, ContactField.STATE_OTHER, ContactField.STREET_BUSINESS, ContactField.STREET_HOME, ContactField.STREET_OTHER, ContactField.SUFFIX, ContactField.TAX_ID, ContactField.TELEPHONE_ASSISTANT, ContactField.TELEPHONE_BUSINESS1, ContactField.TELEPHONE_BUSINESS2, ContactField.TELEPHONE_CALLBACK, ContactField.TELEPHONE_CAR, ContactField.TELEPHONE_COMPANY, ContactField.TELEPHONE_HOME1, ContactField.TELEPHONE_HOME2, ContactField.TELEPHONE_IP, ContactField.TELEPHONE_ISDN, ContactField.TELEPHONE_OTHER, ContactField.TELEPHONE_PAGER, ContactField.TELEPHONE_PRIMARY, ContactField.TELEPHONE_RADIO, ContactField.TELEPHONE_TELEX, ContactField.TELEPHONE_TTYTDD, ContactField.TITLE, ContactField.URL, ContactField.USERFIELD01, ContactField.USERFIELD02, ContactField.USERFIELD03, ContactField.USERFIELD04, ContactField.USERFIELD05, ContactField.USERFIELD06, ContactField.USERFIELD07, ContactField.USERFIELD08, ContactField.USERFIELD09, ContactField.USERFIELD10, ContactField.USERFIELD11, ContactField.USERFIELD12, ContactField.USERFIELD13, ContactField.USERFIELD14, ContactField.USERFIELD15, ContactField.USERFIELD16, ContactField.USERFIELD17, ContactField.USERFIELD18, ContactField.USERFIELD19, ContactField.USERFIELD20, ContactField.INTERNAL_USERID};
    protected static final ContactField[] deleteFields = new ContactField[]{ContactField.OBJECT_ID, ContactField.LAST_MODIFIED, ContactField.INTERNAL_USERID};
    protected UserStorage userStorage = null;
    protected Element parent = null;
    private static final Log LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(GroupUserWriter.class));

    public GroupUserWriter(User userObj, Context ctx, Session sessionObj, Element parent) {
        super(userObj, ctx, sessionObj);
        this.parent = parent;
        this.init();
    }

    protected void init() {
        this.userStorage = UserStorage.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startWriter(boolean modified, boolean deleted, Date lastsync, OutputStream os) throws Exception {
        SearchIterator<Contact> it;
        XMLOutputter xo = new XMLOutputter();
        ContactService contactService = ServerServiceRegistry.getInstance().getService(ContactService.class);
        String folderID = Integer.toString(6);
        if (lastsync == null) {
            lastsync = new Date(0L);
        }
        if (deleted) {
            it = null;
            try {
                it = contactService.getDeletedContacts(this.sessionObj, folderID, lastsync, deleteFields);
                this.writeIterator(it, true, xo, os);
            }
            finally {
                if (it != null) {
                    it.close();
                }
            }
        }
        if (modified) {
            it = null;
            try {
                it = contactService.getModifiedContacts(this.sessionObj, folderID, lastsync, changeFields);
                this.writeIterator(it, false, xo, os);
            }
            finally {
                if (it != null) {
                    it.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startWriter(String searchpattern, OutputStream os) throws Exception {
        XMLOutputter xo = new XMLOutputter();
        SearchIterator<Contact> it = null;
        try {
            ContactService contactService = ServerServiceRegistry.getInstance().getService(ContactService.class);
            String preparedPattern = StringCollection.prepareForSearch(searchpattern, false);
            ContactField[] searchFields = new ContactField[]{ContactField.DISPLAY_NAME, ContactField.GIVEN_NAME, ContactField.SUR_NAME, ContactField.EMAIL1, ContactField.EMAIL2, ContactField.EMAIL3, ContactField.CATEGORIES};
            CompositeSearchTerm orTerm = new CompositeSearchTerm(CompositeSearchTerm.CompositeOperation.OR);
            for (ContactField field : searchFields) {
                SingleSearchTerm term = new SingleSearchTerm(SingleSearchTerm.SingleOperation.EQUALS);
                term.addOperand(new ContactFieldOperand(field));
                term.addOperand(new ConstantOperand<String>(preparedPattern));
                orTerm.addSearchTerm(term);
            }
            SingleSearchTerm folderTerm = new SingleSearchTerm(SingleSearchTerm.SingleOperation.EQUALS);
            folderTerm.addOperand(new ContactFieldOperand(ContactField.FOLDER_ID));
            folderTerm.addOperand(new ConstantOperand<String>(Integer.toString(6)));
            CompositeSearchTerm andTerm = new CompositeSearchTerm(CompositeSearchTerm.CompositeOperation.AND);
            andTerm.addSearchTerm(folderTerm);
            andTerm.addSearchTerm(orTerm);
            it = contactService.searchContacts(this.sessionObj, andTerm, changeFields, new SortOptions(ContactField.DISPLAY_NAME, Order.ASCENDING));
            this.writeIterator(it, false, xo, os);
        }
        finally {
            if (it != null) {
                it.close();
            }
        }
    }

    @Override
    public void writeIterator(SearchIterator<Contact> it, boolean delete, XMLOutputter xo, OutputStream os) throws Exception {
        while (it.hasNext()) {
            this.writeObject((Contact)it.next(), delete, xo, os);
        }
    }

    @Override
    public void writeObject(Contact contactobject, boolean delete, XMLOutputter xo, OutputStream os) throws Exception {
        Element e = new Element(this.parent.getName(), this.parent.getNamespace());
        try {
            this.addContent2Element(e, contactobject, delete);
            xo.output(e, os);
            os.flush();
        }
        catch (Exception exc) {
            LOG.error((Object)"writeObject", (Throwable)exc);
        }
    }

    protected void addContent2Element(Element e, Contact contactobject, boolean delete) throws Exception {
        if (delete) {
            int userId = contactobject.getInternalUserId();
            GroupUserWriter.addElement("uid", userId, e);
            GroupUserWriter.addElement("object_id", contactobject.getObjectID(), e);
            GroupUserWriter.addElement("object_status", "DELETE", e);
        } else {
            HashSet<InternetAddress> internalAddresses;
            int userId = contactobject.getInternalUserId();
            User u = this.userStorage.getUser(userId, this.ctx);
            GroupUserWriter.addElement("uid", userId, e);
            GroupUserWriter.addElement("object_id", contactobject.getObjectID(), e);
            GroupUserWriter.addElement("folder_id", 6, e);
            String primaryAddress = u.getMail();
            Element child = GroupUserWriter.addElement("email1", primaryAddress, e);
            child.setAttribute("isInternal", "true");
            String[] aliases = u.getAliases();
            if (null != aliases && aliases.length > 0) {
                internalAddresses = new HashSet(aliases.length + 1);
                internalAddresses.add(new QuotedInternetAddress(primaryAddress));
                for (String alias : aliases) {
                    internalAddresses.add(new QuotedInternetAddress(alias));
                }
            } else {
                internalAddresses = new HashSet<InternetAddress>(1);
                internalAddresses.add(new QuotedInternetAddress(primaryAddress));
            }
            GroupUserWriter.addElement("last_modified", contactobject.getLastModified(), e);
            this.addElementMemberInGroups(e, u);
            if (userId == this.sessionObj.getUserId()) {
                GroupUserWriter.addElement("myidentity", true, e);
                GroupUserWriter.addElement("context_id", this.sessionObj.getContextId(), e);
            }
            this.writeContactElement(contactobject, e, internalAddresses);
        }
    }

    public void addElementMemberInGroups(Element eProp, User u) {
        int[] groupId;
        Element eMemberInGroups = new Element("memberingroups", XmlServlet.NS);
        for (int element : groupId = u.getGroups()) {
            Element eMember = new Element("member", XmlServlet.NS);
            eMember.addContent(Integer.toString(element));
            eMemberInGroups.addContent((Content)eMember);
        }
        eProp.addContent((Content)eMemberInGroups);
    }

    private static void addIfNotEmpty(String name, String value, Element parent) {
        if (GroupUserWriter.isEmpty(value)) {
            return;
        }
        GroupUserWriter.addElement(name, value, parent);
    }

    private static boolean isEmpty(String string) {
        if (null == string) {
            return true;
        }
        int len = string.length();
        boolean isWhitespace = true;
        for (int i = 0; isWhitespace && i < len; ++i) {
            isWhitespace = Strings.isWhitespace((char)string.charAt(i));
        }
        return isWhitespace;
    }
}

