/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.webdav.tools;

import com.openexchange.config.ConfigurationService;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.servlet.http.HttpServletRequest;

public class WebdavWhiteList {
    private static WebdavWhiteList INSTANCE = new WebdavWhiteList();
    private static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(WebdavWhiteList.class));
    private List<Pattern> patterns = Collections.emptyList();

    public static WebdavWhiteList getInstance() {
        return INSTANCE;
    }

    public void init(ConfigurationService config) {
        String[] clientNames = config.getProperty("com.openexchange.webdav.whitelist.clients", "").split("\\s*,\\s*");
        this.patterns = new ArrayList<Pattern>(clientNames.length);
        for (String clientName : clientNames) {
            String key = "com.openexchange.webdav.whitelist." + clientName;
            String patternString = config.getProperty(key);
            LOG.debug((Object)(key + " : " + patternString));
            try {
                if (patternString == null) continue;
                Pattern pattern = Pattern.compile(patternString);
                this.patterns.add(pattern);
            }
            catch (PatternSyntaxException x) {
                LOG.error((Object)("Invalid pattern in " + key + ": " + patternString));
            }
        }
    }

    public boolean acceptClient(HttpServletRequest req) {
        String client = req.getHeader("User-Agent");
        if (client == null) {
            LOG.debug((Object)"No user agent set, so assuming the client is not on the whitelist.");
            return false;
        }
        for (Pattern pattern : this.patterns) {
            boolean result = pattern.matcher(client).find();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Does the pattern " + pattern + " apply to user agent " + client + "? " + result));
            }
            if (!result) continue;
            LOG.debug((Object)("Client " + client + " is accepted by the whitelist."));
            return true;
        }
        LOG.debug((Object)("User-Agent " + client + " didn't match any entry in our whitelist."));
        return false;
    }
}

