/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.versit.old;

import com.openexchange.tools.versit.Property;
import com.openexchange.tools.versit.StringScanner;
import com.openexchange.tools.versit.VersitException;
import com.openexchange.tools.versit.old.OldParamDefinition;
import com.openexchange.tools.versit.old.OldShortPropertyDefinition;
import java.io.IOException;
import java.text.DecimalFormat;

public class OldTZPropertyDefinition
extends OldShortPropertyDefinition {
    private static final DecimalFormat Format = new DecimalFormat("00");

    public OldTZPropertyDefinition(String[] paramNames, OldParamDefinition[] params) {
        super(paramNames, params);
    }

    @Override
    protected Object parseValue(Property property, StringScanner s) throws IOException {
        int sign = 1;
        switch (s.peek) {
            case 45: {
                sign = -1;
            }
            case 43: {
                break;
            }
            default: {
                throw new VersitException(s, "UTC offset expected");
            }
        }
        s.read();
        int offset = s.parseNumber(2) * 3600000;
        if (s.peek != 58) {
            throw new VersitException(s, "UTC offset expected");
        }
        s.read();
        return sign * (offset += s.parseNumber(2) * 60000);
    }

    @Override
    protected String writeValue(Property property, Object value) {
        int offset = (Integer)value;
        return (offset >= 0 ? (char)'+' : '-') + Format.format(offset / 3600000) + Format.format(offset / 60000 % 60);
    }
}

