/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.oxfolder.treeconsistency;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.userconfiguration.UserConfiguration;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import com.openexchange.server.impl.DBPool;
import com.openexchange.server.impl.EffectivePermission;
import com.openexchange.server.impl.OCLPermission;
import com.openexchange.session.Session;
import java.sql.Connection;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;

abstract class CheckPermission {
    protected final Session session;
    protected final int sessionUser;
    protected final Context ctx;
    protected final Connection writeCon;

    protected CheckPermission(Session session, Connection writeCon, Context ctx) {
        this.ctx = ctx;
        this.writeCon = writeCon;
        this.session = session;
        this.sessionUser = session.getUserId();
    }

    protected FolderObject getFolderFromMaster(int folderId) throws OXException {
        return this.getFolderFromMaster(folderId, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FolderObject getFolderFromMaster(int folderId, boolean withSubfolders) throws OXException {
        Connection wc = this.writeCon;
        if (wc == null) {
            try {
                wc = DBPool.pickupWriteable(this.ctx);
                FolderObject folderObject = FolderObject.loadFolderObjectFromDB(folderId, this.ctx, wc, true, withSubfolders);
                return folderObject;
            }
            finally {
                if (wc != null) {
                    DBPool.closeWriterSilent(this.ctx, wc);
                }
            }
        }
        return FolderObject.loadFolderObjectFromDB(folderId, this.ctx, wc, true, withSubfolders);
    }

    protected static EffectivePermission getEffectiveUserPermission(int userId, UserConfiguration userConfig, FolderObject folder, OCLPermission[] permissions) {
        EffectivePermission maxPerm = new EffectivePermission(userId, folder.getObjectID(), folder.getType(userId), folder.getModule(), folder.getCreatedBy(), userConfig);
        maxPerm.setAllPermission(0, 0, 0, 0);
        int[] groups = userConfig.getGroups();
        int[] idArr = new int[groups.length + 1];
        idArr[0] = userId;
        System.arraycopy(groups, 0, idArr, 1, groups.length);
        Arrays.sort(idArr);
        for (int i = 0; i < permissions.length; ++i) {
            OCLPermission oclPerm = permissions[i];
            if (Arrays.binarySearch(idArr, oclPerm.getEntity()) < 0) continue;
            if (oclPerm.getFolderPermission() > maxPerm.getFolderPermission()) {
                maxPerm.setFolderPermission(oclPerm.getFolderPermission());
            }
            if (oclPerm.getReadPermission() > maxPerm.getReadPermission()) {
                maxPerm.setReadObjectPermission(oclPerm.getReadPermission());
            }
            if (oclPerm.getWritePermission() > maxPerm.getWritePermission()) {
                maxPerm.setWriteObjectPermission(oclPerm.getWritePermission());
            }
            if (oclPerm.getDeletePermission() > maxPerm.getDeletePermission()) {
                maxPerm.setDeleteObjectPermission(oclPerm.getDeletePermission());
            }
            if (maxPerm.isFolderAdmin() || !oclPerm.isFolderAdmin()) continue;
            maxPerm.setFolderAdmin(true);
        }
        return maxPerm;
    }

    protected static boolean containsSystemPermission(List<OCLPermission> permissions, int entity) {
        for (OCLPermission cur : permissions) {
            if (cur.getEntity() != entity || !cur.isSystem()) continue;
            return true;
        }
        return false;
    }

    protected void broadcastEvent(int folderId, boolean deleted, EventAdmin eventAdmin) {
        if (null != eventAdmin) {
            Hashtable<String, Object> properties = new Hashtable<String, Object>(6);
            ((Dictionary)properties).put("com.openexchange.folderstorage.context", this.session.getContextId());
            ((Dictionary)properties).put("com.openexchange.folderstorage.user", this.session.getUserId());
            ((Dictionary)properties).put("com.openexchange.folderstorage.session", this.session);
            ((Dictionary)properties).put("com.openexchange.folderstorage.folder", String.valueOf(folderId));
            ((Dictionary)properties).put("com.openexchange.folderstorage.content-related", !deleted);
            Event event = new Event("com/openexchange/folderstorage", properties);
            eventAdmin.sendEvent(event);
            org.apache.commons.logging.Log logger = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(CheckPermission.class));
            if (logger.isDebugEnabled()) {
                logger.debug((Object)new StringBuilder(64).append("Notified ").append("content-related").append("-wise changed folder \"").append(folderId).append(" in context ").append(this.session.getContextId()).toString());
            }
        }
    }
}

