/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.oxfolder.memory;

import com.javacodegeeks.concurrent.ConcurrentLinkedHashMap;
import com.javacodegeeks.concurrent.EvictionPolicy;

public final class ExpirationPolicy
implements EvictionPolicy {
    private static final Checker DUMMY_CHECKER = new Checker(){

        @Override
        public boolean check(ConcurrentLinkedHashMap.Entry<?, ?> accessedEntry, long now) {
            return true;
        }
    };
    private final Checker ageChecker;
    private final Checker idleChecker;

    public ExpirationPolicy(long ageThresholdMillis, long idleTimeThresholdMillis) {
        this.ageChecker = ageThresholdMillis <= 0L ? DUMMY_CHECKER : new AgeChecker(ageThresholdMillis);
        this.idleChecker = idleTimeThresholdMillis <= 0L ? DUMMY_CHECKER : new IdleChecker(idleTimeThresholdMillis);
    }

    public boolean accessOrder() {
        return true;
    }

    public boolean insertionOrder() {
        return false;
    }

    public ConcurrentLinkedHashMap.Entry<?, ?> evictElement(ConcurrentLinkedHashMap.Entry<?, ?> head) {
        return head.getAfter();
    }

    public ConcurrentLinkedHashMap.Entry<?, ?> recordInsertion(ConcurrentLinkedHashMap.Entry<?, ?> head, ConcurrentLinkedHashMap.Entry<?, ?> insertedEntry) {
        return null;
    }

    public ConcurrentLinkedHashMap.Entry<?, ?> recordAccess(ConcurrentLinkedHashMap.Entry<?, ?> head, ConcurrentLinkedHashMap.Entry<?, ?> accessedEntry) {
        long now = System.currentTimeMillis();
        if (this.idleChecker.check(accessedEntry, now) && this.ageChecker.check(accessedEntry, now)) {
            return head;
        }
        return accessedEntry.getAfter();
    }

    private static final class IdleChecker
    implements Checker {
        private final long idleTimeThresholdMillis;

        protected IdleChecker(long idleTimeThresholdMillis) {
            this.idleTimeThresholdMillis = idleTimeThresholdMillis;
        }

        @Override
        public boolean check(ConcurrentLinkedHashMap.Entry<?, ?> accessedEntry, long now) {
            long accessedEntryIdleTime = now - accessedEntry.getLastAccessTime();
            return accessedEntryIdleTime < this.idleTimeThresholdMillis;
        }
    }

    private static final class AgeChecker
    implements Checker {
        private final long ageThresholdMillis;

        protected AgeChecker(long ageThresholdMillis) {
            this.ageThresholdMillis = ageThresholdMillis;
        }

        @Override
        public boolean check(ConcurrentLinkedHashMap.Entry<?, ?> accessedEntry, long now) {
            long accessedEntryAge = now - accessedEntry.getCreationTime();
            return accessedEntryAge < this.ageThresholdMillis;
        }
    }

    private static interface Checker {
        public boolean check(ConcurrentLinkedHashMap.Entry<?, ?> var1, long var2);
    }
}

