/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.file.internal;

import com.openexchange.database.DatabaseService;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.tools.file.external.FileStorageFactory;
import com.openexchange.tools.file.external.QuotaFileStorage;
import com.openexchange.tools.file.external.QuotaFileStorageExceptionCodes;
import com.openexchange.tools.file.external.QuotaFileStorageFactory;
import com.openexchange.tools.file.internal.DBQuotaFileStorage;
import java.net.URI;

public class DBQuotaFileStorageFactory
implements QuotaFileStorageFactory {
    private final FileStorageFactory fss;
    private final DatabaseService dbs;

    public DBQuotaFileStorageFactory(DatabaseService dbs, FileStorageFactory fss) {
        this.fss = fss;
        this.dbs = dbs;
    }

    @Override
    public QuotaFileStorage getQuotaFileStorage(Context ctx, URI uri) throws OXException {
        if (this.fss == null || this.dbs == null) {
            throw QuotaFileStorageExceptionCodes.INSTANTIATIONERROR.create();
        }
        return new DBQuotaFileStorage(ctx, this.fss.getFileStorage(uri), this.dbs);
    }
}

