/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.sessiond.impl;

import com.openexchange.java.Autoboxing;
import com.openexchange.java.Strings;
import com.openexchange.sessiond.impl.IPAddressUtil;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.commons.lang.math.LongRange;
import org.apache.commons.lang.math.Range;

public class IPRange {
    private final Range ipv4Range;
    private final Range ipv6Range;

    public IPRange(Range ipv4Range, Range ipv6Range) {
        this.ipv4Range = ipv4Range;
        this.ipv6Range = ipv6Range;
    }

    public Range getIpv4Range() {
        return this.ipv4Range;
    }

    public Range getIpv6Range() {
        return this.ipv6Range;
    }

    public boolean contains(String ipAddress) {
        byte[] octets = IPAddressUtil.textToNumericFormatV4(ipAddress);
        if (null != octets) {
            return null != this.ipv4Range && this.ipv4Range.containsLong(IPRange.ipToLong(octets));
        }
        octets = IPAddressUtil.textToNumericFormatV6(ipAddress);
        if (null == octets) {
            throw new IllegalArgumentException("Not an IP address: " + ipAddress);
        }
        return null != this.ipv6Range && this.ipv6Range.containsNumber((Number)IPRange.ipToBigInteger(octets));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (null != this.ipv4Range) {
            for (int n : IPRange.longToIP(this.ipv4Range.getMinimumLong())) {
                sb.append(n < 0 ? 256 + n : n);
                sb.append('.');
            }
            sb.setCharAt(sb.length() - 1, '-');
            for (int n : IPRange.longToIP(this.ipv4Range.getMaximumLong())) {
                sb.append(n < 0 ? 256 + n : n);
                sb.append('.');
            }
            sb.setLength(sb.length() - 1);
        }
        if (null != this.ipv6Range) {
            for (int n : IPRange.longToIP(this.ipv6Range.getMinimumLong())) {
                sb.append(n < 0 ? 256 + n : n);
                sb.append('.');
            }
            sb.setCharAt(sb.length() - 1, '-');
            for (int n : IPRange.longToIP(this.ipv6Range.getMaximumLong())) {
                sb.append(n < 0 ? 256 + n : n);
                sb.append('.');
            }
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    public static IPRange parseRange(String string) {
        if (IPRange.isEmpty(string)) {
            return null;
        }
        if (string.indexOf(45) > 0) {
            String[] addresses = string.split("\\s*-\\s*");
            byte[] octetsStart = IPAddressUtil.textToNumericFormatV4(addresses[0]);
            if (null == octetsStart) {
                octetsStart = IPAddressUtil.textToNumericFormatV6(addresses[0]);
                if (null == octetsStart) {
                    throw new IllegalArgumentException("Not an IP address range: " + string);
                }
                byte[] octetsEnd = IPAddressUtil.textToNumericFormatV6(addresses[1]);
                if (null == octetsEnd) {
                    throw new IllegalArgumentException("Not an IPv6 address: " + addresses[1]);
                }
                LongRange ipv6Range = new LongRange((Number)IPRange.ipToBigInteger(octetsStart), (Number)IPRange.ipToBigInteger(octetsEnd));
                return new IPRange(null, (Range)ipv6Range);
            }
            byte[] octetsEnd = IPAddressUtil.textToNumericFormatV4(addresses[1]);
            if (null == octetsEnd) {
                throw new IllegalArgumentException("Not an IPv4 address: " + addresses[1]);
            }
            LongRange ipv4Range = new LongRange(IPRange.ipToLong(octetsStart), IPRange.ipToLong(octetsEnd));
            return new IPRange((Range)ipv4Range, null);
        }
        byte[] octets = IPAddressUtil.textToNumericFormatV4(string);
        if (null == octets) {
            int i;
            octets = IPAddressUtil.textToNumericFormatV6(string);
            if (null == octets) {
                throw new IllegalArgumentException("Not an IP address: " + string);
            }
            byte[] octetsEnd = new byte[16];
            boolean bool = true;
            for (i = 0; bool && i < octetsEnd.length; ++i) {
                boolean bl = bool = octets[i] == 0;
                if (bool) continue;
                octetsEnd[i] = octets[i];
            }
            while (i < octetsEnd.length) {
                octetsEnd[i++] = -1;
            }
            return new IPRange(null, (Range)new LongRange((Number)IPRange.ipToBigInteger(octets), (Number)IPRange.ipToBigInteger(octetsEnd)));
        }
        return new IPRange((Range)new LongRange(IPRange.ipToLong(octets), IPRange.ipToLong(octets)), null);
    }

    private static long ipToLong(byte[] octets) {
        long result = 0L;
        for (int i = 0; i < octets.length; ++i) {
            result |= (long)(octets[i] & 0xFF);
            if (i >= octets.length - 1) continue;
            result <<= 8;
        }
        return result;
    }

    private static BigInteger ipToBigInteger(byte[] octets) {
        BigInteger result = BigInteger.ZERO;
        for (int i = 0; i < octets.length; ++i) {
            result = result.or(BigInteger.valueOf(octets[i]).and(BigInteger.valueOf(255L)));
            if (i >= octets.length - 1) continue;
            result = result.shiftLeft(8);
        }
        return result;
    }

    private static byte[] longToIP(long value) {
        ArrayList<Byte> retval = new ArrayList<Byte>();
        while (value != 0L) {
            retval.add((byte)(value & 0xFFL));
            value >>= 8;
        }
        Collections.reverse(retval);
        return Autoboxing.B2b(retval);
    }

    private static boolean isEmpty(String string) {
        if (null == string) {
            return true;
        }
        int len = string.length();
        boolean isWhitespace = true;
        for (int i = 0; isWhitespace && i < len; ++i) {
            isWhitespace = Strings.isWhitespace((char)string.charAt(i));
        }
        return isWhitespace;
    }
}

