/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.sessiond.impl;

import java.util.regex.Pattern;

public final class IPAddressUtil {
    private static final Pattern SPLIT = Pattern.compile("\\.");
    private static final int INADDR4SZ = 4;
    private static final int INADDR16SZ = 16;
    private static final int INT16SZ = 2;

    public static byte[] textToNumericFormatV4(String src) {
        if (src.length() == 0) {
            return null;
        }
        byte[] res = new byte[4];
        String[] s = src.split("\\.", -1);
        try {
            switch (s.length) {
                case 1: {
                    long val = Long.parseLong(s[0]);
                    if (val < 0L || val > 0xFFFFFFFFL) {
                        return null;
                    }
                    res[0] = (byte)(val >> 24 & 0xFFL);
                    res[1] = (byte)((val & 0xFFFFFFL) >> 16 & 0xFFL);
                    res[2] = (byte)((val & 0xFFFFL) >> 8 & 0xFFL);
                    res[3] = (byte)(val & 0xFFL);
                    break;
                }
                case 2: {
                    long val = Integer.parseInt(s[0]);
                    if (val < 0L || val > 255L) {
                        return null;
                    }
                    res[0] = (byte)(val & 0xFFL);
                    val = Integer.parseInt(s[1]);
                    if (val < 0L || val > 0xFFFFFFL) {
                        return null;
                    }
                    res[1] = (byte)(val >> 16 & 0xFFL);
                    res[2] = (byte)((val & 0xFFFFL) >> 8 & 0xFFL);
                    res[3] = (byte)(val & 0xFFL);
                    break;
                }
                case 3: {
                    long val;
                    for (int i = 0; i < 2; ++i) {
                        val = Integer.parseInt(s[i]);
                        if (val < 0L || val > 255L) {
                            return null;
                        }
                        res[i] = (byte)(val & 0xFFL);
                    }
                    val = Integer.parseInt(s[2]);
                    if (val < 0L || val > 65535L) {
                        return null;
                    }
                    res[2] = (byte)(val >> 8 & 0xFFL);
                    res[3] = (byte)(val & 0xFFL);
                    break;
                }
                case 4: {
                    for (int i = 0; i < 4; ++i) {
                        long val = Integer.parseInt(s[i]);
                        if (val < 0L || val > 255L) {
                            return null;
                        }
                        res[i] = (byte)(val & 0xFFL);
                    }
                    break;
                }
                default: {
                    return null;
                }
            }
        }
        catch (NumberFormatException e) {
            return null;
        }
        return res;
    }

    public static byte[] textToNumericFormatV6(String src) {
        if (src.length() < 2) {
            return null;
        }
        byte[] dst = new byte[16];
        int srcb_length = src.length();
        int pc = src.indexOf(37);
        if (pc == srcb_length - 1) {
            return null;
        }
        if (pc != -1) {
            srcb_length = pc;
        }
        int colonp = -1;
        int i = 0;
        int j = 0;
        if (src.charAt(i) == ':' && src.charAt(++i) != ':') {
            return null;
        }
        int curtok = i;
        boolean saw_xdigit = false;
        int val = 0;
        while (i < srcb_length) {
            char ch;
            int chval;
            if ((chval = Character.digit(ch = src.charAt(i++), 16)) != -1) {
                val <<= 4;
                if ((val |= chval) > 65535) {
                    return null;
                }
                saw_xdigit = true;
                continue;
            }
            if (ch == ':') {
                curtok = i;
                if (!saw_xdigit) {
                    if (colonp != -1) {
                        return null;
                    }
                    colonp = j;
                    continue;
                }
                if (i == srcb_length) {
                    return null;
                }
                if (j + 2 > 16) {
                    return null;
                }
                dst[j++] = (byte)(val >> 8 & 0xFF);
                dst[j++] = (byte)(val & 0xFF);
                saw_xdigit = false;
                val = 0;
                continue;
            }
            if (ch == '.' && j + 4 <= 16) {
                String ia4 = src.substring(curtok, srcb_length);
                int dot_count = 0;
                int index = 0;
                while ((index = ia4.indexOf(46, index)) != -1) {
                    ++dot_count;
                    ++index;
                }
                if (dot_count != 3) {
                    return null;
                }
                byte[] v4addr = IPAddressUtil.textToNumericFormatV4(ia4);
                if (v4addr == null) {
                    return null;
                }
                for (int k = 0; k < 4; ++k) {
                    dst[j++] = v4addr[k];
                }
                saw_xdigit = false;
                break;
            }
            return null;
        }
        if (saw_xdigit) {
            if (j + 2 > 16) {
                return null;
            }
            dst[j++] = (byte)(val >> 8 & 0xFF);
            dst[j++] = (byte)(val & 0xFF);
        }
        if (colonp != -1) {
            int n = j - colonp;
            if (j == 16) {
                return null;
            }
            for (i = 1; i <= n; ++i) {
                dst[16 - i] = dst[colonp + n - i];
                dst[colonp + n - i] = 0;
            }
            j = 16;
        }
        if (j != 16) {
            return null;
        }
        byte[] newdst = IPAddressUtil.convertFromIPv4MappedAddress(dst);
        if (newdst == null) {
            return dst;
        }
        return newdst;
    }

    public static boolean isIPv4LiteralAddress(String src) {
        return IPAddressUtil.textToNumericFormatV4(src) != null;
    }

    public static boolean isIPv6LiteralAddress(String src) {
        return IPAddressUtil.textToNumericFormatV6(src) != null;
    }

    public static byte[] convertFromIPv4MappedAddress(byte[] addr) {
        if (IPAddressUtil.isIPv4MappedAddress(addr)) {
            byte[] newAddr = new byte[4];
            System.arraycopy(addr, 12, newAddr, 0, 4);
            return newAddr;
        }
        return null;
    }

    public static byte[] convertIPv4ToMappedIPv6(String ipv4) {
        String[] octets = SPLIT.split(ipv4, 0);
        if (octets.length != 4) {
            return null;
        }
        byte[] octetBytes = new byte[4];
        for (int i = 0; i < 4; ++i) {
            octetBytes[i] = (byte)Integer.parseInt(octets[i]);
        }
        return IPAddressUtil.convertIPv4ToMappedIPv6(octetBytes);
    }

    public static byte[] convertIPv4ToMappedIPv6(byte[] octets) {
        if (octets.length != 4) {
            return null;
        }
        byte[] ipv4asIpV6addr = new byte[16];
        ipv4asIpV6addr[10] = -1;
        ipv4asIpV6addr[11] = -1;
        ipv4asIpV6addr[12] = octets[0];
        ipv4asIpV6addr[13] = octets[1];
        ipv4asIpV6addr[14] = octets[2];
        ipv4asIpV6addr[15] = octets[3];
        return ipv4asIpV6addr;
    }

    private static boolean isIPv4MappedAddress(byte[] addr) {
        if (addr.length < 16) {
            return false;
        }
        return addr[0] == 0 && addr[1] == 0 && addr[2] == 0 && addr[3] == 0 && addr[4] == 0 && addr[5] == 0 && addr[6] == 0 && addr[7] == 0 && addr[8] == 0 && addr[9] == 0 && addr[10] == -1 && addr[11] == -1;
    }
}

