/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.resource.internal;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.impl.IDGenerator;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.userconfiguration.UserConfigurationStorage;
import com.openexchange.java.Strings;
import com.openexchange.log.LogFactory;
import com.openexchange.resource.Resource;
import com.openexchange.resource.ResourceExceptionCode;
import com.openexchange.resource.internal.ResourceTools;
import com.openexchange.resource.storage.ResourceStorage;
import com.openexchange.server.impl.DBPool;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.tools.sql.DBUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Dictionary;
import java.util.Hashtable;
import org.apache.commons.logging.Log;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;

public final class ResourceCreate {
    private static final Log LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(ResourceCreate.class));
    private final User user;
    private final Context ctx;
    private final Resource resource;
    private final ResourceStorage storage;

    ResourceCreate(User user, Context ctx, Resource resource) {
        this.user = user;
        this.ctx = ctx;
        this.resource = resource;
        this.storage = ResourceStorage.getInstance();
    }

    void perform() throws OXException {
        this.allow();
        this.check();
        this.insert();
        this.propagate();
        this.sentEvent();
    }

    private void allow() throws OXException {
        if (!UserConfigurationStorage.getInstance().getUserConfiguration(this.user.getId(), this.ctx).isEditResource()) {
            throw ResourceExceptionCode.PERMISSION.create(this.ctx.getContextId());
        }
    }

    private void check() throws OXException {
        if (null == this.resource) {
            throw ResourceExceptionCode.NULL.create();
        }
        if (ResourceCreate.isEmpty(this.resource.getSimpleName()) || ResourceCreate.isEmpty(this.resource.getDisplayName()) || ResourceCreate.isEmpty(this.resource.getMail())) {
            throw ResourceExceptionCode.MANDATORY_FIELD.create();
        }
        if (!ResourceTools.validateResourceIdentifier(this.resource.getSimpleName())) {
            throw ResourceExceptionCode.INVALID_RESOURCE_IDENTIFIER.create(this.resource.getSimpleName());
        }
        if (!ResourceTools.validateResourceEmail(this.resource.getMail())) {
            throw ResourceExceptionCode.INVALID_RESOURCE_MAIL.create(this.resource.getMail());
        }
        if (this.storage.searchResources(this.resource.getSimpleName(), this.ctx).length > 0) {
            throw ResourceExceptionCode.RESOURCE_CONFLICT.create(this.resource.getSimpleName());
        }
        if (this.storage.searchResourcesByMail(this.resource.getMail(), this.ctx).length > 0) {
            throw ResourceExceptionCode.RESOURCE_CONFLICT_MAIL.create(this.resource.getMail());
        }
    }

    private void insert() throws OXException {
        Connection con = DBPool.pickupWriteable(this.ctx);
        try {
            con.setAutoCommit(false);
            this.insert(con);
            con.commit();
        }
        catch (SQLException e) {
            DBUtils.rollback(con);
            throw ResourceExceptionCode.SQL_ERROR.create(e, new Object[0]);
        }
        finally {
            try {
                con.setAutoCommit(true);
            }
            catch (SQLException e) {
                LOG.error((Object)"Problem setting autocommit to true.", (Throwable)e);
            }
            DBPool.closeWriterSilent(this.ctx, con);
        }
    }

    private void propagate() {
    }

    void insert(Connection con) throws OXException {
        try {
            int id = IDGenerator.getId(this.ctx.getContextId(), 130, con);
            this.resource.setIdentifier(id);
            this.storage.insertResource(this.ctx, con, this.resource);
        }
        catch (SQLException e) {
            throw ResourceExceptionCode.SQL_ERROR.create(e, new Object[0]);
        }
    }

    private static boolean isEmpty(String string) {
        if (null == string) {
            return true;
        }
        int len = string.length();
        boolean isWhitespace = true;
        for (int i = 0; isWhitespace && i < len; ++i) {
            isWhitespace = Strings.isWhitespace((char)string.charAt(i));
        }
        return isWhitespace;
    }

    private void sentEvent() {
        EventAdmin eventAdmin = ServerServiceRegistry.getInstance().getService(EventAdmin.class);
        if (null != eventAdmin) {
            Hashtable<String, Integer> dict = new Hashtable<String, Integer>(4);
            ((Dictionary)dict).put("contextId", this.ctx.getContextId());
            ((Dictionary)dict).put("userId", this.user.getId());
            ((Dictionary)dict).put("resourceId", this.resource.getIdentifier());
            eventAdmin.postEvent(new Event("com/openexchange/groupware/resource/insert", dict));
        }
    }
}

