/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.resource;

import com.openexchange.exception.Category;
import com.openexchange.exception.OXException;
import com.openexchange.exception.OXExceptionCode;
import com.openexchange.exception.OXExceptionFactory;

public enum ResourceExceptionCode implements OXExceptionCode
{
    NO_CONNECTION("Cannot get database connection.", Category.CATEGORY_SERVICE_DOWN, 1),
    SQL_ERROR("SQL problem: \"%1$s\"", Category.CATEGORY_ERROR, 2),
    RESOURCEGROUP_NOT_FOUND("Cannot find resource group with identifier %1$d.", Category.CATEGORY_USER_INPUT, 3),
    RESOURCEGROUP_CONFLICT("Found resource groups with same identifier %1$d.", Category.CATEGORY_USER_INPUT, 4),
    RESOURCE_NOT_FOUND("Cannot find resource with identifier %1$d.", Category.CATEGORY_USER_INPUT, 5),
    RESOURCE_CONFLICT("Found resource(s) with same identifier %1$s.", Category.CATEGORY_USER_INPUT, 6),
    NULL("No resource given.", Category.CATEGORY_USER_INPUT, 7),
    MANDATORY_FIELD("Missing mandatory field(s) in given resource.", Category.CATEGORY_ERROR, 8),
    PERMISSION("No permission to modify resources in context %1$s", Category.CATEGORY_PERMISSION_DENIED, 9),
    RESOURCE_CONFLICT_MAIL("Found resource(s) with same email address %1$s.", Category.CATEGORY_ERROR, 10),
    INVALID_RESOURCE_IDENTIFIER("Invalid resource identifier: %1$s", Category.CATEGORY_USER_INPUT, 11),
    INVALID_RESOURCE_MAIL("Invalid resource E-Mail address: %1$s", Category.CATEGORY_USER_INPUT, 12),
    CONCURRENT_MODIFICATION("The resource has been changed in the meantime", Category.CATEGORY_CONFLICT, 13);

    final String message;
    final Category category;
    final int detailNumber;

    private ResourceExceptionCode(String message, Category category, int detailNumber) {
        this.message = message;
        this.category = category;
        this.detailNumber = detailNumber;
    }

    public Category getCategory() {
        return this.category;
    }

    public String getPrefix() {
        return "RES";
    }

    public int getNumber() {
        return this.detailNumber;
    }

    public String getMessage() {
        return this.message;
    }

    public boolean equals(OXException e) {
        return OXExceptionFactory.getInstance().equals((OXExceptionCode)this, e);
    }

    public OXException create() {
        return OXExceptionFactory.getInstance().create((OXExceptionCode)this, new Object[0]);
    }

    public OXException create(Object ... args) {
        return OXExceptionFactory.getInstance().create((OXExceptionCode)this, (Throwable)null, args);
    }

    public OXException create(Throwable cause, Object ... args) {
        return OXExceptionFactory.getInstance().create((OXExceptionCode)this, cause, args);
    }
}

