/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.mime;

import com.openexchange.exception.Category;
import com.openexchange.exception.LogLevel;
import com.openexchange.exception.OXException;
import com.openexchange.exception.OXExceptionCode;
import com.openexchange.exception.OXExceptionFactory;
import com.openexchange.java.StringAllocator;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.mail.mime.MimeMailException;
import com.openexchange.mail.mime.MimeMailExceptionMessage;

public enum MimeMailExceptionCode implements OXExceptionCode
{
    LOGIN_FAILED("There was an issue in authenticating your E-Mail password. This may be due to a recent password change. To continue please log out now and then log back in with your most current password. (server=%1$s | user=%2$s)", CATEGORY_PERMISSION_DENIED, 1000),
    INVALID_CREDENTIALS("Wrong or missing login data to access mail server %1$s. Error message from mail server: %2$s", CATEGORY_PERMISSION_DENIED, 1001),
    INVALID_CREDENTIALS_EXT("Wrong or missing login data to access mail server %1$s with login %2$s (user=%3$s, context=%4$s). Error message from mail server: %5$s", CATEGORY_PERMISSION_DENIED, MimeMailExceptionCode.INVALID_CREDENTIALS.detailNumber),
    FOLDER_NOT_FOUND("Mail folder \"%1$s\" could not be found.", CATEGORY_USER_INPUT, 1002),
    FOLDER_NOT_FOUND_EXT("Mail folder \"%1$s\" could not be found on mail server %2$s with login %3$s (user=%4$s, context=%5$s).", CATEGORY_USER_INPUT, MimeMailExceptionCode.FOLDER_NOT_FOUND.detailNumber),
    FOLDER_CLOSED(MimeMailExceptionMessage.FOLDER_CLOSED_MSG, CATEGORY_USER_INPUT, 1003, LogLevel.ERROR),
    FOLDER_CLOSED_EXT(MimeMailExceptionMessage.FOLDER_CLOSED_EXT_MSG, CATEGORY_USER_INPUT, MimeMailExceptionCode.FOLDER_CLOSED.detailNumber, LogLevel.ERROR),
    ILLEGAL_WRITE("Illegal write attempt: %1$s", CATEGORY_ERROR, 1004),
    MESSAGE_REMOVED(MimeMailExceptionMessage.MESSAGE_REMOVED, MailExceptionCode.MAIL_NOT_FOUND.getCategory(), MailExceptionCode.MAIL_NOT_FOUND.getNumber()),
    METHOD_NOT_SUPPORTED("Method not supported: %1$s", CATEGORY_ERROR, 1006),
    NO_SUCH_PROVIDER("Session attempts to instantiate a provider that does not exist: %1$s", CATEGORY_ERROR, 1007),
    INVALID_EMAIL_ADDRESS("Invalid E-Mail address %1$s", CATEGORY_USER_INPUT, 1008, LogLevel.ERROR),
    PARSE_ERROR("Wrong message header: %1$s", CATEGORY_USER_INPUT, 1009, LogLevel.ERROR),
    READ_ONLY_FOLDER("An attempt was made to open a read-only folder with read-write \"%1$s\"", CATEGORY_PERMISSION_DENIED, 1010),
    READ_ONLY_FOLDER_EXT("An attempt was made to open a read-only folder with read-write \"%1$s\" on mail server %2$s with login %3$s (user=%4$s, context=%5$s)", CATEGORY_PERMISSION_DENIED, 1010),
    SEARCH_ERROR("Invalid search expression: %1$s", CATEGORY_USER_INPUT, 1011, LogLevel.ERROR),
    MESSAGE_TOO_LARGE("Message could not be sent because it is too large", CATEGORY_USER_INPUT, 1012, LogLevel.ERROR),
    SEND_FAILED("Message could not be sent to the following recipients: %1$s", CATEGORY_USER_INPUT, 1013, LogLevel.ERROR),
    SEND_FAILED_EXT("Message could not be sent to the following recipients: %1$s %2$s", CATEGORY_USER_INPUT, 1013, LogLevel.ERROR),
    STORE_CLOSED("Lost connection to mail server.", CATEGORY_SERVICE_DOWN, 1014),
    STORE_CLOSED_EXT("Connection closed to mail server %1$s with login %2$s (user=%3$s, context=%4$s).", MimeMailExceptionCode.STORE_CLOSED.category, MimeMailExceptionCode.STORE_CLOSED.detailNumber),
    BIND_ERROR("Could not bind connection to local port %1$s", CATEGORY_CONFIGURATION, 1015),
    CONNECT_ERROR("Connection was refused or timed out while attempting to connect to remote server %1$s for user %2$s.", CATEGORY_SERVICE_DOWN, 1016),
    CONNECTION_RESET("Connection was reset. Please try again.", CATEGORY_TRY_AGAIN, 1017),
    NO_ROUTE_TO_HOST("No route to host: server (%1$s) cannot be reached", CATEGORY_SERVICE_DOWN, 1018),
    PORT_UNREACHABLE("Port %1$s was unreachable on remote server", CATEGORY_SERVICE_DOWN, 1019),
    BROKEN_CONNECTION("Connection is broken due to a socket exception on remote server: %1$s", CATEGORY_SERVICE_DOWN, 1020),
    SOCKET_ERROR("A socket error occurred: %1$s", CATEGORY_ERROR, 1021),
    UNKNOWN_HOST("The IP address of host \"%1$s\" could not be determined", CATEGORY_SERVICE_DOWN, 1022),
    MESSAGING_ERROR("Messaging error: %1$s", CATEGORY_ERROR, 1023),
    QUOTA_EXCEEDED("The quota on mail server exceeded. Error message: %1$s", CATEGORY_CAPACITY, 1024, LogLevel.ERROR),
    QUOTA_EXCEEDED_EXT("The quota on mail server \"%1$s\" exceeded with login %2$s (user=%3$s, context=%4$s). Error message: %5$s", MimeMailExceptionCode.QUOTA_EXCEEDED.category, MimeMailExceptionCode.QUOTA_EXCEEDED.detailNumber, LogLevel.ERROR),
    COMMAND_FAILED("A command to mail server failed. Server response: %1$s.", CATEGORY_ERROR, 1025),
    COMMAND_FAILED_EXT("A command failed on mail server %1$s with login %2$s (user=%3$s, context=%4$s). Server response: %5$s", MimeMailExceptionCode.COMMAND_FAILED.category, MimeMailExceptionCode.COMMAND_FAILED.detailNumber),
    BAD_COMMAND("Mail server indicates a bad command. Server response: %1$s", CATEGORY_ERROR, 1026),
    BAD_COMMAND_EXT("Bad command indicated by mail server %1$s with login %2$s (user=%3$s, context=%4$s). Server response: %5$s", MimeMailExceptionCode.BAD_COMMAND.category, MimeMailExceptionCode.BAD_COMMAND.detailNumber),
    PROTOCOL_ERROR("Error in mail server protocol. Error message: %1$s", CATEGORY_ERROR, 1027),
    PROTOCOL_ERROR_EXT("Error in protocol to mail server %1$s with login %2$s (user=%3$s, context=%4$s). Error message: %5$s", MimeMailExceptionCode.PROTOCOL_ERROR.category, MimeMailExceptionCode.PROTOCOL_ERROR.detailNumber),
    SEND_FAILED_MSG("Message could not be sent to the following recipients: %1$s", CATEGORY_USER_INPUT, 1028, LogLevel.ERROR),
    SEND_FAILED_MSG_EXT("Message could not be sent to the following recipients: %1$s %2$s", CATEGORY_USER_INPUT, 1028, LogLevel.ERROR),
    MESSAGE_NOT_DISPLAYED("Message cannot be displayed.", CATEGORY_USER_INPUT, 1029, LogLevel.ERROR),
    TRANSPORT_INVALID_CREDENTIALS("Wrong or missing login data to access mail transport server %1$s. Error message from mail transport server: %2$s", CATEGORY_PERMISSION_DENIED, 1030),
    TRANSPORT_INVALID_CREDENTIALS_EXT("Wrong or missing login data to access mail transport server %1$s with login %2$s (user=%3$s, context=%4$s). Error message from mail transport server: %5$s", CATEGORY_PERMISSION_DENIED, MimeMailExceptionCode.TRANSPORT_INVALID_CREDENTIALS.detailNumber),
    PROCESSING_ERROR("Error processing mail server response. The administrator has been informed.", CATEGORY_USER_INPUT, 1031, LogLevel.ERROR),
    PROCESSING_ERROR_EXT("Error processing %1$s mail server response for login %2$s (user=%3$s, context=%4$s). The administrator has been informed.", CATEGORY_USER_INPUT, MimeMailExceptionCode.PROCESSING_ERROR.detailNumber, LogLevel.ERROR),
    IO_ERROR(MailExceptionCode.IO_ERROR, LogLevel.ERROR),
    IO_ERROR_EXT(MailExceptionCode.IO_ERROR, "I/O error \"%1$s\" occurred in communication with \"%2$s\" mail server for login %3$s (user=%4$s, context=%5$s).", LogLevel.ERROR),
    PROCESSING_ERROR_WE("Error processing mail server response. The administrator has been informed. Error message: %1$s", CATEGORY_ERROR, MimeMailExceptionCode.PROCESSING_ERROR.detailNumber, LogLevel.ERROR),
    PROCESSING_ERROR_WE_EXT("Error processing %1$s mail server response for login %2$s (user=%3$s, context=%4$s). The administrator has been informed. Error message: %5$s", CATEGORY_ERROR, MimeMailExceptionCode.PROCESSING_ERROR_WE.detailNumber, LogLevel.ERROR),
    IN_USE_ERROR(MimeMailExceptionMessage.IN_USE_ERROR_MSG, CATEGORY_USER_INPUT, MimeMailExceptionCode.PROCESSING_ERROR.detailNumber, LogLevel.ERROR),
    IN_USE_ERROR_EXT(MimeMailExceptionMessage.IN_USE_ERROR_EXT_MSG, CATEGORY_USER_INPUT, MimeMailExceptionCode.PROCESSING_ERROR.detailNumber, LogLevel.ERROR);

    private final String message;
    private final int detailNumber;
    private final Category category;
    private final LogLevel logLevel;

    private MimeMailExceptionCode(String message, Category category, int detailNumber, LogLevel logLevel) {
        this.message = message;
        this.detailNumber = detailNumber;
        this.category = category;
        this.logLevel = logLevel;
    }

    private MimeMailExceptionCode(String message, Category category, int detailNumber) {
        this.message = message;
        this.detailNumber = detailNumber;
        this.category = category;
        this.logLevel = null;
    }

    private MimeMailExceptionCode(MailExceptionCode code, String message, LogLevel logLevel) {
        this.message = message;
        this.detailNumber = code.getNumber();
        this.category = code.getCategory();
        this.logLevel = logLevel;
    }

    private MimeMailExceptionCode(MailExceptionCode code, LogLevel logLevel) {
        this.message = code.getMessage();
        this.detailNumber = code.getNumber();
        this.category = code.getCategory();
        this.logLevel = logLevel;
    }

    public String getPrefix() {
        return "MSG";
    }

    public Category getCategory() {
        return this.category;
    }

    public int getNumber() {
        return this.detailNumber;
    }

    public String getMessage() {
        return this.message;
    }

    public boolean equals(OXException e) {
        return OXExceptionFactory.getInstance().equals((OXExceptionCode)this, e);
    }

    public OXException create() {
        return this.create(new Object[]{this, new Object[0]});
    }

    public OXException create(Object ... args) {
        return this.create(null, args);
    }

    public OXException create(Throwable cause, Object ... args) {
        MimeMailException ret;
        Category category = this.getCategory();
        if (category.getLogLevel().implies(LogLevel.DEBUG)) {
            ret = new MimeMailException(this.getNumber(), MimeMailExceptionCode.prepareDisplayMessage(this.getMessage()), cause, args);
            ret.setLogMessage(this.getMessage(), args);
        } else if (OXExceptionFactory.DISPLAYABLE.contains(category.getType())) {
            ret = new MimeMailException(this.getNumber(), MimeMailExceptionCode.prepareDisplayMessage(this.getMessage()), cause, args);
            ret.setLogMessage(this.getMessage(), args);
        } else {
            String displayMessage = Category.EnumType.TRY_AGAIN.equals((Object)category.getType()) ? "A temporary error occurred inside the Open-Xchange server which prevented it from fulfilling the request.. Please try again later." : "An error occurred inside the Open-Xchange server which prevented it from fulfilling the request.";
            ret = new MimeMailException(this.getNumber(), displayMessage, cause, new Object[0]);
            ret.setLogMessage(this.getMessage(), args);
        }
        ret.addCategory(category);
        ret.setPrefix(this.getPrefix());
        if (null != this.logLevel) {
            ret.setLogLevel(this.logLevel);
        }
        return ret;
    }

    private static String prepareDisplayMessage(String displayMessage) {
        if (null == displayMessage) {
            return displayMessage;
        }
        int pos = MimeMailExceptionCode.toLowerCase(displayMessage).indexOf("error message: ");
        return pos < 0 ? displayMessage : displayMessage.substring(0, pos);
    }

    private static String toLowerCase(CharSequence chars) {
        if (null == chars) {
            return null;
        }
        int length = chars.length();
        StringAllocator builder = new StringAllocator(length);
        for (int i = 0; i < length; ++i) {
            char c = chars.charAt(i);
            builder.append(c >= 'A' && c <= 'Z' ? (char)(c ^ 0x20) : c);
        }
        return builder.toString();
    }
}

