/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.json.writer;

import com.openexchange.ajax.AJAXServlet;
import com.openexchange.ajax.Folder;
import com.openexchange.ajax.customizer.folder.AdditionalFolderField;
import com.openexchange.ajax.customizer.folder.AdditionalFolderFieldList;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.java.StringAllocator;
import com.openexchange.log.LogFactory;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.mail.api.MailConfig;
import com.openexchange.mail.config.MailProperties;
import com.openexchange.mail.dataobjects.MailFolder;
import com.openexchange.mail.permission.DefaultMailPermission;
import com.openexchange.mail.permission.MailPermission;
import com.openexchange.mail.utils.MailFolderUtility;
import com.openexchange.server.impl.OCLPermission;
import com.openexchange.tools.oxfolder.OXFolderExceptionCode;
import com.openexchange.tools.session.ServerSession;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import org.apache.commons.logging.Log;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class FolderWriter {
    private static final Log LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(FolderWriter.class));
    private static final TIntObjectMap<MailFolderFieldWriter> WRITERS_MAP = new TIntObjectHashMap(20);
    private static final int[] ALL_FLD_FIELDS;
    private static final int BIT_USER_FLAG = 0x20000000;
    private static final int[] mapping;

    private FolderWriter() {
    }

    public static JSONObject writeMailFolder(int accountId, MailFolder folder, MailConfig mailConfig, ServerSession session) throws OXException {
        MailFolderFieldWriter[] writers;
        JSONObject jsonObject = new JSONObject();
        JSONObjectPutter putter = new JSONObjectPutter(jsonObject);
        for (MailFolderFieldWriter writer : writers = FolderWriter.getMailFolderFieldWriter(ALL_FLD_FIELDS, mailConfig, session)) {
            writer.writeField(putter, accountId, folder);
        }
        return jsonObject;
    }

    public static MailFolderFieldWriter[] getMailFolderFieldWriter(int[] fields, MailConfig mailConfig, ServerSession session) {
        return FolderWriter.getMailFolderFieldWriter(fields, mailConfig, session, Folder.getAdditionalFields());
    }

    public static MailFolderFieldWriter[] getMailFolderFieldWriter(int[] fields, MailConfig mailConfig, final ServerSession session, AdditionalFolderFieldList additionalFields) {
        MailFolderFieldWriter[] retval = new MailFolderFieldWriter[fields.length];
        for (int i = 0; i < retval.length; ++i) {
            int curField = fields[i];
            MailFolderFieldWriter mffw = (MailFolderFieldWriter)WRITERS_MAP.get(curField);
            if (mffw == null) {
                if (313 == curField) {
                    retval[i] = new ExtendedMailFolderFieldWriter(mailConfig){

                        @Override
                        public void writeField(JSONValuePutter putter, int accountId, MailFolder folder, String name, int hasSubfolders, String fullName, int module, boolean all) throws OXException {
                            try {
                                putter.put("capabilities", this.mailConfig.getCapabilities().getCapabilities());
                            }
                            catch (JSONException e) {
                                throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
                            }
                        }
                    };
                    continue;
                }
                if (!additionalFields.knows(curField) && LOG.isWarnEnabled()) {
                    LOG.warn((Object)("Unknown folder field: " + curField));
                }
                final AdditionalFolderField folderField = additionalFields.get(curField);
                retval[i] = new MailFolderFieldWriter(){

                    @Override
                    public void writeField(JSONValuePutter putter, int accountId, MailFolder folder, String name, int hasSubfolders, String fullName, int module, boolean all) throws OXException {
                        try {
                            FolderObject fo = new FolderObject();
                            fo.setFullName(folder.getFullname());
                            fo.setFolderName(folder.getName());
                            fo.setModule(7);
                            fo.setType(1);
                            fo.setCreatedBy(-1);
                            putter.put(folderField.getColumnName(), folderField.renderJSON(folderField.getValue(fo, session)));
                        }
                        catch (JSONException e) {
                            throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
                        }
                    }
                };
                continue;
            }
            retval[i] = mffw;
        }
        return retval;
    }

    static int createPermissionBits(OCLPermission perm) throws OXException {
        return FolderWriter.createPermissionBits(perm.getFolderPermission(), perm.getReadPermission(), perm.getWritePermission(), perm.getDeletePermission(), perm.isFolderAdmin());
    }

    static int createPermissionBits(int fp, int orp, int owp, int odp, boolean adminFlag) throws OXException {
        int[] perms = new int[]{fp == 64 ? 128 : fp, orp == 64 ? 128 : orp, owp == 64 ? 128 : owp, odp == 64 ? 128 : odp, adminFlag ? 1 : 0};
        return FolderWriter.createPermissionBits(perms);
    }

    private static int createPermissionBits(int[] permission) throws OXException {
        int retval = 0;
        boolean first = true;
        for (int i = permission.length - 1; i >= 0; --i) {
            int shiftVal = i * 7;
            if (first) {
                retval += permission[i] << shiftVal;
                first = false;
                continue;
            }
            if (permission[i] == 128) {
                retval += 64 << shiftVal;
                continue;
            }
            try {
                retval += mapping[permission[i]] << shiftVal;
                continue;
            }
            catch (Exception e) {
                throw OXFolderExceptionCode.MAP_PERMISSION_FAILED.create(e, permission[i]);
            }
        }
        return retval;
    }

    static {
        WRITERS_MAP.put(1, (Object)new MailFolderFieldWriter(){

            @Override
            public void writeField(JSONValuePutter putter, int accountId, MailFolder folder, String name, int hasSubfolders, String fullName, int module, boolean all) throws OXException {
                try {
                    if (null == fullName) {
                        String value;
                        String string = value = accountId >= 0 ? MailFolderUtility.prepareFullname(accountId, folder.getFullname()) : folder.getFullname();
                        if (null == value) {
                            throw MailExceptionCode.MISSING_FULLNAME.create();
                        }
                        putter.put("id", value);
                    } else {
                        putter.put("id", fullName);
                    }
                }
                catch (JSONException e) {
                    throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
                }
            }
        });
        WRITERS_MAP.put(2, (Object)new MailFolderFieldWriter(){

            @Override
            public void writeField(JSONValuePutter putter, int accountId, MailFolder folder, String name, int hasSubfolders, String fullName, int module, boolean all) throws OXException {
                try {
                    putter.put("created_by", -1);
                }
                catch (JSONException e) {
                    throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
                }
            }
        });
        WRITERS_MAP.put(3, (Object)new MailFolderFieldWriter(){

            @Override
            public void writeField(JSONValuePutter putter, int accountId, MailFolder folder, String name, int hasSubfolders, String fullName, int module, boolean all) throws OXException {
                try {
                    putter.put("modified_by", -1);
                }
                catch (JSONException e) {
                    throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
                }
            }
        });
        WRITERS_MAP.put(4, (Object)new MailFolderFieldWriter(){

            @Override
            public void writeField(JSONValuePutter putter, int accountId, MailFolder folder, String name, int hasSubfolders, String fullName, int module, boolean all) throws OXException {
                try {
                    putter.put("creation_date", 0);
                }
                catch (JSONException e) {
                    throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
                }
            }
        });
        WRITERS_MAP.put(5, (Object)new MailFolderFieldWriter(){

            @Override
            public void writeField(JSONValuePutter putter, int accountId, MailFolder folder, String name, int hasSubfolders, String fullName, int module, boolean all) throws OXException {
                try {
                    putter.put("last_modified", 0);
                }
                catch (JSONException e) {
                    throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
                }
            }
        });
        WRITERS_MAP.put(20, (Object)new MailFolderFieldWriter(){

            @Override
            public void writeField(JSONValuePutter putter, int accountId, MailFolder folder, String name, int hasSubfolders, String fullName, int module, boolean all) throws OXException {
                try {
                    Object parent = null == folder.getParentFullname() ? Integer.valueOf(1) : (accountId >= 0 ? MailFolderUtility.prepareFullname(accountId, folder.getParentFullname()) : folder.getParentFullname());
                    putter.put("folder_id", parent);
                }
                catch (JSONException e) {
                    throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
                }
            }
        });
        WRITERS_MAP.put(300, (Object)new MailFolderFieldWriter(){

            @Override
            public void writeField(JSONValuePutter putter, int accountId, MailFolder folder, String name, int hasSubfolders, String fullName, int module, boolean all) throws OXException {
                try {
                    putter.put("title", name == null ? folder.getName() : name);
                }
                catch (JSONException e) {
                    throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
                }
            }
        });
        WRITERS_MAP.put(301, (Object)new MailFolderFieldWriter(){

            @Override
            public void writeField(JSONValuePutter putter, int accountId, MailFolder folder, String name, int hasSubfolders, String fullName, int module, boolean all) throws OXException {
                try {
                    putter.put("module", AJAXServlet.getModuleString(module == -1 ? 7 : module, -1));
                }
                catch (JSONException e) {
                    throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
                }
            }
        });
        WRITERS_MAP.put(302, (Object)new MailFolderFieldWriter(){

            @Override
            public void writeField(JSONValuePutter putter, int accountId, MailFolder folder, String name, int hasSubfolders, String fullName, int module, boolean all) throws OXException {
                try {
                    putter.put("type", 7);
                }
                catch (JSONException e) {
                    throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
                }
            }
        });
        WRITERS_MAP.put(304, (Object)new MailFolderFieldWriter(){

            @Override
            public void writeField(JSONValuePutter putter, int accountId, MailFolder folder, String name, int hasSubfolders, String fullName, int module, boolean all) throws OXException {
                try {
                    boolean boolVal = hasSubfolders == -1 ? (all ? folder.hasSubfolders() : folder.hasSubscribedSubfolders()) : hasSubfolders > 0;
                    putter.put("subfolders", boolVal);
                }
                catch (JSONException e) {
                    throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
                }
            }
        });
        WRITERS_MAP.put(305, (Object)new MailFolderFieldWriter(){

            @Override
            public void writeField(JSONValuePutter putter, int accountId, MailFolder folder, String name, int hasSubfolders, String fullName, int module, boolean all) throws OXException {
                try {
                    MailPermission mp;
                    if (folder.isRootFolder()) {
                        MailPermission rootPermission = folder.getOwnPermission();
                        if (rootPermission == null) {
                            mp = new DefaultMailPermission();
                            mp.setAllPermission(8, 0, 0, 0);
                            mp.setFolderAdmin(false);
                        } else {
                            mp = rootPermission;
                        }
                    } else {
                        mp = folder.getOwnPermission();
                    }
                    if (!folder.isHoldsFolders() && mp.canCreateSubfolders()) {
                        mp.setFolderPermission(4);
                    }
                    if (!folder.isHoldsMessages() && mp.canReadOwnObjects()) {
                        mp.setReadObjectPermission(0);
                    }
                    int permissionBits = FolderWriter.createPermissionBits(mp);
                    if (folder.isSupportsUserFlags()) {
                        permissionBits |= 0x20000000;
                    }
                    putter.put("own_rights", permissionBits);
                }
                catch (JSONException e) {
                    throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
                }
            }
        });
        WRITERS_MAP.put(306, (Object)new MailFolderFieldWriter(){

            @Override
            public void writeField(JSONValuePutter putter, int accountId, MailFolder folder, String name, int hasSubfolders, String fullName, int module, boolean all) throws OXException {
                try {
                    JSONArray ja = new JSONArray();
                    MailPermission[] perms = folder.getPermissions();
                    for (int j = 0; j < perms.length; ++j) {
                        JSONObject jo = new JSONObject();
                        jo.put("bits", FolderWriter.createPermissionBits(perms[j]));
                        jo.put("entity", perms[j].getEntity());
                        jo.put("group", perms[j].isGroupPermission());
                        ja.put((Object)jo);
                    }
                    putter.put("permissions", ja);
                }
                catch (JSONException e) {
                    throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
                }
            }
        });
        WRITERS_MAP.put(307, (Object)new MailFolderFieldWriter(){

            @Override
            public void writeField(JSONValuePutter putter, int accountId, MailFolder folder, String name, int hasSubfolders, String fullName, int module, boolean all) throws OXException {
                try {
                    String value = folder.isRootFolder() ? "" : new StringAllocator(16).append('(').append(folder.getMessageCount()).append('/').append(folder.getUnreadMessageCount()).append(')').toString();
                    putter.put("summary", value);
                }
                catch (JSONException e) {
                    throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
                }
            }
        });
        WRITERS_MAP.put(308, (Object)new MailFolderFieldWriter(){

            @Override
            public void writeField(JSONValuePutter putter, int accountId, MailFolder folder, String name, int hasSubfolders, String fullName, int module, boolean all) throws OXException {
                try {
                    putter.put("standard_folder", folder.containsDefaultFolder() ? folder.isDefaultFolder() : false);
                }
                catch (JSONException e) {
                    throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
                }
            }
        });
        WRITERS_MAP.put(309, (Object)new MailFolderFieldWriter(){

            @Override
            public void writeField(JSONValuePutter putter, int accountId, MailFolder folder, String name, int hasSubfolders, String fullName, int module, boolean all) throws OXException {
                try {
                    putter.put("total", folder.getMessageCount());
                }
                catch (JSONException e) {
                    throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
                }
            }
        });
        WRITERS_MAP.put(310, (Object)new MailFolderFieldWriter(){

            @Override
            public void writeField(JSONValuePutter putter, int accountId, MailFolder folder, String name, int hasSubfolders, String fullName, int module, boolean all) throws OXException {
                try {
                    putter.put("new", folder.getNewMessageCount());
                }
                catch (JSONException e) {
                    throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
                }
            }
        });
        WRITERS_MAP.put(311, (Object)new MailFolderFieldWriter(){

            @Override
            public void writeField(JSONValuePutter putter, int accountId, MailFolder folder, String name, int hasSubfolders, String fullName, int module, boolean all) throws OXException {
                try {
                    putter.put("unread", folder.getUnreadMessageCount());
                }
                catch (JSONException e) {
                    throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
                }
            }
        });
        WRITERS_MAP.put(312, (Object)new MailFolderFieldWriter(){

            @Override
            public void writeField(JSONValuePutter putter, int accountId, MailFolder folder, String name, int hasSubfolders, String fullName, int module, boolean all) throws OXException {
                try {
                    putter.put("deleted", folder.getDeletedMessageCount());
                }
                catch (JSONException e) {
                    throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
                }
            }
        });
        WRITERS_MAP.put(314, (Object)new MailFolderFieldWriter(){

            @Override
            public void writeField(JSONValuePutter putter, int accountId, MailFolder folder, String name, int hasSubfolders, String fullName, int module, boolean all) throws OXException {
                try {
                    Object boolVal = MailProperties.getInstance().isIgnoreSubscription() ? Boolean.TRUE : (folder.containsSubscribed() ? Boolean.valueOf(folder.isSubscribed()) : JSONObject.NULL);
                    putter.put("subscribed", boolVal);
                }
                catch (JSONException e) {
                    throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
                }
            }
        });
        WRITERS_MAP.put(315, (Object)new MailFolderFieldWriter(){

            @Override
            public void writeField(JSONValuePutter putter, int accountId, MailFolder folder, String name, int hasSubfolders, String fullName, int module, boolean all) throws OXException {
                try {
                    Boolean boolVal = MailProperties.getInstance().isIgnoreSubscription() ? (hasSubfolders == -1 ? Boolean.valueOf(folder.hasSubfolders()) : Boolean.valueOf(hasSubfolders > 0)) : (hasSubfolders == -1 ? (folder.hasSubfolders() ? Boolean.valueOf(folder.hasSubscribedSubfolders()) : Boolean.FALSE) : Boolean.valueOf(hasSubfolders > 0));
                    putter.put("subscr_subflds", boolVal);
                }
                catch (JSONException e) {
                    throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
                }
            }
        });
        ALL_FLD_FIELDS = com.openexchange.ajax.writer.FolderWriter.getAllFolderFields();
        mapping = new int[]{0, -1, 1, -1, 2, -1, -1, -1, 4};
    }

    private static abstract class ExtendedMailFolderFieldWriter
    extends MailFolderFieldWriter {
        final MailConfig mailConfig;

        public ExtendedMailFolderFieldWriter(MailConfig mailConfig) {
            this.mailConfig = mailConfig;
        }
    }

    public static abstract class MailFolderFieldWriter {
        public void writeField(JSONValuePutter jsonContainer, int accountId, MailFolder folder) throws OXException {
            this.writeField(jsonContainer, accountId, folder, null, -1);
        }

        public void writeField(JSONValuePutter jsonContainer, int accountId, MailFolder folder, String name, int hasSubfolders) throws OXException {
            this.writeField(jsonContainer, accountId, folder, name, hasSubfolders, null, -1, false);
        }

        public abstract void writeField(JSONValuePutter var1, int var2, MailFolder var3, String var4, int var5, String var6, int var7, boolean var8) throws OXException;
    }

    public static final class JSONObjectPutter
    implements JSONValuePutter {
        private JSONObject jsonObject;

        public JSONObjectPutter() {
        }

        public JSONObjectPutter(JSONObject jsonObject) {
            this();
            this.jsonObject = jsonObject;
        }

        public JSONObjectPutter setJSONObject(JSONObject jsonObject) {
            this.jsonObject = jsonObject;
            return this;
        }

        @Override
        public void put(String key, Object value) throws JSONException {
            if (null == value || JSONObject.NULL.equals(value) || null == key) {
                return;
            }
            this.jsonObject.put(key, value);
        }
    }

    public static final class JSONArrayPutter
    implements JSONValuePutter {
        private JSONArray jsonArray;

        public JSONArrayPutter() {
        }

        public JSONArrayPutter(JSONArray jsonArray) {
            this();
            this.jsonArray = jsonArray;
        }

        public JSONArrayPutter setJSONArray(JSONArray jsonArray) {
            this.jsonArray = jsonArray;
            return this;
        }

        @Override
        public void put(String key, Object value) throws JSONException {
            this.jsonArray.put(value);
        }
    }

    public static interface JSONValuePutter {
        public void put(String var1, Object var2) throws JSONException;
    }
}

