/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.json.actions;

import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.documentation.RequestMethod;
import com.openexchange.documentation.annotations.Action;
import com.openexchange.documentation.annotations.Parameter;
import com.openexchange.exception.OXException;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.mail.MailServletInterface;
import com.openexchange.mail.json.MailRequest;
import com.openexchange.mail.json.actions.AbstractMailAction;
import com.openexchange.server.ServiceLookup;
import org.json.JSONArray;
import org.json.JSONException;

@Action(method=RequestMethod.PUT, name="expunge", description="Expunges mail folder(s).", parameters={@Parameter(name="session", description="A session ID previously obtained from the login module."), @Parameter(name="timestamp", description="Timestamp of the last update of the deleted mails.")}, requestBody="An array with IDs of the mail folders to expunge.", responseDescription="An array with IDs of mail folder that could not be expunged; meaning the response body is an empty JSON array if everything went well.")
public final class ExpungeAction
extends AbstractMailAction {
    public ExpungeAction(ServiceLookup services) {
        super(services);
    }

    @Override
    protected AJAXRequestResult perform(MailRequest req) throws OXException {
        try {
            JSONArray ja = (JSONArray)req.getRequest().getData();
            boolean hardDelete = req.optBool("harddelete", false);
            MailServletInterface mailInterface = this.getMailInterface(req);
            int length = ja.length();
            JSONArray ret = new JSONArray();
            for (int i = 0; i < length; ++i) {
                String folderId = ja.getString(i);
                if (mailInterface.expungeFolder(folderId, hardDelete)) continue;
                ret.put((Object)folderId);
            }
            return new AJAXRequestResult((Object)ret, "json");
        }
        catch (JSONException e) {
            throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
        }
        catch (RuntimeException e) {
            throw MailExceptionCode.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
    }
}

