/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.json.actions;

import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.documentation.RequestMethod;
import com.openexchange.documentation.annotations.Action;
import com.openexchange.documentation.annotations.Parameter;
import com.openexchange.exception.OXException;
import com.openexchange.json.OXJSONWriter;
import com.openexchange.mail.FullnameArgument;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.mail.MailPath;
import com.openexchange.mail.MailServletInterface;
import com.openexchange.mail.json.MailRequest;
import com.openexchange.mail.json.actions.AbstractMailAction;
import com.openexchange.mail.utils.MailFolderUtility;
import com.openexchange.server.ServiceLookup;
import java.util.ArrayList;
import java.util.Collections;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Action(method=RequestMethod.PUT, name="delete", description="Delete mails", parameters={@Parameter(name="session", description="A session ID previously obtained from the login module."), @Parameter(name="timestamp", description="Timestamp of the last update of the deleted mails.")}, requestBody="An array of objects providing folder IDs and object IDs of the deleted mails. [{ \"folder\":\"default0/INBOX\", \"id\":\"123\" } ... { \"folder\":\"default0/MyFolder\", \"id\":\"134\" }]", responseDescription="An array with object IDs of mails which were modified after the specified timestamp and were therefore not deleted.")
public final class DeleteAction
extends AbstractMailAction {
    public DeleteAction(ServiceLookup services) {
        super(services);
    }

    @Override
    protected AJAXRequestResult perform(MailRequest req) throws OXException {
        try {
            boolean hardDelete = "1".equals(req.getParameter("harddelete"));
            JSONArray jsonIDs = (JSONArray)req.getRequest().getData();
            MailServletInterface mailInterface = this.getMailInterface(req);
            OXJSONWriter jsonWriter = new OXJSONWriter();
            jsonWriter.array();
            int length = jsonIDs.length();
            if (length > 0) {
                ArrayList<MailPath> l = new ArrayList<MailPath>(length);
                for (int i = 0; i < length; ++i) {
                    JSONObject obj = jsonIDs.getJSONObject(i);
                    FullnameArgument fa = MailFolderUtility.prepareMailFolderParam(obj.getString("folder"));
                    l.add(new MailPath(fa.getAccountId(), fa.getFullname(), obj.getString("id")));
                }
                Collections.sort(l, MailPath.COMPARATOR);
                String lastFldArg = ((MailPath)l.get(0)).getFolderArgument();
                ArrayList<String> arr = new ArrayList<String>(length);
                for (int i = 0; i < length; ++i) {
                    MailPath current = (MailPath)l.get(i);
                    String folderArgument = current.getFolderArgument();
                    if (!lastFldArg.equals(folderArgument)) {
                        String[] uids = arr.toArray(new String[arr.size()]);
                        mailInterface.deleteMessages(lastFldArg, uids, hardDelete);
                        arr.clear();
                        lastFldArg = folderArgument;
                    }
                    arr.add(current.getMailID());
                }
                if (arr.size() > 0) {
                    String[] uids = arr.toArray(new String[arr.size()]);
                    mailInterface.deleteMessages(lastFldArg, uids, hardDelete);
                }
            }
            jsonWriter.endArray();
            return new AJAXRequestResult((Object)jsonWriter.getObject(), "json");
        }
        catch (JSONException e) {
            throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
        }
        catch (RuntimeException e) {
            throw MailExceptionCode.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
    }
}

