/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.dataobjects;

import com.openexchange.exception.OXException;
import com.openexchange.java.StringAllocator;
import com.openexchange.mail.dataobjects.MailMessage;
import com.openexchange.mail.dataobjects.MailPart;
import com.openexchange.mail.mime.ContentType;
import java.util.ArrayList;
import java.util.List;

public final class MailStructure {
    private final ContentType contentType = new ContentType();
    private final List<MailStructure> subStructures;

    public MailStructure() {
        this.subStructures = new ArrayList<MailStructure>(4);
    }

    public MailStructure(ContentType contentType) {
        this.contentType.setContentType(contentType);
        this.subStructures = new ArrayList<MailStructure>(4);
    }

    public ContentType getContentType() {
        return this.contentType;
    }

    public void setContentType(ContentType contentType) {
        this.contentType.setContentType(contentType);
    }

    public void addSubStructure(MailStructure mailStructure) {
        this.subStructures.add(mailStructure);
    }

    public MailStructure[] getSubStructures() {
        return this.subStructures.toArray(new MailStructure[this.subStructures.size()]);
    }

    public static MailStructure getMailStructure(MailMessage mail) throws OXException {
        return MailStructure.getMailStructure0(mail);
    }

    public String toString() {
        StringAllocator sb = new StringAllocator(256);
        sb.append(this.contentType.getBaseType().toString());
        MailStructure[] subStructures = this.getSubStructures();
        if (subStructures.length > 0) {
            sb.append(" (").append(subStructures[0].toString());
            for (int i = 1; i < subStructures.length; ++i) {
                sb.append(", ").append(subStructures[i].toString());
            }
            sb.append(')');
        }
        return sb.toString();
    }

    private static MailStructure getMailStructure0(MailPart part) throws OXException {
        MailStructure retval;
        ContentType ct = part.getContentType();
        if (ct.isMimeType("multipart/*")) {
            MailStructure multi = new MailStructure(ct);
            int count = part.getEnclosedCount();
            for (int i = 0; i < count; ++i) {
                multi.addSubStructure(MailStructure.getMailStructure0(part.getEnclosedMailPart(i)));
            }
            retval = multi;
        } else if (ct.isMimeType("message/rfc822")) {
            MailStructure nested = new MailStructure(ct);
            nested.addSubStructure(MailStructure.getMailStructure0((MailMessage)part.getContent()));
            retval = nested;
        } else {
            retval = new MailStructure(ct);
        }
        return retval;
    }
}

