/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.json.cache.impl.osgi;

import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.update.PerformParameters;
import com.openexchange.groupware.update.UpdateExceptionCodes;
import com.openexchange.groupware.update.UpdateTaskAdapter;
import com.openexchange.json.cache.impl.osgi.JsonCacheCreateTableService;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import com.openexchange.tools.sql.DBUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class JsonCacheCreateTableTask
extends UpdateTaskAdapter {
    @Override
    public void perform(PerformParameters params) throws OXException {
        int contextId = params.getContextId();
        Connection writeCon = Database.getNoTimeout(contextId, true);
        PreparedStatement stmt = null;
        boolean transactional = false;
        try {
            DBUtils.startTransaction(writeCon);
            transactional = true;
            String[] tableNames = JsonCacheCreateTableService.getTablesToCreate();
            String[] createStmts = JsonCacheCreateTableService.getCreateStmts();
            for (int i = 0; i < tableNames.length; ++i) {
                try {
                    if (DBUtils.tableExists(writeCon, tableNames[i])) continue;
                    stmt = writeCon.prepareStatement(createStmts[i]);
                    stmt.executeUpdate();
                    continue;
                }
                catch (SQLException e) {
                    throw UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
                }
            }
            writeCon.commit();
        }
        catch (OXException e) {
            if (transactional) {
                DBUtils.rollback(writeCon);
            }
            throw e;
        }
        catch (Exception e) {
            if (transactional) {
                DBUtils.rollback(writeCon);
            }
            throw AjaxExceptionCodes.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
        finally {
            DBUtils.closeSQLStuff(stmt);
            if (transactional) {
                DBUtils.autocommit(writeCon);
            }
            Database.backNoTimeout(contextId, true, writeCon);
        }
    }

    @Override
    public String[] getDependencies() {
        return new String[0];
    }
}

