/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.json.cache.impl;

import com.openexchange.java.Streams;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Scanner;

public final class LzwCompression {
    private final int[][] dictionary = new int[4000][4000];
    private final int[] pattern = new int[4000];
    private final int[] element = new int[4000];
    private final int[] chars = new int[256];
    private final int[] chfreq = new int[256];
    private final float[] chprobs = new float[256];
    private final int[] ofreq = new int[4000];
    private int dfree;
    private int psize;
    private int esize;
    private int top;
    private int tc;
    private int chnext;

    public void init() {
        int i;
        for (i = 0; i < 4000; ++i) {
            for (int j = 0; j < 4000; ++j) {
                this.dictionary[i][j] = -1;
            }
        }
        for (i = 0; i < 4000; ++i) {
            this.pattern[i] = -1;
            this.element[i] = -1;
            this.ofreq[i] = 0;
        }
        for (i = 0; i < 256; ++i) {
            this.chars[i] = -1;
            this.chfreq[i] = 0;
            this.chprobs[i] = 0.0f;
        }
        this.dictionary[0][0] = 0;
        this.dictionary[1][0] = 1;
        this.dictionary[2][0] = 2;
        this.dictionary[3][0] = 3;
        this.dictionary[4][0] = 4;
        this.dictionary[5][0] = 5;
        this.dictionary[6][0] = 6;
        this.dictionary[7][0] = 7;
        this.dictionary[8][0] = 8;
        this.dictionary[9][0] = 9;
        this.dictionary[10][0] = 10;
        this.dictionary[11][0] = 11;
        this.dictionary[12][0] = 12;
        this.dictionary[13][0] = 13;
        this.dictionary[14][0] = 14;
        this.dictionary[15][0] = 15;
        this.dictionary[16][0] = 16;
        this.dictionary[17][0] = 17;
        this.dictionary[18][0] = 18;
        this.dictionary[19][0] = 19;
        this.dictionary[20][0] = 20;
        this.dictionary[21][0] = 21;
        this.dictionary[22][0] = 22;
        this.dictionary[23][0] = 23;
        this.dictionary[24][0] = 24;
        this.dictionary[25][0] = 25;
        this.dictionary[26][0] = 26;
        this.dictionary[27][0] = 27;
        this.dictionary[28][0] = 28;
        this.dictionary[29][0] = 29;
        this.dictionary[30][0] = 30;
        this.dictionary[31][0] = 31;
        this.dictionary[32][0] = 32;
        this.dictionary[33][0] = 33;
        this.dictionary[34][0] = 34;
        this.dictionary[35][0] = 35;
        this.dictionary[36][0] = 36;
        this.dictionary[37][0] = 37;
        this.dictionary[38][0] = 38;
        this.dictionary[39][0] = 39;
        this.dictionary[40][0] = 40;
        this.dictionary[41][0] = 41;
        this.dictionary[42][0] = 42;
        this.dictionary[43][0] = 43;
        this.dictionary[44][0] = 44;
        this.dictionary[45][0] = 45;
        this.dictionary[46][0] = 46;
        this.dictionary[47][0] = 47;
        this.dictionary[48][0] = 48;
        this.dictionary[49][0] = 49;
        this.dictionary[50][0] = 50;
        this.dictionary[51][0] = 51;
        this.dictionary[52][0] = 52;
        this.dictionary[53][0] = 53;
        this.dictionary[54][0] = 54;
        this.dictionary[55][0] = 55;
        this.dictionary[56][0] = 56;
        this.dictionary[57][0] = 57;
        this.dictionary[58][0] = 58;
        this.dictionary[59][0] = 59;
        this.dictionary[60][0] = 60;
        this.dictionary[61][0] = 61;
        this.dictionary[62][0] = 62;
        this.dictionary[63][0] = 63;
        this.dictionary[64][0] = 64;
        this.dictionary[65][0] = 65;
        this.dictionary[66][0] = 66;
        this.dictionary[67][0] = 67;
        this.dictionary[68][0] = 68;
        this.dictionary[69][0] = 69;
        this.dictionary[70][0] = 70;
        this.dictionary[71][0] = 71;
        this.dictionary[72][0] = 72;
        this.dictionary[73][0] = 73;
        this.dictionary[74][0] = 74;
        this.dictionary[75][0] = 75;
        this.dictionary[76][0] = 76;
        this.dictionary[77][0] = 77;
        this.dictionary[78][0] = 78;
        this.dictionary[79][0] = 79;
        this.dictionary[80][0] = 80;
        this.dictionary[81][0] = 81;
        this.dictionary[82][0] = 82;
        this.dictionary[83][0] = 83;
        this.dictionary[84][0] = 84;
        this.dictionary[85][0] = 85;
        this.dictionary[86][0] = 86;
        this.dictionary[87][0] = 87;
        this.dictionary[88][0] = 88;
        this.dictionary[89][0] = 89;
        this.dictionary[90][0] = 90;
        this.dictionary[91][0] = 91;
        this.dictionary[92][0] = 92;
        this.dictionary[93][0] = 93;
        this.dictionary[94][0] = 94;
        this.dictionary[95][0] = 95;
        this.dictionary[96][0] = 96;
        this.dictionary[97][0] = 97;
        this.dictionary[98][0] = 98;
        this.dictionary[99][0] = 99;
        this.dictionary[100][0] = 100;
        this.dictionary[101][0] = 101;
        this.dictionary[102][0] = 102;
        this.dictionary[103][0] = 103;
        this.dictionary[104][0] = 104;
        this.dictionary[105][0] = 105;
        this.dictionary[106][0] = 106;
        this.dictionary[107][0] = 107;
        this.dictionary[108][0] = 108;
        this.dictionary[109][0] = 109;
        this.dictionary[110][0] = 110;
        this.dictionary[111][0] = 111;
        this.dictionary[112][0] = 112;
        this.dictionary[113][0] = 113;
        this.dictionary[114][0] = 114;
        this.dictionary[115][0] = 115;
        this.dictionary[116][0] = 116;
        this.dictionary[117][0] = 117;
        this.dictionary[118][0] = 118;
        this.dictionary[119][0] = 119;
        this.dictionary[120][0] = 120;
        this.dictionary[121][0] = 121;
        this.dictionary[122][0] = 122;
        this.dictionary[123][0] = 123;
        this.dictionary[124][0] = 124;
        this.dictionary[125][0] = 125;
        this.dictionary[126][0] = 126;
        this.dictionary[127][0] = 127;
        this.dictionary[128][0] = 128;
        this.dictionary[129][0] = 129;
        this.dictionary[130][0] = 130;
        this.dictionary[131][0] = 131;
        this.dictionary[132][0] = 132;
        this.dictionary[133][0] = 133;
        this.dictionary[134][0] = 134;
        this.dictionary[135][0] = 135;
        this.dictionary[136][0] = 136;
        this.dictionary[137][0] = 137;
        this.dictionary[138][0] = 138;
        this.dictionary[139][0] = 139;
        this.dictionary[140][0] = 140;
        this.dictionary[141][0] = 141;
        this.dictionary[142][0] = 142;
        this.dictionary[143][0] = 143;
        this.dictionary[144][0] = 144;
        this.dictionary[145][0] = 145;
        this.dictionary[146][0] = 146;
        this.dictionary[147][0] = 147;
        this.dictionary[148][0] = 148;
        this.dictionary[149][0] = 149;
        this.dictionary[150][0] = 150;
        this.dictionary[151][0] = 151;
        this.dictionary[152][0] = 152;
        this.dictionary[153][0] = 153;
        this.dictionary[154][0] = 154;
        this.dictionary[155][0] = 155;
        this.dictionary[156][0] = 156;
        this.dictionary[157][0] = 157;
        this.dictionary[158][0] = 158;
        this.dictionary[159][0] = 159;
        this.dictionary[160][0] = 160;
        this.dictionary[161][0] = 161;
        this.dictionary[162][0] = 162;
        this.dictionary[163][0] = 163;
        this.dictionary[164][0] = 164;
        this.dictionary[165][0] = 165;
        this.dictionary[166][0] = 166;
        this.dictionary[167][0] = 167;
        this.dictionary[168][0] = 168;
        this.dictionary[169][0] = 169;
        this.dictionary[170][0] = 170;
        this.dictionary[171][0] = 171;
        this.dictionary[172][0] = 172;
        this.dictionary[173][0] = 173;
        this.dictionary[174][0] = 174;
        this.dictionary[175][0] = 175;
        this.dictionary[176][0] = 176;
        this.dictionary[177][0] = 177;
        this.dictionary[178][0] = 178;
        this.dictionary[179][0] = 179;
        this.dictionary[180][0] = 180;
        this.dictionary[181][0] = 181;
        this.dictionary[182][0] = 182;
        this.dictionary[183][0] = 183;
        this.dictionary[184][0] = 184;
        this.dictionary[185][0] = 185;
        this.dictionary[186][0] = 186;
        this.dictionary[187][0] = 187;
        this.dictionary[188][0] = 188;
        this.dictionary[189][0] = 189;
        this.dictionary[190][0] = 190;
        this.dictionary[191][0] = 191;
        this.dictionary[192][0] = 192;
        this.dictionary[193][0] = 193;
        this.dictionary[194][0] = 194;
        this.dictionary[195][0] = 195;
        this.dictionary[196][0] = 196;
        this.dictionary[197][0] = 197;
        this.dictionary[198][0] = 198;
        this.dictionary[199][0] = 199;
        this.dictionary[200][0] = 200;
        this.dictionary[201][0] = 201;
        this.dictionary[202][0] = 202;
        this.dictionary[203][0] = 203;
        this.dictionary[204][0] = 204;
        this.dictionary[205][0] = 205;
        this.dictionary[206][0] = 206;
        this.dictionary[207][0] = 207;
        this.dictionary[208][0] = 208;
        this.dictionary[209][0] = 209;
        this.dictionary[210][0] = 210;
        this.dictionary[211][0] = 211;
        this.dictionary[212][0] = 212;
        this.dictionary[213][0] = 213;
        this.dictionary[214][0] = 214;
        this.dictionary[215][0] = 215;
        this.dictionary[216][0] = 216;
        this.dictionary[217][0] = 217;
        this.dictionary[218][0] = 218;
        this.dictionary[219][0] = 219;
        this.dictionary[220][0] = 220;
        this.dictionary[221][0] = 221;
        this.dictionary[222][0] = 222;
        this.dictionary[223][0] = 223;
        this.dictionary[224][0] = 224;
        this.dictionary[225][0] = 225;
        this.dictionary[226][0] = 226;
        this.dictionary[227][0] = 227;
        this.dictionary[228][0] = 228;
        this.dictionary[229][0] = 229;
        this.dictionary[230][0] = 230;
        this.dictionary[231][0] = 231;
        this.dictionary[232][0] = 232;
        this.dictionary[233][0] = 233;
        this.dictionary[234][0] = 234;
        this.dictionary[235][0] = 235;
        this.dictionary[236][0] = 236;
        this.dictionary[237][0] = 237;
        this.dictionary[238][0] = 238;
        this.dictionary[239][0] = 239;
        this.dictionary[240][0] = 240;
        this.dictionary[241][0] = 241;
        this.dictionary[242][0] = 242;
        this.dictionary[243][0] = 243;
        this.dictionary[244][0] = 244;
        this.dictionary[245][0] = 245;
        this.dictionary[246][0] = 246;
        this.dictionary[247][0] = 247;
        this.dictionary[248][0] = 248;
        this.dictionary[249][0] = 249;
        this.dictionary[250][0] = 250;
        this.dictionary[251][0] = 251;
        this.dictionary[252][0] = 252;
        this.dictionary[253][0] = 253;
        this.dictionary[254][0] = 254;
        this.dictionary[255][0] = 255;
        this.dfree = 256;
        this.tc = 0;
        this.top = 0;
        this.esize = 0;
        this.psize = 0;
        this.chnext = 0;
    }

    private float calcEntropy() {
        float sum = 0.0f;
        float inf = 0.0f;
        for (int i = 0; i < 256; ++i) {
            this.chprobs[i] = (float)this.chfreq[i] / (float)this.tc;
            if (!(this.chprobs[i] > 0.0f)) continue;
            inf = this.chprobs[i] * ((float)Math.log(1.0 / (double)this.chprobs[i]) / (float)Math.log(2.0));
            sum += inf;
        }
        return sum;
    }

    private float calcAvCodeLength() {
        int t = 0;
        int sum = 0;
        for (int i = 0; i < 4000; ++i) {
            if (this.ofreq[i] <= 0) continue;
            t = i < 256 ? this.ofreq[i] : 3 * this.ofreq[i];
            sum += t;
        }
        return (float)sum / (float)this.top;
    }

    private int inchars(int x) {
        for (int i = 0; i < this.chnext; ++i) {
            if (this.chars[i] != x) continue;
            return i;
        }
        return -1;
    }

    private boolean indict(int x) {
        this.pattern[this.psize] = x;
        ++this.psize;
        int index = -1;
        index = this.inchars(x);
        if (index != -1) {
            int n = index;
            this.chfreq[n] = this.chfreq[n] + 1;
            ++this.tc;
        } else {
            this.chars[this.chnext] = x;
            int n = this.chnext++;
            this.chfreq[n] = this.chfreq[n] + 1;
            ++this.tc;
        }
        for (int i = 0; i < 4000; ++i) {
            if (this.pattern[0] != this.dictionary[i][0]) continue;
            int n = 1;
            for (int j = 1; j < this.psize; ++j) {
                if (this.pattern[j] != this.dictionary[i][j]) continue;
                ++n;
            }
            if (n != this.psize) continue;
            return true;
        }
        this.pattern[this.psize - 1] = -1;
        --this.psize;
        return false;
    }

    private void index(OutputStream out) throws IOException {
        for (int i = 0; i < 4000; ++i) {
            if (this.pattern[0] != this.dictionary[i][0]) continue;
            int n = 1;
            for (int j = 1; j < this.psize; ++j) {
                if (this.pattern[j] != this.dictionary[i][j]) continue;
                ++n;
            }
            if (n != this.psize) continue;
            int n2 = i;
            this.ofreq[n2] = this.ofreq[n2] + 1;
            ++this.top;
            if (i > 255) {
                int k = 0;
                out.write(236);
                while (i > 255) {
                    i -= 255;
                    ++k;
                }
                out.write(k);
            }
            out.write(i);
            return;
        }
    }

    private void add(int x) {
        for (int i = 0; i < this.psize; ++i) {
            this.dictionary[this.dfree][i] = this.pattern[i];
        }
        this.dictionary[this.dfree][this.psize] = x;
        ++this.dfree;
    }

    private void clear() {
        for (int i = 0; i < this.psize; ++i) {
            this.pattern[i] = -1;
        }
        this.psize = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compress(InputStream in, OutputStream out) throws IOException {
        try {
            int x = in.read();
            while (x != -1) {
                if (!this.indict(x)) {
                    this.index(out);
                    this.add(x);
                    this.clear();
                    this.psize = 0;
                    this.pattern[0] = x;
                    ++this.psize;
                }
                x = in.read();
            }
            out.flush();
            this.index(out);
        }
        finally {
            LzwCompression.close(in);
            LzwCompression.close(out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decompress(InputStream in, OutputStream out) throws IOException {
        try {
            int x = in.read();
            if (x != -1) {
                this.element[0] = this.dictionary[x][0];
                ++this.esize;
                out.write(this.dictionary[x][0]);
            }
            this.pattern[0] = this.element[0];
            ++this.psize;
            while ((x = in.read()) != -1) {
                int i;
                if (x == 236) {
                    int k = in.read();
                    int l = in.read();
                    x = k * 255 + l;
                }
                if (x >= this.dfree) {
                    for (i = 0; i < this.esize; ++i) {
                        this.element[i] = -1;
                    }
                    this.esize = 0;
                    for (i = 0; i < this.psize; ++i) {
                        this.element[i] = this.pattern[i];
                        ++this.esize;
                    }
                    this.element[this.esize] = this.pattern[0];
                    ++this.esize;
                } else {
                    for (i = 0; i < this.esize; ++i) {
                        this.element[i] = -1;
                    }
                    this.esize = 0;
                    for (i = 0; i < 4000 && this.dictionary[x][i] != -1; ++i) {
                        this.element[i] = this.dictionary[x][i];
                        ++this.esize;
                    }
                }
                for (i = 0; i < this.esize; ++i) {
                    out.write(this.element[i]);
                }
                out.flush();
                for (i = 0; i < this.psize; ++i) {
                    this.dictionary[this.dfree][i] = this.pattern[i];
                }
                this.dictionary[this.dfree][this.psize] = this.element[0];
                ++this.dfree;
                this.clear();
                for (i = 0; i < this.esize; ++i) {
                    this.pattern[i] = this.element[i];
                    ++this.psize;
                }
            }
        }
        finally {
            LzwCompression.close(in);
            LzwCompression.close(out);
        }
    }

    private static void close(Closeable closeable) {
        Streams.close((Closeable)closeable);
    }

    public static void main(String[] args) throws Exception {
        Scanner cons = new Scanner(System.in);
        int ch = -1;
        System.out.println("Implementation of LZW compression and decompression algorithm\n\n");
        while (ch != 3) {
            LzwCompression lzw;
            String outfile;
            String infile;
            System.out.println("1. Compress a file");
            System.out.println("2. Decompress a file");
            System.out.println("3. Exit\n");
            System.out.print("Option: ");
            ch = Integer.parseInt(cons.nextLine());
            System.out.println();
            if (ch == 1) {
                System.out.print("Input file: ");
                infile = cons.nextLine();
                System.out.print("Output file: ");
                outfile = cons.nextLine();
                lzw = new LzwCompression();
                lzw.init();
                lzw.compress(new FileInputStream(infile), new FileOutputStream(outfile));
                File in = new File(infile);
                File out = new File(outfile);
                float cr = (float)out.length() / (float)in.length();
                float entropy = lzw.calcEntropy();
                float acl = lzw.calcAvCodeLength();
                System.out.println();
                System.out.print("Entropy of the source: " + entropy + "\n");
                System.out.print("Compression ratio: " + cr + "\n");
                System.out.print("Average code length in bytes: " + acl + "\n\n");
                continue;
            }
            if (ch != 2) continue;
            System.out.print("Input file: ");
            infile = cons.nextLine();
            System.out.print("Output file: ");
            outfile = cons.nextLine();
            lzw = new LzwCompression();
            lzw.init();
            lzw.decompress(new FileInputStream(infile), new FileOutputStream(outfile));
            System.out.print("\n\n");
        }
    }
}

